/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.exceptions.BadFormatException;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Utils;
import convex.net.Connection;
import convex.net.impl.HandlerException;
import convex.peer.Server;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOServer
implements Closeable {
    public static final int DEFAULT_PORT = 18888;
    private static final Logger log = LoggerFactory.getLogger((String)NIOServer.class.getName());
    protected static final long SELECT_TIMEOUT = 1000L;
    protected static final long PRUNE_TIMEOUT = 60000L;
    private ServerSocketChannel ssc = null;
    private Selector selector = null;
    private boolean running = false;
    private final Server server;
    long lastConnectionPrune = 0L;
    private Runnable selectorLoop = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Stores.setCurrent((AStore)NIOServer.this.server.getStore());
            try {
                while (NIOServer.this.running) {
                    if (Thread.currentThread().isInterrupted()) return;
                    NIOServer.this.selector.select(1000L);
                    Set<SelectionKey> keys = NIOServer.this.selector.selectedKeys();
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        SelectionKey key = (SelectionKey)it.next();
                        it.remove();
                        try {
                            if (key.isAcceptable()) {
                                NIOServer.this.accept(NIOServer.this.selector);
                            }
                            if (key.isReadable()) {
                                NIOServer.this.selectRead(key);
                            }
                            if (!key.isWritable()) continue;
                            NIOServer.this.selectWrite(key);
                        }
                        catch (IOException e) {
                            log.debug("IOException, closing channel");
                            key.cancel();
                        }
                        catch (CancelledKeyException e) {
                            log.debug("Cancelled key: {}", (Object)e.getMessage());
                            key.cancel();
                        }
                    }
                    long ts = System.currentTimeMillis();
                    if (ts <= NIOServer.this.lastConnectionPrune + 60000L) continue;
                    NIOServer.this.pruneConnections(ts, NIOServer.this.selector.keys());
                    NIOServer.this.lastConnectionPrune = ts;
                }
                return;
            }
            catch (IOException e) {
                log.error("Unexpected IO Exception, terminating selector loop: ", (Throwable)e);
                return;
            }
            finally {
                try {
                    for (SelectionKey key : NIOServer.this.selector.keys()) {
                        key.channel().close();
                    }
                    NIOServer.this.selector.close();
                    NIOServer.this.selector = null;
                }
                catch (IOException e) {
                    log.error("IOException while closing NIO server", (Throwable)e);
                }
                finally {
                    NIOServer.this.selector = null;
                }
                if (NIOServer.this.ssc != null) {
                    try {
                        NIOServer.this.ssc.close();
                    }
                    catch (IOException e) {
                        log.error("IOException while closing NIO socket channel", (Throwable)e);
                    }
                    finally {
                        NIOServer.this.ssc = null;
                    }
                }
                log.debug("Selector loop ended on port: " + NIOServer.this.getPort());
            }
        }
    };

    private NIOServer(Server server) {
        this.server = server;
    }

    public static NIOServer create(Server server) {
        return new NIOServer(server);
    }

    public void launch(String bindAddress, Integer port) throws IOException {
        InetSocketAddress address;
        if (port == null) {
            port = 0;
        }
        this.ssc = ServerSocketChannel.open();
        this.ssc.socket().setReceiveBufferSize(0x100000);
        this.ssc.socket().setReuseAddress(true);
        String string = bindAddress = bindAddress == null ? "::" : bindAddress;
        if (port == 0) {
            try {
                address = new InetSocketAddress(bindAddress, 18888);
                this.ssc.bind(address);
            }
            catch (IOException e) {
                address = new InetSocketAddress(bindAddress, 0);
                this.ssc.bind(address);
            }
        } else {
            address = new InetSocketAddress(bindAddress, (int)port);
            this.ssc.bind(address);
        }
        address = (InetSocketAddress)this.ssc.getLocalAddress();
        port = this.ssc.socket().getLocalPort();
        this.ssc.configureBlocking(false);
        this.selector = Selector.open();
        this.ssc.register(this.selector, 16);
        this.running = true;
        Thread selectorThread = new Thread(this.selectorLoop, "NIO Server loop on port: " + port);
        selectorThread.setDaemon(true);
        selectorThread.start();
        log.debug("NIO server started on port {}", (Object)port);
    }

    public int getPort() {
        if (this.ssc == null) {
            return 0;
        }
        ServerSocket socket = this.ssc.socket();
        if (socket == null) {
            return 0;
        }
        return socket.getLocalPort();
    }

    protected void pruneConnections(long ts, Set<SelectionKey> keys) {
        int n = keys.size();
        for (SelectionKey key : keys) {
            long age;
            Connection conn = (Connection)key.attachment();
            if (conn == null || (age = conn.getLastActivity() - ts) <= 1000000L / (long)(n + 10)) continue;
            log.info("Pruning inactive client connection, age = {}", (Object)age);
            conn.close();
            key.cancel();
        }
    }

    protected void selectWrite(SelectionKey key) throws IOException {
        this.ensureConnection(key);
        Connection.selectWrite(key);
    }

    private Connection ensureConnection(SelectionKey key) throws IOException {
        Connection clientConnection = (Connection)key.attachment();
        if (clientConnection != null) {
            return clientConnection;
        }
        SocketChannel sc = (SocketChannel)key.channel();
        assert (!sc.isBlocking());
        clientConnection = this.createClientConnection(sc);
        key.attach(clientConnection);
        return clientConnection;
    }

    private Connection createClientConnection(SocketChannel sc) throws IOException {
        return Connection.create(sc, this.server.getReceiveAction(), this.server.getStore(), null);
    }

    protected void selectRead(SelectionKey key) throws IOException {
        Connection conn = this.ensureConnection(key);
        if (conn == null) {
            throw new IOException("No Connection in selecion key");
        }
        try {
            int n = conn.handleChannelRecieve();
            if (n < 0) {
                key.cancel();
                log.trace("EOS on channel?");
            } else if (n == 0) {
                log.trace("No bytes received for key: {}", (Object)key);
            }
        }
        catch (SocketException | ClosedChannelException e) {
            log.trace("Channel closed (" + Utils.getClassName((Object)e) + ") from: {}", (Object)conn.getRemoteAddress());
            key.cancel();
        }
        catch (BadFormatException e) {
            log.info("Cancelled connection: Bad data format from: {} message: {}", (Object)conn.getRemoteAddress(), (Object)e.getMessage());
            key.cancel();
        }
        catch (HandlerException e) {
            log.warn("Unexpected exception in receive handler", e.getCause());
            key.cancel();
        }
    }

    public void finalize() {
        this.close();
    }

    @Override
    public void close() {
        this.running = false;
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    private void accept(Selector selector) throws IOException, ClosedChannelException {
        SocketChannel socketChannel = this.ssc.accept();
        if (socketChannel == null) {
            return;
        }
        log.debug("New connection accepted: {}", (Object)socketChannel);
        socketChannel.configureBlocking(false);
        socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        socketChannel.register(selector, 1);
    }

    public InetSocketAddress getHostAddress() {
        if (this.ssc == null) {
            return null;
        }
        ServerSocket socket = this.ssc.socket();
        if (socket == null) {
            return null;
        }
        return new InetSocketAddress(socket.getInetAddress(), socket.getLocalPort());
    }
}

