/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.Acquiror;
import convex.api.Convex;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.SourceCodes;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.SignedData;
import convex.core.exceptions.ResultException;
import convex.core.lang.RT;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.net.Connection;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvexRemote
extends Convex {
    protected Connection connection;
    private static final Logger log = LoggerFactory.getLogger((String)ConvexRemote.class.getName());
    protected InetSocketAddress remoteAddress;
    private static CompletableFuture<Result> closedResult = CompletableFuture.completedFuture(Result.error((Keyword)ErrorCodes.CLOSED, (String)"Transaction interrupted before sending").withSource(SourceCodes.COMM));

    @Override
    public InetSocketAddress getHostAddress() {
        return this.remoteAddress;
    }

    protected ConvexRemote(Address address, AKeyPair keyPair) {
        super(address, keyPair);
    }

    protected void connectToPeer(InetSocketAddress peerAddress, AStore store) throws IOException, TimeoutException {
        this.remoteAddress = peerAddress;
        this.setConnection(Connection.connect(peerAddress, this.messageHandler, store));
    }

    public void reconnect() throws IOException, TimeoutException {
        Connection curr = this.connection;
        AStore store = curr == null ? Stores.current() : curr.getStore();
        this.close();
        this.setConnection(Connection.connect(this.remoteAddress, this.messageHandler, store));
    }

    protected void setConnection(Connection conn) {
        Connection curr = this.connection;
        if (curr == conn) {
            return;
        }
        if (curr != null) {
            this.close();
        }
        this.connection = conn;
    }

    @Override
    public boolean isConnected() {
        Connection c = this.connection;
        return c != null && !c.isClosed();
    }

    public void closeButMaintainConnection() {
        this.connection = null;
        this.close();
    }

    @Override
    public CompletableFuture<State> acquireState() throws TimeoutException, InterruptedException {
        return this.requestStatus().thenCompose(status -> {
            Hash stateHash = RT.ensureHash((ACell)status.get(4L));
            if (stateHash == null) {
                return CompletableFuture.failedStage((Throwable)new ResultException(ErrorCodes.FORMAT, "Bad status response from Peer"));
            }
            return this.acquire(stateHash, Stores.current());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CompletableFuture<Result> transact(SignedData<ATransaction> signed) {
        long id = -1L;
        long wait = 10L;
        while (!this.connection.isClosed()) {
            try {
                HashMap hashMap = this.awaiting;
                synchronized (hashMap) {
                    id = this.connection.sendTransaction(signed);
                    if (id >= 0L) {
                        this.maybeUpdateSequence(signed);
                        CompletableFuture<Result> cf = this.awaitResult(id, this.timeout);
                        log.trace("Sent transaction with message ID: {} awaiting count = {}", (Object)id, (Object)this.awaiting.size());
                        return cf;
                    }
                }
                Thread.sleep(wait);
                wait += 1L + wait / 3L;
            }
            catch (InterruptedException e) {
                Result r = Result.fromException((Throwable)e);
                return CompletableFuture.completedFuture(r);
            }
            catch (IOException e) {
                Result r = Result.fromException((Throwable)e).withInfo(Keywords.SOURCE, (ACell)SourceCodes.COMM);
                return CompletableFuture.completedFuture(r);
            }
        }
        return closedResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result> query(ACell query, Address address) {
        long wait = 10L;
        while (!this.connection.isClosed()) {
            try {
                HashMap hashMap = this.awaiting;
                synchronized (hashMap) {
                    long id = this.connection.sendQuery(query, address);
                    if (id >= 0L) {
                        CompletableFuture<Result> cf = this.awaitResult(id, this.timeout);
                        return cf;
                    }
                }
                Thread.sleep(wait);
                wait += 1L + wait / 3L;
            }
            catch (InterruptedException e) {
                Result r = Result.fromException((Throwable)e);
                return CompletableFuture.completedFuture(r);
            }
            catch (IOException e) {
                Result r = Result.fromException((Throwable)e).withInfo(Keywords.SOURCE, (ACell)SourceCodes.COMM);
                return CompletableFuture.completedFuture(r);
            }
        }
        return closedResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result> requestStatus() {
        try {
            HashMap hashMap = this.awaiting;
            synchronized (hashMap) {
                long id = this.connection.sendStatusRequest();
                if (id < 0L) {
                    return CompletableFuture.completedFuture(Result.error((Keyword)ErrorCodes.LOAD, (String)"Full buffer, can't send status request").withSource(SourceCodes.COMM));
                }
                CompletableFuture<Result> cf = this.awaitResult(id, this.timeout);
                return cf;
            }
        }
        catch (IOException e) {
            Result r = Result.fromException((Throwable)e).withInfo(Keywords.SOURCE, (ACell)SourceCodes.COMM);
            return CompletableFuture.completedFuture(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result> requestChallenge(SignedData<ACell> data) {
        HashMap hashMap = this.awaiting;
        synchronized (hashMap) {
            long id;
            try {
                id = this.connection.sendChallenge(data);
            }
            catch (IOException e) {
                return CompletableFuture.completedFuture(Result.error((Keyword)ErrorCodes.IO, (String)"Error requesting challenge"));
            }
            if (id < 0L) {
                return CompletableFuture.completedFuture(Result.error((Keyword)ErrorCodes.IO, (String)"Full buffer while requesting challenge"));
            }
            return this.awaitResult(id, this.timeout);
        }
    }

    @Override
    public <T extends ACell> CompletableFuture<T> acquire(Hash hash, AStore store) {
        Acquiror acquiror = Acquiror.create(hash, store, this);
        return acquiror.getFuture();
    }

    @Override
    public synchronized void close() {
        Connection c = this.connection;
        if (c != null) {
            c.close();
        }
        this.connection = null;
        this.awaiting.clear();
    }

    @Override
    public String toString() {
        return "Remote Convex instance at " + String.valueOf(this.getHostAddress());
    }

    @Override
    public Server getLocalServer() {
        return null;
    }
}

