/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Block;
import convex.core.BlockResult;
import convex.core.ErrorCodes;
import convex.core.Peer;
import convex.core.Result;
import convex.core.State;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.PeerStatus;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.util.LoadMonitor;
import convex.core.util.Utils;
import convex.net.Message;
import convex.peer.AThreadedComponent;
import convex.peer.BeliefPropagator;
import convex.peer.Server;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHandler
extends AThreadedComponent {
    static final Logger log = LoggerFactory.getLogger((String)BeliefPropagator.class.getName());
    private static final long OWN_BLOCK_DELAY = 2000L;
    private static final long DEFAULT_MIN_BLOCK_TIME = 10L;
    protected final ArrayBlockingQueue<Message> txMessageQueue;
    ArrayBlockingQueue<SignedData<ATransaction>> transactionQueue;
    private HashMap<Hash, Message> interests = new HashMap();
    public long clientTransactionCount = 0L;
    public long receivedTransactionCount = 0L;
    private Consumer<SignedData<ATransaction>> requestObserver;
    long reportedConsensusPoint;
    private BiConsumer<SignedData<ATransaction>, Result> responseObserver;
    Long minBlockTime = null;
    private ArrayList<SignedData<ATransaction>> newTransactions = new ArrayList();
    private long lastOwnTransactionTimestamp = 0L;
    protected long lastBlockPublishedTime = 0L;
    ArrayList<Message> messages = new ArrayList();

    public TransactionHandler(Server server) {
        super(server);
        this.txMessageQueue = new ArrayBlockingQueue(10000);
        this.transactionQueue = new ArrayBlockingQueue(10000);
    }

    public boolean offerTransaction(Message m) {
        return this.txMessageQueue.offer(m);
    }

    private void registerInterest(Hash signedTransactionHash, Message m) {
        this.interests.put(signedTransactionHash, m);
    }

    protected void processMessage(Message m) {
        try {
            ++this.receivedTransactionCount;
            AVector v = (AVector)m.getPayload();
            SignedData sd = (SignedData)v.get(1);
            Result error = this.checkTransaction((SignedData<ATransaction>)sd);
            if (error != null) {
                m.returnResult(error);
                return;
            }
            sd = (SignedData)Cells.persist((ACell)sd);
            LoadMonitor.down();
            this.transactionQueue.put((SignedData<ATransaction>)sd);
            this.observeTransactionRequest((SignedData<ATransaction>)sd);
            LoadMonitor.up();
            ++this.clientTransactionCount;
            this.registerInterest(sd.getHash(), m);
        }
        catch (Throwable e) {
            log.warn("Unandled exception in transaction handler", e);
        }
    }

    private Result checkTransaction(SignedData<ATransaction> sd) {
        try {
            ATransaction tx = RT.ensureTransaction((ACell)sd.getValue());
            if (tx == null) {
                return Result.error((Keyword)ErrorCodes.FORMAT, (AString)Strings.BAD_FORMAT);
            }
            State s = this.server.getPeer().getConsensusState();
            AccountStatus as = s.getAccount(tx.getOrigin());
            if (as == null) {
                return Result.error((Keyword)ErrorCodes.NOBODY, (AString)Strings.NO_SUCH_ACCOUNT);
            }
            if (tx.getSequence() <= as.getSequence()) {
                return Result.error((Keyword)ErrorCodes.SEQUENCE, (AString)Strings.OLD_SEQUENCE);
            }
            AccountKey expectedKey = as.getAccountKey();
            if (expectedKey == null) {
                return Result.error((Keyword)ErrorCodes.STATE, (AString)Strings.NO_TX_FOR_ACTOR);
            }
            AccountKey pubKey = sd.getAccountKey();
            if (!expectedKey.equals(pubKey)) {
                return Result.error((Keyword)ErrorCodes.SIGNATURE, (AString)Strings.WRONG_KEY);
            }
            if (!sd.checkSignature()) {
                return Result.error((Keyword)ErrorCodes.SIGNATURE, (AString)Strings.BAD_SIGNATURE);
            }
        }
        catch (Exception e) {
            log.warn("Unexpected exception while checking transaction", (Throwable)e);
            return Result.error((Keyword)ErrorCodes.UNEXPECTED, (AString)Strings.BAD_SIGNATURE);
        }
        return null;
    }

    public void setRequestObserver(Consumer<SignedData<ATransaction>> observer) {
        this.requestObserver = observer;
    }

    private void observeTransactionRequest(SignedData<ATransaction> sd) {
        Consumer<SignedData<ATransaction>> observer = this.requestObserver;
        if (observer != null) {
            observer.accept(sd);
        }
    }

    public void maybeReportTransactions(Peer peer) {
        long newConsensusPoint = peer.getFinalityPoint();
        if (newConsensusPoint > this.reportedConsensusPoint) {
            log.debug("Consensus point update from {} to {}", (Object)this.reportedConsensusPoint, (Object)newConsensusPoint);
            for (long i = this.reportedConsensusPoint; i < newConsensusPoint; ++i) {
                SignedData block = peer.getPeerOrder().getBlock(i);
                if (!block.getAccountKey().equals(peer.getPeerKey())) continue;
                BlockResult br = peer.getBlockResult(i);
                this.reportTransactions((Block)block.getValue(), br, i);
            }
            this.reportedConsensusPoint = newConsensusPoint;
        }
    }

    private void reportTransactions(Block block, BlockResult br, long blockNum) {
        int nTrans = block.length();
        HashMap<Keyword, Object> extInfo = new HashMap<Keyword, Object>(5);
        for (long j = 0L; j < (long)nTrans; ++j) {
            try {
                SignedData t = (SignedData)block.getTransactions().get(j);
                Hash h = t.getHash();
                Message m = this.interests.get(h);
                if (m == null) continue;
                CVMLong id = m.getID();
                log.trace("Returning transaction result ID {}", (Object)id);
                Result res = (Result)br.getResults().get(j);
                extInfo.put(Keywords.LOC, Vectors.of((Object[])new Object[]{blockNum, j}));
                extInfo.put(Keywords.TX, t.getHash());
                res = res.withExtraInfo(extInfo);
                boolean reported = m.returnResult(res);
                if (!reported) {
                    // empty if block
                }
                this.observeTransactionResponse((SignedData<ATransaction>)t, res);
                this.interests.remove(h);
                continue;
            }
            catch (Throwable e) {
                log.warn("Exception while reporting transaction Result: ", e);
            }
        }
    }

    public void setResponseObserver(BiConsumer<SignedData<ATransaction>, Result> observer) {
        this.responseObserver = observer;
    }

    private void observeTransactionResponse(SignedData<ATransaction> sd, Result r) {
        BiConsumer<SignedData<ATransaction>, Result> observer = this.responseObserver;
        if (observer != null) {
            observer.accept(sd, r);
        }
    }

    protected SignedData<Block> maybeGenerateBlock(Peer peer) {
        long timestamp = Utils.getCurrentTimestamp();
        if (!this.readyToPublish(peer)) {
            return null;
        }
        long minBlockTime = this.getMinBlockTime();
        if (timestamp < this.lastBlockPublishedTime + minBlockTime) {
            return null;
        }
        this.maybeGetOwnTransactions(peer);
        this.transactionQueue.drainTo(this.newTransactions, 1024);
        int n = this.newTransactions.size();
        if (n == 0) {
            return null;
        }
        Block block = Block.create((long)timestamp, this.newTransactions);
        this.newTransactions.clear();
        this.lastBlockPublishedTime = Utils.getCurrentTimestamp();
        SignedData signedBlock = peer.getKeyPair().signData((ACell)block);
        return signedBlock;
    }

    public SignedData<Block> maybeGetBlock() {
        return this.maybeGenerateBlock(this.server.getPeer());
    }

    private boolean readyToPublish(Peer peer) {
        return true;
    }

    private long getMinBlockTime() {
        if (this.minBlockTime == null) {
            HashMap<Keyword, Object> config = this.server.getConfig();
            CVMLong mbt = CVMLong.parse((Object)config.get(Keywords.MIN_BLOCK_TIME));
            this.minBlockTime = mbt == null ? 10L : mbt.longValue();
        }
        return this.minBlockTime;
    }

    void maybeGetOwnTransactions(Peer p) {
        String currentHostname;
        long ts = Utils.getCurrentTimestamp();
        if (ts < this.lastOwnTransactionTimestamp + 2000L) {
            return;
        }
        if (!Utils.bool((Object)this.server.getConfig().get(Keywords.AUTO_MANAGE))) {
            return;
        }
        State s = p.getConsensusState();
        String desiredHostname = this.server.getHostname();
        AccountKey peerKey = p.getPeerKey();
        PeerStatus ps = s.getPeer(peerKey);
        if (ps == null) {
            return;
        }
        AString chn = ps.getHostname();
        String string = currentHostname = chn == null ? null : chn.toString();
        if (!Utils.equals((Object)desiredHostname, (Object)currentHostname)) {
            AccountStatus as;
            log.debug("Trying to update own hostname from: {} to {}", (Object)currentHostname, (Object)desiredHostname);
            Address address = ps.getController();
            if (address != null && (as = s.getAccount(address)) != null && Cells.equals((ACell)peerKey, (ACell)as.getAccountKey())) {
                String code = desiredHostname == null ? String.format("(set-peer-data %s {:url nil})", peerKey) : String.format("(set-peer-data %s {:url \"%s\"})", peerKey, desiredHostname);
                ACell message = Reader.read((String)code);
                Invoke transaction = Invoke.create((Address)address, (long)(as.getSequence() + 1L), (ACell)message);
                this.newTransactions.add((SignedData<ATransaction>)p.getKeyPair().signData((ACell)transaction));
                this.lastOwnTransactionTimestamp = ts;
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void start() {
        this.reportedConsensusPoint = this.server.getPeer().getFinalityPoint();
        super.start();
    }

    public boolean isAwaitingResults() {
        return this.interests.size() > 0;
    }

    public int countInterests() {
        return this.interests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loop() throws InterruptedException {
        long BLOCKTIME = this.getMinBlockTime();
        try {
            LoadMonitor.down();
            Message m = this.txMessageQueue.poll(BLOCKTIME, TimeUnit.MILLISECONDS);
            LoadMonitor.up();
            if (m == null) {
                return;
            }
            this.messages.add(m);
            this.txMessageQueue.drainTo(this.messages);
            for (Message msg : this.messages) {
                this.processMessage(msg);
            }
        }
        finally {
            this.messages.clear();
        }
    }

    @Override
    protected String getThreadName() {
        return "Transaction handler on port: " + this.server.getPort();
    }
}

