/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.api.ConvexRemote;
import convex.core.Belief;
import convex.core.ErrorCodes;
import convex.core.Order;
import convex.core.Peer;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.init.Init;
import convex.core.lang.RT;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Counters;
import convex.core.util.Shutdown;
import convex.core.util.Utils;
import convex.net.Message;
import convex.net.MessageType;
import convex.net.NIOServer;
import convex.peer.BeliefPropagator;
import convex.peer.CVMExecutor;
import convex.peer.ConnectionManager;
import convex.peer.QueryHandler;
import convex.peer.TransactionHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements Closeable {
    public static final int DEFAULT_PORT = 18888;
    static final Logger log = LoggerFactory.getLogger((String)Server.class.getName());
    private Consumer<Message> messageReceiveObserver = null;
    Consumer<Message> receiveAction = m -> {
        this.observeMessageReceived((Message)m);
        this.processMessage((Message)m);
    };
    protected final ConnectionManager manager = new ConnectionManager(this);
    protected final BeliefPropagator propagator = new BeliefPropagator(this);
    protected final TransactionHandler transactionHandler = new TransactionHandler(this);
    protected final CVMExecutor executor = new CVMExecutor(this);
    protected final QueryHandler queryHandler = new QueryHandler(this);
    private final AStore store;
    private final HashMap<Keyword, Object> config;
    private final ACell rootKey;
    private NIOServer nio = NIOServer.create(this);
    private volatile boolean isRunning = true;
    private volatile boolean isLive = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Server(HashMap<Keyword, Object> config) throws TimeoutException, IOException {
        this.config = config;
        AStore savedStore = Stores.current();
        AStore configStore = (AStore)config.get(Keywords.STORE);
        this.store = configStore == null ? savedStore : configStore;
        try {
            Stores.setCurrent((AStore)this.store);
            Peer peer = this.establishPeer();
            ACell rk = RT.cvm((Object)config.get(Keywords.ROOT_KEY));
            if (rk == null) {
                rk = peer.getPeerKey();
            }
            this.rootKey = rk;
            this.executor.setPeer(peer);
            this.executor.persistPeerData();
            this.establishController();
        }
        finally {
            Stores.setCurrent((AStore)savedStore);
        }
    }

    private void establishController() {
        Peer peer = this.getPeer();
        Address controlAddress = RT.toAddress((Object)this.getConfig().get(Keywords.CONTROLLER));
        if (controlAddress == null && (controlAddress = peer.getController()) == null) {
            throw new IllegalStateException("Peer Controller account does not exist for Peer Key: " + String.valueOf(peer.getPeerKey()));
        }
        AccountStatus as = peer.getConsensusState().getAccount(controlAddress);
        if (as == null) {
            log.warn("Peer Controller Account does not currently exist (perhaps pending sync?): " + String.valueOf(controlAddress));
        } else if (!Utils.equals((ACell)as.getAccountKey(), (ACell)this.getKeyPair().getAccountKey())) {
            log.warn("Server keypair does not match keypair for control account: " + String.valueOf(controlAddress));
        }
    }

    private Peer establishPeer() throws TimeoutException, IOException {
        State genesisState;
        Object source;
        log.debug("Establishing Peer with store: {}", (Object)Stores.current());
        AKeyPair keyPair = (AKeyPair)this.getConfig().get(Keywords.KEYPAIR);
        if (keyPair == null) {
            log.warn("No keypair provided for Server, deafulting to generated keypair for testing purposes");
            keyPair = AKeyPair.generate();
            log.warn("Generated keypair with public key: " + String.valueOf(keyPair.getAccountKey()));
        }
        if (Utils.bool((Object)(source = this.getConfig().get(Keywords.SOURCE)))) {
            InetSocketAddress sourceAddr = Utils.toInetSocketAddress((Object)source);
            if (sourceAddr == null) {
                throw new IllegalStateException("Bad SOURCE for peer sync, should be an internet socket address: " + String.valueOf(source));
            }
            return this.syncPeer(keyPair, sourceAddr);
        }
        if (Utils.bool((Object)this.getConfig().get(Keywords.RESTORE))) {
            try {
                Peer peer;
                ACell rk = RT.cvm((Object)this.config.get(Keywords.ROOT_KEY));
                if (rk == null) {
                    rk = keyPair.getAccountKey();
                }
                if ((peer = Peer.restorePeer((AStore)this.store, (AKeyPair)keyPair, (ACell)rk)) != null) {
                    log.info("Restored Peer with root data hash: {}", (Object)this.store.getRootHash());
                    return peer;
                }
            }
            catch (Throwable e) {
                log.error("Can't restore Peer from store: {}", e);
            }
        }
        if ((genesisState = (State)this.config.get(Keywords.STATE)) != null) {
            log.debug("Defaulting to standard Peer startup with genesis state: " + String.valueOf(genesisState.getHash()));
        } else {
            AccountKey peerKey = keyPair.getAccountKey();
            genesisState = Init.createState(List.of(peerKey));
            log.debug("Created new genesis state: " + String.valueOf(genesisState.getHash()) + " with initial peer: " + String.valueOf(peerKey));
        }
        return Peer.createGenesisPeer((AKeyPair)keyPair, (State)genesisState);
    }

    private Peer syncPeer(AKeyPair keyPair, InetSocketAddress sourceAddr) throws IOException, TimeoutException {
        try {
            ConvexRemote convex = Convex.connect(sourceAddr);
            log.info("Attempting Peer Sync with: " + String.valueOf(sourceAddr));
            long timeout = this.establishTimeout();
            Result result = convex.requestStatusSync(timeout);
            AVector status = (AVector)result.getValue();
            if (status == null || status.count() != 9L) {
                throw new Error("Bad status message from remote Peer");
            }
            Hash beliefHash = RT.ensureHash((ACell)status.get(0));
            AccountKey remoteKey = RT.ensureAccountKey((ACell)status.get(3));
            Hash genesisHash = RT.ensureHash((ACell)status.get(2));
            Hash stateHash = RT.ensureHash((ACell)status.get(4));
            log.info("Attempting to sync remote state: " + String.valueOf(stateHash) + " on network: " + String.valueOf(genesisHash));
            State genF = (State)convex.acquire(genesisHash).get(timeout, TimeUnit.MILLISECONDS);
            log.info("Retrieved Consensus State: " + String.valueOf(genesisHash));
            log.info("Attempting to obtain peer Belief: " + String.valueOf(beliefHash));
            Belief belF = null;
            long timeElapsed = 0L;
            while (belF == null) {
                try {
                    belF = (Belief)convex.acquire(beliefHash).get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    log.info("Still waiting for Belief sync after " + (timeElapsed += timeout) / 1000L + "s");
                }
            }
            log.info("Retrieved Peer Belief: " + String.valueOf(beliefHash) + " with memory size: " + belF.getMemorySize());
            ((Convex)convex).close();
            SignedData peerOrder = (SignedData)belF.getOrders().get((ABlobLike)remoteKey);
            if (peerOrder != null) {
                SignedData newOrder = keyPair.signData((ACell)((Order)peerOrder.getValue()));
                belF = belF.withOrders(belF.getOrders().assoc((ACell)keyPair.getAccountKey(), (ACell)newOrder));
            } else {
                log.warn("Remote peer Belief missing it's own Order?");
            }
            Peer peer = Peer.create((AKeyPair)keyPair, (State)genF, (Belief)belF);
            return peer;
        }
        catch (InterruptedException | ExecutionException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    private long establishTimeout() {
        Object maybeTimeout = this.getConfig().get(Keywords.TIMEOUT);
        if (maybeTimeout == null) {
            return 60000L;
        }
        Utils.toInt((Object)maybeTimeout);
        return 0L;
    }

    public static Server create(HashMap<Keyword, Object> config) throws TimeoutException, IOException {
        return new Server(new HashMap<Keyword, Object>(config));
    }

    private void observeMessageReceived(Message m) {
        Consumer<Message> obs = this.messageReceiveObserver;
        if (obs != null) {
            obs.accept(m);
        }
    }

    public void setMessageReceiveObserver(Consumer<Message> observer) {
        this.messageReceiveObserver = observer;
    }

    public Belief getBelief() {
        return this.getPeer().getBelief();
    }

    public Peer getPeer() {
        return this.executor.getPeer();
    }

    public String getHostname() {
        return (String)this.config.get(Keywords.URL);
    }

    public void launch() {
        AStore savedStore = Stores.current();
        try {
            Stores.setCurrent((AStore)this.store);
            HashMap<Keyword, Object> config = this.getConfig();
            Object p = config.get(Keywords.PORT);
            Integer port = p == null ? null : Integer.valueOf(Utils.toInt((Object)p));
            this.nio.launch((String)config.get(Keywords.BIND_ADDRESS), port);
            port = this.nio.getPort();
            this.isRunning = true;
            Shutdown.addHook((int)80, () -> this.close());
            this.manager.start();
            this.queryHandler.start();
            this.propagator.start();
            this.transactionHandler.start();
            this.executor.start();
            if (this.getConfig().containsKey(Keywords.SOURCE)) {
                Object s = this.getConfig().get(Keywords.SOURCE);
                InetSocketAddress sa = Utils.toInetSocketAddress((Object)s);
                if (sa != null) {
                    if (this.manager.connectToPeer(sa) != null) {
                        log.debug("Automatically connected to :source peer at: {}", (Object)sa);
                    } else {
                        log.warn("Failed to connect to :source peer at: {}", (Object)sa);
                    }
                } else {
                    log.warn("Failed to parse :source peer address {}", s);
                }
            }
            this.goLive();
            log.info("Peer Server started at " + String.valueOf(this.nio.getHostAddress()) + " with Peer Address: {}", (Object)this.getPeerKey());
        }
        catch (Exception e) {
            this.close();
            throw new Error("Failed to launch Server", e);
        }
        finally {
            Stores.setCurrent((AStore)savedStore);
        }
    }

    private void goLive() {
        this.isLive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processMessage(Message m) {
        MessageType type = m.getType();
        AStore tempStore = Stores.current();
        try {
            Stores.setCurrent((AStore)this.store);
            switch (type) {
                case BELIEF: {
                    this.processBelief(m);
                    return;
                }
                case CHALLENGE: {
                    this.processChallenge(m);
                    return;
                }
                case RESPONSE: {
                    this.processResponse(m);
                    return;
                }
                case COMMAND: {
                    return;
                }
                case DATA: {
                    this.processData(m);
                    return;
                }
                case REQUEST_DATA: {
                    this.processQuery(m);
                    return;
                }
                case QUERY: {
                    this.processQuery(m);
                    return;
                }
                case RESULT: {
                    return;
                }
                case TRANSACT: {
                    this.processTransact(m);
                    return;
                }
                case GOODBYE: {
                    this.processClose(m);
                    return;
                }
                case STATUS: {
                    this.processStatus(m);
                    return;
                }
                default: {
                    Result r = Result.create((CVMLong)m.getID(), (ACell)Strings.create((String)("Bad Message Type: " + String.valueOf((Object)type))), (ACell)ErrorCodes.ARGUMENT);
                    m.returnResult(r);
                    return;
                }
            }
        }
        catch (MissingDataException e) {
            Hash missingHash = e.getMissingHash();
            log.trace("Missing data: {} in message of type {}", (Object)missingHash, (Object)type);
            return;
        }
        catch (Throwable e) {
            log.warn("Error processing client message: {}", e);
            return;
        }
        finally {
            Stores.setCurrent((AStore)tempStore);
        }
    }

    protected void handleDataRequest(Message m) {
        try {
            Message response = m.makeDataResponse(this.store);
            boolean sent = m.returnMessage(response);
            if (!sent) {
                log.trace("Can't send data request response due to full buffer");
            }
        }
        catch (BadFormatException e) {
            log.warn("Unable to deliver missing data due badly formatted DATA_REQUEST: {}", (Object)m);
        }
        catch (Exception e) {
            log.warn("Unable to deliver missing data due to exception:", (Throwable)e);
        }
    }

    protected void processTransact(Message m) {
        boolean queued = this.transactionHandler.offerTransaction(m);
        if (!queued) {
            Result r = Result.create((CVMLong)m.getID(), (ACell)Strings.SERVER_LOADED, (ACell)ErrorCodes.LOAD);
            m.returnResult(r);
        }
    }

    protected void processClose(Message m) {
        m.closeConnection();
    }

    public long getBroadcastCount() {
        return this.propagator.getBeliefBroadcastCount();
    }

    public long getBeliefReceivedCount() {
        return this.propagator.beliefReceivedCount;
    }

    public Address getPeerController() {
        return this.getPeer().getController();
    }

    public boolean queueBelief(Message event) {
        boolean offered = this.propagator.queueBelief(event);
        return offered;
    }

    protected void processStatus(Message m) {
        try {
            AVector<ACell> reply = this.getStatusVector();
            Result r = Result.create((CVMLong)m.getID(), reply);
            m.returnResult(r);
        }
        catch (Throwable t) {
            log.warn("Status Request Error:", t);
        }
    }

    public AVector<ACell> getStatusVector() {
        Peer peer = this.getPeer();
        Belief belief = peer.getBelief();
        State state = peer.getConsensusState();
        Hash beliefHash = belief.getHash();
        Hash stateHash = state.getHash();
        Hash genesisHash = peer.getNetworkID();
        AccountKey peerKey = peer.getPeerKey();
        Hash consensusHash = state.getHash();
        Order order = belief.getOrder(peerKey);
        CVMLong cp = CVMLong.create((long)order.getConsensusPoint());
        CVMLong pp = CVMLong.create((long)order.getProposalPoint());
        CVMLong op = CVMLong.create((long)order.getBlockCount());
        AVector cps = Vectors.of((Object[])Utils.toObjectArray((Object)order.getConsensusPoints()));
        AVector reply = Vectors.of((Object[])new Object[]{beliefHash, stateHash, genesisHash, peerKey, consensusHash, cp, pp, op, cps});
        assert (reply.count() == 9L);
        return reply;
    }

    private void processChallenge(Message m) {
        this.manager.processChallenge(m, this.getPeer());
    }

    protected void processResponse(Message m) {
        this.manager.processResponse(m, this.getPeer());
    }

    protected void processQuery(Message m) {
        boolean queued = this.queryHandler.offerQuery(m);
        if (!queued) {
            Result r = Result.create((CVMLong)m.getID(), (ACell)Strings.SERVER_LOADED, (ACell)ErrorCodes.LOAD);
            m.returnResult(r);
        }
    }

    private void processData(Message m) {
        Object payload;
        try {
            payload = m.getPayload();
        }
        catch (BadFormatException e) {
            m.closeConnection();
            return;
        }
        ++Counters.peerDataReceived;
        Ref r = Ref.get(payload);
        if (r.isEmbedded()) {
            log.warn("DATA with embedded value: " + String.valueOf(payload));
            return;
        }
        r = r.persistShallow();
    }

    protected void processBelief(Message m) {
        if (!this.propagator.queueBelief(m)) {
            log.warn("Incoming belief queue full");
        }
    }

    public int getPort() {
        return this.nio.getPort();
    }

    public void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Peer persistPeerData() throws IOException {
        AStore tempStore = Stores.current();
        try {
            Stores.setCurrent((AStore)this.store);
            AMap peerData = this.getPeer().toData();
            Ref rootRef = this.store.refForHash(this.store.getRootHash());
            AHashMap currentRootData = rootRef == null ? Maps.empty() : (AMap)rootRef.getValue();
            AMap newRootData = currentRootData.assoc(this.rootKey, (ACell)peerData);
            newRootData = (AMap)this.store.setRootData((ACell)newRootData).getValue();
            peerData = (AMap)newRootData.get(this.rootKey);
            log.debug("Stored peer data for Server with hash: {}", (Object)peerData.getHash().toHexString());
            Peer peer = Peer.fromData((AKeyPair)this.getKeyPair(), (AMap)peerData);
            return peer;
        }
        finally {
            Stores.setCurrent((AStore)tempStore);
        }
    }

    @Override
    public void close() {
        if (!this.isRunning) {
            return;
        }
        this.isLive = false;
        this.isRunning = false;
        this.propagator.close();
        this.queryHandler.close();
        this.transactionHandler.close();
        this.executor.close();
        Peer peer = this.getPeer();
        if (peer != null && !Boolean.FALSE.equals(this.getConfig().get(Keywords.PERSIST))) {
            try {
                this.persistPeerData();
            }
            catch (IOException e) {
                log.warn("Unable to persist Peer data: ", (Throwable)e);
            }
        }
        this.manager.close();
        this.nio.close();
        log.info("Peer shutdown complete for " + String.valueOf(this.getPeerKey()));
    }

    public InetSocketAddress getHostAddress() {
        return this.nio.getHostAddress();
    }

    public AKeyPair getKeyPair() {
        return this.getPeer().getKeyPair();
    }

    public AccountKey getPeerKey() {
        AKeyPair kp = this.getKeyPair();
        if (kp == null) {
            return null;
        }
        return kp.getAccountKey();
    }

    public AStore getStore() {
        return this.store;
    }

    public ConnectionManager getConnectionManager() {
        return this.manager;
    }

    public HashMap<Keyword, Object> getConfig() {
        return this.config;
    }

    public Consumer<Message> getReceiveAction() {
        return this.receiveAction;
    }

    public void setHostname(String string) {
        this.config.put(Keywords.URL, string);
    }

    public boolean isLive() {
        return this.isLive;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    public BeliefPropagator getBeliefPropagator() {
        return this.propagator;
    }

    public void updateBelief(Belief belief) {
        this.executor.queueUpdate(belief);
    }

    public CVMExecutor getCVMExecutor() {
        return this.executor;
    }

    public QueryHandler getQueryProcessor() {
        return this.queryHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException, TimeoutException {
        try {
            AKeyPair kp = this.getKeyPair();
            AccountKey key = kp.getAccountKey();
            ConvexLocal convex = Convex.connect(this, this.getPeerController(), kp);
            Result r = convex.transactSync("(set-peer-stake " + String.valueOf(key) + " 0)");
            if (r.isError()) {
                log.warn("Unable to remove Peer stake: " + String.valueOf(r));
            }
        }
        finally {
            this.isLive = false;
            this.close();
        }
    }
}

