/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.exceptions.BadFormatException;

public enum MessageType {
    CHALLENGE(1),
    RESPONSE(2),
    DATA(3),
    COMMAND(4),
    REQUEST_DATA(5),
    QUERY(6),
    TRANSACT(7),
    RESULT(8),
    BELIEF(9),
    REQUEST_BELIEF(10),
    GOODBYE(11),
    STATUS(12);

    private final byte messageCode;

    public byte getMessageCode() {
        return this.messageCode;
    }

    public static MessageType decode(int i) throws BadFormatException {
        switch (i) {
            case 1: {
                return CHALLENGE;
            }
            case 2: {
                return RESPONSE;
            }
            case 3: {
                return DATA;
            }
            case 4: {
                return COMMAND;
            }
            case 5: {
                return REQUEST_DATA;
            }
            case 6: {
                return QUERY;
            }
            case 7: {
                return TRANSACT;
            }
            case 8: {
                return RESULT;
            }
            case 9: {
                return BELIEF;
            }
            case 10: {
                return REQUEST_BELIEF;
            }
            case 11: {
                return GOODBYE;
            }
            case 12: {
                return STATUS;
            }
        }
        throw new BadFormatException("Invalid message code: " + i);
    }

    private MessageType(int i) {
        this.messageCode = (byte)i;
        if (i != this.messageCode) {
            throw new Error("Message format byte out of range: " + i);
        }
    }
}

