/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.exceptions.BadFormatException;
import convex.net.Connection;
import convex.net.Message;
import convex.net.MessageType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReceiver {
    public static final int RECEIVE_BUFFER_SIZE = 81930;
    private ByteBuffer buffer = ByteBuffer.allocate(81930);
    private final Consumer<Message> action;
    private Consumer<Message> hook = null;
    private final Connection connection;
    private long receivedMessageCount = 0L;
    private static final Logger log = LoggerFactory.getLogger((String)MessageReceiver.class.getName());

    public MessageReceiver(Consumer<Message> receiveAction, Connection pc) {
        this.action = receiveAction;
        this.connection = pc;
    }

    public long getReceivedCount() {
        return this.receivedMessageCount;
    }

    public synchronized int receiveFromChannel(ReadableByteChannel chan) throws IOException, BadFormatException {
        int numRead = 0;
        numRead = chan.read(this.buffer);
        if (numRead <= 0) {
            return numRead;
        }
        while (this.buffer.position() > 0) {
            int len = Format.peekMessageLength((ByteBuffer)this.buffer);
            if (len < 0) {
                return numRead;
            }
            int lengthLength = Format.getVLCLength((long)len);
            int totalFrameSize = lengthLength + len;
            if (totalFrameSize > this.buffer.capacity()) {
                int newSize = Math.max(totalFrameSize, this.buffer.position());
                ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
                this.buffer.flip();
                newBuffer.put(this.buffer);
                this.buffer = newBuffer;
            }
            if (this.buffer.position() < totalFrameSize) {
                return numRead;
            }
            byte mType = this.buffer.get(lengthLength);
            MessageType type = MessageType.decode(mType);
            byte[] bs = new byte[len - 1];
            this.buffer.get(lengthLength + 1, bs, 0, len - 1);
            Blob messageData = Blob.wrap((byte[])bs);
            this.receiveMessage(type, messageData);
            int receivedLimit = this.buffer.position();
            this.buffer.position(totalFrameSize);
            this.buffer.limit(receivedLimit);
            this.buffer.compact();
        }
        return numRead;
    }

    private void receiveMessage(MessageType type, Blob encoding) throws BadFormatException {
        try {
            Message message = Message.create(this.connection, type, encoding);
            this.maybeCallHook(message);
            ++this.receivedMessageCount;
            if (this.action != null) {
                log.trace("Message received: {}", (Object)message.getType());
                this.action.accept(message);
            } else {
                log.warn("Ignored message because no receive action set: " + String.valueOf(message));
            }
        }
        catch (Exception e) {
            log.warn("Exception in receive action from: " + String.valueOf(this.connection.getRemoteAddress()), (Throwable)e);
        }
    }

    private void maybeCallHook(Message message) {
        Consumer<Message> hook = this.hook;
        if (hook != null) {
            hook.accept(message);
        }
    }

    public void setHook(Consumer<Message> hook) {
        this.hook = hook;
    }
}

