/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.Acquiror;
import convex.api.Convex;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.data.SignedData;
import convex.core.lang.RT;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.core.util.Utils;
import convex.net.Connection;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvexRemote
extends Convex {
    protected Connection connection;
    private static final Logger log = LoggerFactory.getLogger((String)ConvexRemote.class.getName());
    protected InetSocketAddress remoteAddress;

    @Override
    public InetSocketAddress getHostAddress() {
        return this.remoteAddress;
    }

    protected ConvexRemote(Address address, AKeyPair keyPair) {
        super(address, keyPair);
    }

    protected void connectToPeer(InetSocketAddress peerAddress, AStore store) throws IOException, TimeoutException {
        this.remoteAddress = peerAddress;
        this.setConnection(Connection.connect(peerAddress, this.messageHandler, store));
    }

    public void reconnect() throws IOException, TimeoutException {
        Connection curr = this.connection;
        AStore store = curr == null ? Stores.current() : curr.getStore();
        this.close();
        this.setConnection(Connection.connect(this.remoteAddress, this.messageHandler, store));
    }

    protected void setConnection(Connection conn) {
        Connection curr = this.connection;
        if (curr == conn) {
            return;
        }
        if (curr != null) {
            this.close();
        }
        this.connection = conn;
    }

    @Override
    public boolean isConnected() {
        Connection c = this.connection;
        return c != null && !c.isClosed();
    }

    public void closeButMaintainConnection() {
        this.connection = null;
        this.close();
    }

    @Override
    public CompletableFuture<State> acquireState() throws TimeoutException {
        try {
            CompletableFuture<Result> sF = this.requestStatus();
            AVector status = (AVector)((Result)sF.get(this.timeout, TimeUnit.MILLISECONDS)).getValue();
            Hash stateHash = RT.ensureHash((ACell)status.get(4));
            if (stateHash == null) {
                throw new Error("Bad status response from Peer");
            }
            return this.acquire(stateHash, Stores.current());
        }
        catch (InterruptedException | ExecutionException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CompletableFuture<Result> transact(SignedData<ATransaction> signed) throws IOException {
        CompletableFuture<Result> cf;
        long id = -1L;
        long wait = 1L;
        while (true) {
            HashMap hashMap = this.awaiting;
            synchronized (hashMap) {
                id = this.connection.sendTransaction(signed);
                if (id >= 0L) {
                    this.maybeUpdateSequence(signed);
                    cf = this.awaitResult(id, this.timeout);
                    break;
                }
            }
            try {
                Thread.sleep(wait);
                ++wait;
            }
            catch (InterruptedException e) {
                throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
            }
        }
        log.trace("Sent transaction with message ID: {} awaiting count = {}", (Object)id, (Object)this.awaiting.size());
        return cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result> query(ACell query, Address address) throws IOException {
        long wait = 1L;
        while (true) {
            HashMap hashMap = this.awaiting;
            synchronized (hashMap) {
                long id = this.connection.sendQuery(query, address);
                if (id >= 0L) {
                    CompletableFuture<Result> cf = this.awaitResult(id, this.timeout);
                    return cf;
                }
            }
            try {
                Thread.sleep(wait);
                wait += wait;
            }
            catch (InterruptedException e) {
                throw new IOException("Transaction sending interrupted", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result> requestStatus() {
        try {
            HashMap hashMap = this.awaiting;
            synchronized (hashMap) {
                long id = this.connection.sendStatusRequest();
                if (id < 0L) {
                    return CompletableFuture.failedFuture(new IOException("Failed to send status request due to full buffer"));
                }
                CompletableFuture<Result> cf = this.awaitResult(id, this.timeout);
                return cf;
            }
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result> requestChallenge(SignedData<ACell> data) throws IOException {
        HashMap hashMap = this.awaiting;
        synchronized (hashMap) {
            long id = this.connection.sendChallenge(data);
            if (id < 0L) {
                throw new IOException("Failed to send challenge due to full buffer");
            }
            return this.awaitResult(id, this.timeout);
        }
    }

    @Override
    public <T extends ACell> CompletableFuture<T> acquire(Hash hash, AStore store) {
        Acquiror acquiror = Acquiror.create(hash, store, this);
        return acquiror.getFuture();
    }

    @Override
    public synchronized void close() {
        Connection c = this.connection;
        if (c != null) {
            c.close();
        }
        this.connection = null;
        this.awaiting.clear();
    }

    @Override
    public String toString() {
        return "Remote Convex instance at " + String.valueOf(this.getHostAddress());
    }

    @Override
    public Server getLocalServer() {
        return null;
    }
}

