/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.ConvexRemote;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.MissingDataException;
import convex.core.lang.RT;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.ThreadUtils;
import convex.core.util.Utils;
import convex.net.Message;
import convex.net.MessageType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Acquiror {
    private static final Logger log = LoggerFactory.getLogger((String)Acquiror.class.getName());
    private static final int ACQUIRE_LOOP_TIMEOUT = 2000;
    private Hash hash;
    private AStore store;
    private ConvexRemote source;

    public Acquiror(Hash hash, AStore store, ConvexRemote source) {
        this.hash = hash;
        this.store = store;
        this.source = source;
    }

    public static Acquiror create(Hash hash, AStore store, ConvexRemote source) {
        return new Acquiror(hash, store, source);
    }

    public <T extends ACell> CompletableFuture<T> getFuture() {
        CompletableFuture<ACell> f = new CompletableFuture<ACell>();
        Ref checkRef = this.store.refForHash(this.hash);
        if (checkRef != null && checkRef.getStatus() >= 2) {
            f.complete(checkRef.getValue());
            return f;
        }
        log.trace("Trying to acquire remotely: {}", (Object)this.hash);
        ThreadUtils.runVirtual(() -> {
            Stores.setCurrent((AStore)this.store);
            try {
                HashSet<Hash> missingSet = new HashSet<Hash>();
                long LIMIT = 100L;
                while (!f.isDone()) {
                    Ref ref = this.store.refForHash(this.hash);
                    missingSet.clear();
                    if (ref == null) {
                        missingSet.add(this.hash);
                    } else {
                        if (ref.getStatus() >= 2) {
                            f.complete(ref.getValue());
                            log.trace("Successfully acquired {}", (Object)this.hash);
                            return;
                        }
                        ref.findMissing(missingSet, LIMIT);
                    }
                    long id = this.source.connection.getNextID();
                    Message dataRequest = Message.createDataRequest(CVMLong.create((long)id), missingSet.toArray(Utils.EMPTY_HASHES));
                    CompletableFuture cf = new CompletableFuture();
                    HashMap hashMap = this.source.awaiting;
                    synchronized (hashMap) {
                        boolean sent = this.source.connection.sendMessage(dataRequest);
                        if (!sent) {
                            continue;
                        }
                        cf = cf.orTimeout(2000L, TimeUnit.MILLISECONDS);
                        this.source.awaiting.put(id, cf);
                    }
                    try {
                        Message resp = (Message)cf.get();
                        if (resp.getType() == MessageType.DATA) {
                            log.trace("Got acquire response: {} ", (Object)resp);
                            AVector v = (AVector)resp.getPayload();
                            int i = 1;
                            while ((long)i < v.count()) {
                                ACell val = v.get(i);
                                if (val == null) {
                                    AVector reqv = (AVector)dataRequest.getPayload();
                                    f.completeExceptionally(new MissingDataException(this.store, RT.ensureHash((ACell)reqv.get(i))));
                                } else {
                                    Cells.store((ACell)v.get(i), (AStore)this.store);
                                }
                                ++i;
                            }
                        } else {
                            log.warn("Unexpected data response type: " + String.valueOf((Object)resp.getType()));
                        }
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof TimeoutException) {
                            log.info("Acquire polling: Long delay requesting {}", missingSet);
                            continue;
                        }
                        f.completeExceptionally(e);
                        continue;
                    }
                    if ((ref = this.store.refForHash(this.hash)) == null) continue;
                    try {
                        ACell a = ref.getValue();
                        a = Cells.persist((ACell)a);
                    }
                    catch (MissingDataException missingDataException) {}
                }
            }
            catch (InterruptedException e) {
                f.completeExceptionally(e);
            }
            catch (Throwable t) {
                log.warn("UNEXPECTED acquire fail: ", t);
                f.completeExceptionally(t);
            }
        });
        return f;
    }
}

