/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Block;
import convex.core.BlockResult;
import convex.core.ErrorCodes;
import convex.core.Peer;
import convex.core.Result;
import convex.core.State;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.PeerStatus;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.prim.CVMLong;
import convex.core.lang.Reader;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.util.LoadMonitor;
import convex.core.util.Utils;
import convex.net.message.Message;
import convex.peer.AThreadedComponent;
import convex.peer.BeliefPropagator;
import convex.peer.Server;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHandler
extends AThreadedComponent {
    static final Logger log = LoggerFactory.getLogger((String)BeliefPropagator.class.getName());
    private static final long OWN_BLOCK_DELAY = 2000L;
    private static final long MIN_BLOCK_TIME = 50L;
    protected final ArrayBlockingQueue<Message> txMessageQueue;
    ArrayBlockingQueue<SignedData<ATransaction>> transactionQueue;
    private HashMap<Hash, Message> interests = new HashMap();
    long reportedConsensusPoint;
    private ArrayList<SignedData<ATransaction>> newTransactions = new ArrayList();
    private long lastOwnTransactionTimestamp = 0L;
    protected long lastBlockPublishedTime = 0L;
    ArrayList<Message> messages = new ArrayList();

    public TransactionHandler(Server server) {
        super(server);
        this.txMessageQueue = new ArrayBlockingQueue(1000);
        this.transactionQueue = new ArrayBlockingQueue(1000);
    }

    public boolean offerTransaction(Message m) {
        return this.txMessageQueue.offer(m);
    }

    private void registerInterest(Hash signedTransactionHash, Message m) {
        this.interests.put(signedTransactionHash, m);
    }

    protected void processMessage(Message m) {
        try {
            AVector v = (AVector)m.getPayload();
            SignedData sd = (SignedData)v.get(1);
            if (!(sd.getValue() instanceof ATransaction)) {
                Result r = Result.create((CVMLong)m.getID(), (ACell)Strings.BAD_FORMAT, (ACell)ErrorCodes.FORMAT);
                m.reportResult(r);
                return;
            }
            if (!sd.checkSignature()) {
                try {
                    Result r = Result.create((CVMLong)m.getID(), (ACell)Strings.BAD_SIGNATURE, (ACell)ErrorCodes.SIGNATURE);
                    m.reportResult(r);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.debug("Bad signature from Client! {}", (Object)sd);
                return;
            }
            sd = (SignedData)ACell.createPersisted((ACell)sd).getValue();
            this.transactionQueue.put((SignedData<ATransaction>)sd);
            this.registerInterest(sd.getHash(), m);
        }
        catch (Throwable e) {
            log.warn("Unandled exception in transaction handler", e);
        }
    }

    public void maybeReportTransactions(Peer peer) {
        long newConsensusPoint = peer.getConsensusPoint();
        if (newConsensusPoint > this.reportedConsensusPoint) {
            log.debug("Consensus point update from {} to {}", (Object)this.reportedConsensusPoint, (Object)newConsensusPoint);
            for (long i = this.reportedConsensusPoint; i < newConsensusPoint; ++i) {
                SignedData block = peer.getPeerOrder().getBlock(i);
                if (!block.getAccountKey().equals(peer.getPeerKey())) continue;
                BlockResult br = peer.getBlockResult(i);
                this.reportTransactions((Block)block.getValue(), br);
            }
            this.reportedConsensusPoint = newConsensusPoint;
        }
    }

    private void reportTransactions(Block block, BlockResult br) {
        int nTrans = block.length();
        for (long j = 0L; j < (long)nTrans; ++j) {
            try {
                SignedData t = (SignedData)block.getTransactions().get(j);
                Hash h = t.getHash();
                Message m = this.interests.get(h);
                if (m == null) continue;
                CVMLong id = m.getID();
                log.trace("Returning tranaction result ID {} to {}", (Object)id, (Object)m.getOriginString());
                Result res = (Result)br.getResults().get(j);
                boolean reported = m.reportResult(res);
                if (!reported) {
                    // empty if block
                }
                this.interests.remove(h);
                continue;
            }
            catch (Throwable e) {
                log.warn("Exception while reporting transaction Result: ", e);
            }
        }
    }

    protected SignedData<Block> maybeGenerateBlock(Peer peer) {
        Long minBlockTime;
        long timestamp = Utils.getCurrentTimestamp();
        if (timestamp >= this.lastBlockPublishedTime + (minBlockTime = Long.valueOf(this.getMinBlockTime()))) {
            this.transactionQueue.drainTo(this.newTransactions);
        }
        this.maybeGetOwnTransactions(peer);
        int n = this.newTransactions.size();
        if (n == 0) {
            return null;
        }
        Block block = Block.create((long)timestamp, this.newTransactions);
        this.newTransactions.clear();
        this.lastBlockPublishedTime = Utils.getCurrentTimestamp();
        SignedData signedBlock = peer.getKeyPair().signData((ACell)block);
        return signedBlock;
    }

    private long getMinBlockTime() {
        HashMap<Keyword, Object> config = this.server.getConfig();
        Long minBlockTime = Utils.parseLong((Object)config.get(Keywords.MIN_BLOCK_TIME));
        if (minBlockTime == null) {
            minBlockTime = 50L;
        }
        return minBlockTime;
    }

    void maybeGetOwnTransactions(Peer p) {
        String currentHostname;
        long ts = Utils.getCurrentTimestamp();
        if (ts < this.lastOwnTransactionTimestamp + 2000L) {
            return;
        }
        if (!Utils.bool((Object)this.server.getConfig().get(Keywords.AUTO_MANAGE))) {
            return;
        }
        State s = p.getConsensusState();
        String desiredHostname = this.server.getHostname();
        AccountKey peerKey = p.getPeerKey();
        PeerStatus ps = s.getPeer(peerKey);
        if (ps == null) {
            return;
        }
        AString chn = ps.getHostname();
        String string = currentHostname = chn == null ? null : chn.toString();
        if (!Utils.equals((Object)desiredHostname, (Object)currentHostname)) {
            AccountStatus as;
            log.debug("Trying to update own hostname from: {} to {}", (Object)currentHostname, (Object)desiredHostname);
            Address address = ps.getController();
            if (address != null && (as = s.getAccount(address)) != null && Utils.equals((ACell)peerKey, (ACell)as.getAccountKey())) {
                String code = desiredHostname == null ? String.format("(set-peer-data %s {:url nil})", peerKey) : String.format("(set-peer-data %s {:url \"%s\"})", peerKey, desiredHostname);
                ACell message = Reader.read((String)code);
                Invoke transaction = Invoke.create((Address)address, (long)(as.getSequence() + 1L), (ACell)message);
                this.newTransactions.add((SignedData<ATransaction>)p.getKeyPair().signData((ACell)transaction));
                this.lastOwnTransactionTimestamp = ts;
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void start() {
        this.reportedConsensusPoint = this.server.getPeer().getConsensusPoint();
        super.start();
    }

    public boolean isAwaitingResults() {
        return this.interests.size() > 0;
    }

    public int countInterests() {
        return this.interests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loop() throws InterruptedException {
        try {
            LoadMonitor.down();
            Message m = this.txMessageQueue.poll(1000L, TimeUnit.MILLISECONDS);
            LoadMonitor.up();
            if (m == null) {
                return;
            }
            this.messages.add(m);
            this.txMessageQueue.drainTo(this.messages);
            for (Message msg : this.messages) {
                this.processMessage(msg);
            }
            LoadMonitor.down();
            Thread.sleep(this.getMinBlockTime());
            LoadMonitor.up();
        }
        finally {
            this.messages.clear();
        }
    }

    @Override
    protected String getThreadName() {
        return "Transaction handler on port: " + this.server.getPort();
    }
}

