/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.Belief;
import convex.core.ErrorCodes;
import convex.core.Order;
import convex.core.Peer;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.MissingDataException;
import convex.core.init.Init;
import convex.core.lang.RT;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Counters;
import convex.core.util.Shutdown;
import convex.core.util.Utils;
import convex.net.MessageType;
import convex.net.NIOServer;
import convex.net.message.Message;
import convex.peer.BeliefPropagator;
import convex.peer.CVMExecutor;
import convex.peer.ConnectionManager;
import convex.peer.QueryHandler;
import convex.peer.TransactionHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements Closeable {
    public static final int DEFAULT_PORT = 18888;
    static final Logger log = LoggerFactory.getLogger((String)Server.class.getName());
    Consumer<Message> clientReceiveAction = m -> this.processMessage((Message)m);
    Consumer<Message> peerReceiveAction = msg -> {
        if (msg.getType() == MessageType.MISSING_DATA) {
            this.handleMissingData((Message)msg);
        } else {
            this.processMessage((Message)msg);
        }
    };
    protected final ConnectionManager manager = new ConnectionManager(this);
    protected final BeliefPropagator propagator = new BeliefPropagator(this);
    protected final TransactionHandler transactionHandler = new TransactionHandler(this);
    protected final CVMExecutor executor = new CVMExecutor(this);
    protected final QueryHandler queryHandler = new QueryHandler(this);
    private final AStore store;
    private final HashMap<Keyword, Object> config;
    private final ACell rootKey;
    private volatile boolean isRunning = false;
    private NIOServer nio = NIOServer.create(this);
    private Thread beliefMergeThread = null;
    private Address controller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Server(HashMap<Keyword, Object> config) throws TimeoutException, IOException {
        this.config = config;
        this.rootKey = RT.cvm((Object)config.get(Keywords.ROOT_KEY));
        AStore configStore = (AStore)config.get(Keywords.STORE);
        this.store = configStore == null ? Stores.current() : configStore;
        AStore savedStore = Stores.current();
        try {
            Stores.setCurrent((AStore)this.store);
            Peer peer = this.establishPeer();
            this.executor.setPeer(peer);
            this.persistPeerData();
            this.establishController();
        }
        finally {
            Stores.setCurrent((AStore)savedStore);
        }
    }

    private void establishController() {
        Peer peer = this.getPeer();
        Address controlAddress = RT.toAddress((Object)this.getConfig().get(Keywords.CONTROLLER));
        if (controlAddress == null && (controlAddress = peer.getController()) == null) {
            throw new IllegalStateException("Peer Controller account does not exist for Peer Key: " + peer.getPeerKey());
        }
        AccountStatus as = peer.getConsensusState().getAccount(controlAddress);
        if (as == null) {
            log.warn("Peer Controller Account does not exist: " + controlAddress);
        } else if (!as.getAccountKey().equals(this.getKeyPair().getAccountKey())) {
            log.warn("Server keypair does not match keypair for control account: " + controlAddress);
        }
        this.setPeerController(controlAddress);
    }

    private Peer establishPeer() throws TimeoutException, IOException {
        log.debug("Establishing Peer with store: {}", (Object)Stores.current());
        try {
            State genesisState;
            Object source;
            AKeyPair keyPair = (AKeyPair)this.getConfig().get(Keywords.KEYPAIR);
            if (keyPair == null) {
                log.warn("No keypair provided for Server, deafulting to generated keypair for testing purposes");
                keyPair = AKeyPair.generate();
                log.warn("Generated keypair with public key: " + keyPair.getAccountKey());
            }
            if (Utils.bool((Object)(source = this.getConfig().get(Keywords.SOURCE)))) {
                InetSocketAddress sourceAddr = Utils.toInetSocketAddress((Object)source);
                ConvexRemote convex = Convex.connect(sourceAddr);
                log.info("Attempting Peer Sync with: " + sourceAddr);
                long timeout = this.establishTimeout();
                Result result = convex.requestStatusSync(timeout);
                AVector status = (AVector)result.getValue();
                if (status == null || status.count() != 8L) {
                    throw new Error("Bad status message from remote Peer");
                }
                Hash beliefHash = RT.ensureHash((ACell)status.get(0));
                Hash networkID = RT.ensureHash((ACell)status.get(2));
                log.info("Attempting to sync genesis state with network: " + networkID);
                State genF = (State)convex.acquire(networkID).get(timeout, TimeUnit.MILLISECONDS);
                log.info("Retrieved Genesis State: " + networkID);
                log.info("Attempting to obtain peer Belief: " + beliefHash);
                Belief belF = null;
                long timeElapsed = 0L;
                while (belF == null) {
                    try {
                        belF = (Belief)convex.acquire(beliefHash).get(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException te) {
                        log.info("Still waiting for Belief sync after " + (timeElapsed += timeout) / 1000L + "s");
                    }
                }
                log.info("Retrieved Peer Belief: " + beliefHash + " with memory size: " + belF.getMemorySize());
                ((Convex)convex).close();
                Peer peer = Peer.create((AKeyPair)keyPair, (State)genF, (Belief)belF);
                return peer;
            }
            if (Utils.bool((Object)this.getConfig().get(Keywords.RESTORE))) {
                try {
                    Peer peer = Peer.restorePeer((AStore)this.store, (AKeyPair)keyPair, (ACell)this.rootKey);
                    if (peer != null) {
                        log.info("Restored Peer with root data hash: {}", (Object)this.store.getRootHash());
                        return peer;
                    }
                }
                catch (Throwable e) {
                    log.error("Can't restore Peer from store: {}", e);
                }
            }
            if ((genesisState = (State)this.config.get(Keywords.STATE)) != null) {
                log.debug("Defaulting to standard Peer startup with genesis state: " + genesisState.getHash());
            } else {
                AccountKey peerKey = keyPair.getAccountKey();
                genesisState = Init.createState(List.of(peerKey));
                log.debug("Created new genesis state: " + genesisState.getHash() + " with initial peer: " + peerKey);
            }
            return Peer.createGenesisPeer((AKeyPair)keyPair, (State)genesisState);
        }
        catch (InterruptedException | ExecutionException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    private long establishTimeout() {
        Object maybeTimeout = this.getConfig().get(Keywords.TIMEOUT);
        if (maybeTimeout == null) {
            return 60000L;
        }
        Utils.toInt((Object)maybeTimeout);
        return 0L;
    }

    public static Server create(HashMap<Keyword, Object> config) throws TimeoutException, IOException {
        return new Server(new HashMap<Keyword, Object>(config));
    }

    public Belief getBelief() {
        return this.getPeer().getBelief();
    }

    public Peer getPeer() {
        return this.executor.getPeer();
    }

    public String getHostname() {
        return (String)this.config.get(Keywords.URL);
    }

    public void launch() {
        AStore savedStore = Stores.current();
        try {
            Stores.setCurrent((AStore)this.store);
            HashMap<Keyword, Object> config = this.getConfig();
            Object p = config.get(Keywords.PORT);
            Integer port = p == null ? null : Integer.valueOf(Utils.toInt((Object)p));
            this.nio.launch((String)config.get(Keywords.BIND_ADDRESS), port);
            port = this.nio.getPort();
            this.isRunning = true;
            this.manager.start();
            this.queryHandler.start();
            this.propagator.start();
            this.transactionHandler.start();
            this.executor.start();
            Shutdown.addHook((int)80, () -> this.close());
            if (this.getConfig().containsKey(Keywords.SOURCE)) {
                Object s = this.getConfig().get(Keywords.SOURCE);
                InetSocketAddress sa = Utils.toInetSocketAddress((Object)s);
                if (sa != null) {
                    if (this.manager.connectToPeer(sa) != null) {
                        log.debug("Automatically connected to :source peer at: {}", (Object)sa);
                    } else {
                        log.warn("Failed to connect to :source peer at: {}", (Object)sa);
                    }
                } else {
                    log.warn("Failed to parse :source peer address {}", s);
                }
            }
            log.info("Peer Server started at " + this.nio.getHostAddress() + " with Peer Address: {}", (Object)this.getPeerKey());
        }
        catch (Exception e) {
            this.close();
            throw new Error("Failed to launch Server", e);
        }
        finally {
            Stores.setCurrent((AStore)savedStore);
        }
    }

    protected void processMessage(Message m) {
        MessageType type = m.getType();
        try {
            switch (type) {
                case BELIEF: {
                    this.processBelief(m);
                    break;
                }
                case CHALLENGE: {
                    this.processChallenge(m);
                    break;
                }
                case RESPONSE: {
                    this.processResponse(m);
                    break;
                }
                case COMMAND: {
                    break;
                }
                case DATA: {
                    this.processData(m);
                    break;
                }
                case MISSING_DATA: {
                    this.processQuery(m);
                    break;
                }
                case QUERY: {
                    this.processQuery(m);
                    break;
                }
                case RESULT: {
                    break;
                }
                case TRANSACT: {
                    this.processTransact(m);
                    break;
                }
                case GOODBYE: {
                    this.processClose(m);
                    break;
                }
                case STATUS: {
                    this.processStatus(m);
                    break;
                }
                default: {
                    Result r = Result.create((CVMLong)m.getID(), (ACell)Strings.create((String)("Bad Message Type: " + type)), (ACell)ErrorCodes.ARGUMENT);
                    m.reportResult(r);
                    break;
                }
            }
        }
        catch (MissingDataException e) {
            Hash missingHash = e.getMissingHash();
            log.trace("Missing data: {} in message of type {}", (Object)missingHash, (Object)type);
        }
        catch (Throwable e) {
            log.warn("Error processing client message: {}", e);
        }
    }

    protected void handleMissingData(Message m) {
        Hash h = RT.ensureHash(m.getPayload());
        if (h == null) {
            log.warn("Bad missing data request, not a Hash, terminating client");
            m.getConnection().close();
            return;
        }
        Ref r = this.store.refForHash(h);
        if (r != null) {
            try {
                ACell data = r.getValue();
                boolean sent = m.sendData(data);
                if (!sent) {
                    log.trace("Can't send missing data for hash {} due to full buffer", (Object)h);
                }
            }
            catch (Exception e) {
                log.trace("Unable to deliver missing data for {} due to exception: {}", (Object)h, (Object)e);
            }
        }
    }

    protected void processTransact(Message m) {
        boolean queued = this.transactionHandler.offerTransaction(m);
        if (!queued) {
            Result r = Result.create((CVMLong)m.getID(), (ACell)Strings.SERVER_LOADED, (ACell)ErrorCodes.LOAD);
            m.reportResult(r);
        }
    }

    protected void processClose(Message m) {
        m.closeConnection();
    }

    public long getBroadcastCount() {
        return this.propagator.getBeliefBroadcastCount();
    }

    public long getBeliefReceivedCount() {
        return this.propagator.beliefReceivedCount;
    }

    public Address getPeerController() {
        return this.controller;
    }

    public void setPeerController(Address a) {
        this.controller = a;
    }

    public boolean queueBelief(Message event) {
        boolean offered = this.propagator.queueBelief(event);
        return offered;
    }

    protected void processStatus(Message m) {
        try {
            log.trace("Processing status request from: {}", (Object)m.getOriginString());
            AVector<ACell> reply = this.getStatusVector();
            Result r = Result.create((CVMLong)m.getID(), reply);
            m.reportResult(r);
        }
        catch (Throwable t) {
            log.warn("Status Request Error:", t);
        }
    }

    public AVector<ACell> getStatusVector() {
        Peer peer = this.getPeer();
        Belief belief = peer.getBelief();
        State state = peer.getConsensusState();
        Hash beliefHash = belief.getHash();
        Hash stateHash = state.getHash();
        Hash genesisHash = peer.getNetworkID();
        AccountKey peerKey = peer.getPeerKey();
        Hash consensusHash = state.getHash();
        Order order = belief.getOrder(peerKey);
        CVMLong cp = CVMLong.create((long)order.getConsensusPoint());
        CVMLong pp = CVMLong.create((long)order.getProposalPoint());
        CVMLong op = CVMLong.create((long)order.getBlockCount());
        AVector reply = Vectors.of((Object[])new Object[]{beliefHash, stateHash, genesisHash, peerKey, consensusHash, cp, pp, op});
        return reply;
    }

    private void processChallenge(Message m) {
        this.manager.processChallenge(m, this.getPeer());
    }

    protected void processResponse(Message m) {
        this.manager.processResponse(m, this.getPeer());
    }

    protected void processQuery(Message m) {
        boolean queued = this.queryHandler.offerQuery(m);
        if (!queued) {
            Result r = Result.create((CVMLong)m.getID(), (ACell)Strings.SERVER_LOADED, (ACell)ErrorCodes.LOAD);
            m.reportResult(r);
        }
    }

    private void processData(Message m) {
        Object payload = m.getPayload();
        ++Counters.peerDataReceived;
        Ref r = Ref.get(payload);
        if (r.isEmbedded()) {
            log.warn("DATA with embedded value: " + payload);
            return;
        }
        r = r.persistShallow();
        if (log.isTraceEnabled()) {
            Hash payloadHash = r.getHash();
            log.trace("Processing DATA of type: " + Utils.getClassName(payload) + " with hash: " + payloadHash.toHexString());
        }
    }

    protected void processBelief(Message m) {
        if (!this.propagator.queueBelief(m)) {
            log.warn("Incoming belief queue full");
        }
    }

    public int getPort() {
        return this.nio.getPort();
    }

    public void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean persistPeerData() {
        AStore tempStore = Stores.current();
        try {
            Stores.setCurrent((AStore)this.store);
            AMap peerData = this.getPeer().toData();
            if (this.rootKey != null) {
                Ref rootRef = this.store.refForHash(this.store.getRootHash());
                AHashMap currentRootData = rootRef == null ? Maps.empty() : (AMap)rootRef.getValue();
                peerData = currentRootData.assoc(this.rootKey, (ACell)peerData);
            }
            this.store.setRootData((ACell)peerData);
            log.debug("Stored peer data for Server with hash: {}", (Object)peerData.getHash().toHexString());
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            log.warn("Failed to persist peer state: {}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            Stores.setCurrent((AStore)tempStore);
        }
    }

    @Override
    public void close() {
        if (!this.isRunning) {
            return;
        }
        this.propagator.close();
        this.queryHandler.close();
        this.transactionHandler.close();
        this.executor.close();
        Peer peer = this.getPeer();
        if (peer != null && Utils.bool((Object)this.getConfig().get(Keywords.PERSIST))) {
            this.persistPeerData();
        }
        this.isRunning = false;
        if (this.beliefMergeThread != null) {
            this.beliefMergeThread.interrupt();
            try {
                this.beliefMergeThread.join(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.manager.close();
        this.nio.close();
        log.info("Peer shutdown complete for " + peer.getPeerKey());
    }

    public InetSocketAddress getHostAddress() {
        return this.nio.getHostAddress();
    }

    public AKeyPair getKeyPair() {
        return this.getPeer().getKeyPair();
    }

    public AccountKey getPeerKey() {
        AKeyPair kp = this.getKeyPair();
        if (kp == null) {
            return null;
        }
        return kp.getAccountKey();
    }

    public AStore getStore() {
        return this.store;
    }

    public ConnectionManager getConnectionManager() {
        return this.manager;
    }

    public HashMap<Keyword, Object> getConfig() {
        return this.config;
    }

    public Consumer<Message> getReceiveAction() {
        return this.clientReceiveAction;
    }

    public void setHostname(String string) {
        this.config.put(Keywords.URL, string);
    }

    public boolean isLive() {
        return this.isRunning;
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    public BeliefPropagator getBeliefPropagator() {
        return this.propagator;
    }

    public void updateBelief(Belief belief) {
        this.executor.queueUpdate(belief);
    }

    public CVMExecutor getCVMExecutor() {
        return this.executor;
    }

    public QueryHandler getQueryProcessor() {
        return this.queryHandler;
    }
}

