/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.prim.CVMLong;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.util.LoadMonitor;
import convex.net.MessageType;
import convex.net.message.Message;
import convex.peer.AThreadedComponent;
import convex.peer.Server;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class QueryHandler
extends AThreadedComponent {
    private ArrayBlockingQueue<Message> queryQueue = new ArrayBlockingQueue(1000);

    public QueryHandler(Server server) {
        super(server);
    }

    public boolean offerQuery(Message m) {
        return this.queryQueue.offer(m);
    }

    @Override
    protected void loop() throws InterruptedException {
        LoadMonitor.down();
        Message m = this.queryQueue.poll(10000L, TimeUnit.MILLISECONDS);
        LoadMonitor.up();
        if (m == null) {
            return;
        }
        MessageType type = m.getType();
        switch (type) {
            case QUERY: {
                this.handleQuery(m);
                break;
            }
            case MISSING_DATA: {
                this.server.handleMissingData(m);
                break;
            }
            default: {
                log.warn("Unexpected Message type on query queue: " + type);
            }
        }
    }

    private void handleQuery(Message m) {
        try {
            AVector v = (AVector)m.getPayload();
            CVMLong id = (CVMLong)v.get(0);
            ACell form = v.get(1);
            Address address = RT.ensureAddress((ACell)v.get(2));
            log.debug("Processing query: {} with address: {}", (Object)form, (Object)address);
            Context resultContext = this.server.getPeer().executeQuery(form, address);
            boolean resultReturned = m.reportResult(Result.fromContext((CVMLong)id, (Context)resultContext));
            if (!resultReturned) {
                log.warn("Failed to send query result back to client with ID: {}", (Object)id);
            }
        }
        catch (Throwable t) {
            log.warn("Query Error: {}", t);
        }
    }

    @Override
    protected String getThreadName() {
        return "Query handler on port: " + this.server.getPort();
    }
}

