/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.Belief;
import convex.core.Constants;
import convex.core.Peer;
import convex.core.Result;
import convex.core.State;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Hash;
import convex.core.data.Keywords;
import convex.core.data.PeerStatus;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.lang.RT;
import convex.core.util.LoadMonitor;
import convex.core.util.Utils;
import convex.net.ChallengeRequest;
import convex.net.Connection;
import convex.net.message.Message;
import convex.net.message.MessageRemote;
import convex.peer.AThreadedComponent;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.UnresolvedAddressException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager
extends AThreadedComponent {
    private static final Logger log = LoggerFactory.getLogger((String)ConnectionManager.class.getName());
    static final long SERVER_CONNECTION_PAUSE = 500L;
    static final long SERVER_POLL_DELAY = 2000L;
    static final long POLL_TIMEOUT_MILLIS = 2000L;
    static final long POLL_ACQUIRE_TIMEOUT_MILLIS = 12000L;
    private static final long BROADCAST_TIMEOUT = 1000L;
    private final HashMap<AccountKey, Connection> connections = new HashMap();
    private HashMap<AccountKey, ChallengeRequest> challengeList = new HashMap();
    private SecureRandom random = new SecureRandom();
    private long pollDelay;
    private long lastConnectionUpdate = Utils.getCurrentTimestamp();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollBelief() {
        block8: {
            try {
                long lastConsensus = this.server.getPeer().getConsensusState().getTimestamp().longValue();
                if (lastConsensus + this.pollDelay >= Utils.getCurrentTimestamp()) {
                    return;
                }
                ArrayList<Connection> conns = new ArrayList<Connection>(this.connections.values());
                if (conns.size() == 0) {
                    return;
                }
                Connection c = conns.get(this.random.nextInt(conns.size()));
                if (c.isClosed()) {
                    return;
                }
                try (ConvexRemote convex = Convex.connect(c.getRemoteAddress());){
                    Result result = convex.requestStatusSync(2000L);
                    AVector status = (AVector)result.getValue();
                    Hash h = RT.ensureHash((ACell)status.get(0));
                    Belief sb = (Belief)convex.acquire(h).get(12000L, TimeUnit.MILLISECONDS);
                    this.server.queueBelief(Message.createBelief(sb));
                }
            }
            catch (Throwable t) {
                if (!this.server.isLive()) break block8;
                log.warn("Belief Polling failed: {}", (Object)(t.getClass().toString() + " : " + t.getMessage()));
            }
        }
    }

    protected void maintainConnections() {
        AccountKey[] peers;
        State s = this.server.getPeer().getConsensusState();
        long now = Utils.getCurrentTimestamp();
        long millisSinceLastUpdate = Math.max(0L, now - this.lastConnectionUpdate);
        int targetPeerCount = this.getTargetPeerCount();
        int currentPeerCount = this.connections.size();
        double totalStake = (Double)s.computeStakes().get(null);
        for (AccountKey p : peers = this.connections.keySet().toArray(new AccountKey[currentPeerCount])) {
            double prop;
            double keepChance;
            Connection conn = this.connections.get(p);
            if (conn == null || conn.isClosed()) {
                this.closeConnection(p);
                --currentPeerCount;
                continue;
            }
            PeerStatus ps = s.getPeer(p);
            if (ps == null || ps.getTotalStake() <= 1000000000L) {
                this.closeConnection(p);
                --currentPeerCount;
                continue;
            }
            if (millisSinceLastUpdate > 0L && currentPeerCount >= targetPeerCount && (keepChance = Math.min(1.0, (prop = (double)ps.getTotalStake() / totalStake) * (double)targetPeerCount)) < 1.0) {
                double dropRate = (double)millisSinceLastUpdate / 20000.0;
                if (this.random.nextDouble() < dropRate * (1.0 - keepChance)) {
                    this.closeConnection(p);
                    --currentPeerCount;
                    continue;
                }
            }
            this.requestChallenge(p, conn, this.server.getPeer());
        }
        currentPeerCount = this.connections.size();
        peers = this.connections.keySet().toArray(new AccountKey[currentPeerCount]);
        if (peers.length < targetPeerCount) {
            Set potentialPeers = s.getPeers().keySet();
            InetSocketAddress target = null;
            double accStake = 0.0;
            for (ACell c : potentialPeers) {
                long peerStake;
                InetSocketAddress maybeAddress;
                AString hostName;
                PeerStatus ps;
                AccountKey peerKey = RT.ensureAccountKey((ACell)c);
                if (this.connections.containsKey(peerKey) || this.server.getPeerKey().equals(peerKey) || (ps = (PeerStatus)s.getPeers().get((ABlob)peerKey)) == null || (hostName = ps.getHostname()) == null || (maybeAddress = Utils.toInetSocketAddress((String)hostName.toString())) == null || (peerStake = ps.getTotalStake()) <= 0L) continue;
                double t = this.random.nextDouble() * (accStake + (double)peerStake);
                if (t >= accStake) {
                    target = maybeAddress;
                }
                accStake += (double)peerStake;
            }
            if (target != null) {
                this.connectToPeer(target);
            }
        }
        this.lastConnectionUpdate = Utils.getCurrentTimestamp();
    }

    private int getTargetPeerCount() {
        Integer target;
        try {
            target = Utils.toInt((Object)this.server.getConfig().get(Keywords.OUTGOING_CONNECTIONS));
        }
        catch (Exception ex) {
            target = null;
        }
        if (target == null) {
            target = Constants.DEFAULT_OUTGOING_CONNECTION_COUNT;
        }
        return target;
    }

    public ConnectionManager(Server server) {
        super(server);
    }

    public synchronized void closeConnection(AccountKey peerKey) {
        if (this.connections.containsKey(peerKey)) {
            Connection conn = this.connections.get(peerKey);
            if (conn != null) {
                conn.close();
            }
            this.connections.remove(peerKey);
        }
    }

    public synchronized void closeAllConnections() {
        for (Connection conn : this.connections.values()) {
            if (conn == null) continue;
            conn.close();
        }
        this.connections.clear();
    }

    public HashMap<AccountKey, Connection> getConnections() {
        return this.connections;
    }

    public boolean isConnected(AccountKey peerKey) {
        return this.connections.containsKey(peerKey);
    }

    public Connection getConnection(AccountKey peerKey) {
        if (!this.connections.containsKey(peerKey)) {
            return null;
        }
        return this.connections.get(peerKey);
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    public int getTrustedConnectionCount() {
        int result = 0;
        for (Connection connection : this.connections.values()) {
            if (!connection.isTrusted()) continue;
            ++result;
        }
        return result;
    }

    public void processChallenge(Message m, Peer thisPeer) {
        try {
            SignedData signedData = (SignedData)m.getPayload();
            if (signedData == null) {
                log.debug("challenge bad message data sent");
                return;
            }
            AVector challengeValues = (AVector)signedData.getValue();
            if (challengeValues == null || challengeValues.size() != 3) {
                log.debug("challenge data incorrect number of items should be 3 not ", (Object)RT.count((ACell)challengeValues));
                return;
            }
            Connection pc = ((MessageRemote)m).getConnection();
            if (pc == null) {
                log.warn("No remote peer connection from challenge");
                return;
            }
            Hash token = RT.ensureHash((ACell)challengeValues.get(0));
            if (token == null) {
                log.warn("no challenge token provided");
                return;
            }
            Hash networkId = RT.ensureHash((ACell)challengeValues.get(1));
            if (networkId == null) {
                log.warn("challenge data has no networkId");
                return;
            }
            if (!networkId.equals(thisPeer.getNetworkID())) {
                log.warn("challenge data has incorrect networkId");
                return;
            }
            AccountKey toPeer = RT.ensureAccountKey((ACell)challengeValues.get(2));
            if (toPeer == null) {
                log.warn("challenge data has no toPeer address");
                return;
            }
            if (!toPeer.equals(thisPeer.getPeerKey())) {
                log.warn("challenge data has incorrect addressed peer");
                return;
            }
            AccountKey fromPeer = signedData.getAccountKey();
            AVector responseValues = Vectors.of((Object[])new Object[]{token, thisPeer.getNetworkID(), fromPeer, signedData.getHash()});
            SignedData response = thisPeer.sign((ACell)responseValues);
            if (pc.sendResponse((SignedData<ACell>)response) == -1L) {
                log.warn("Failed sending response from challenge to ", (Object)pc.getRemoteAddress());
            }
        }
        catch (Throwable t) {
            log.error("Challenge Error: {}", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AccountKey processResponse(Message m, Peer thisPeer) {
        try {
            SignedData signedData = (SignedData)m.getPayload();
            log.debug("Processing response request from: {}", (Object)m.getOriginString());
            AVector responseValues = (AVector)signedData.getValue();
            if (responseValues.size() != 4) {
                log.warn("response data incorrect number of items should be 4 not {}", (Object)responseValues.size());
                return null;
            }
            Hash token = RT.ensureHash((ACell)responseValues.get(0));
            if (token == null) {
                log.warn("no response token provided");
                return null;
            }
            Hash networkId = RT.ensureHash((ACell)responseValues.get(1));
            if (networkId == null || !networkId.equals(thisPeer.getNetworkID())) {
                log.warn("response data has incorrect networkId");
                return null;
            }
            AccountKey toPeer = RT.ensureAccountKey((ACell)responseValues.get(2));
            if (toPeer == null || !toPeer.equals(thisPeer.getPeerKey())) {
                log.warn("response data has incorrect addressed peer");
                return null;
            }
            Hash challengeHash = RT.ensureHash((ACell)responseValues.get(3));
            AccountKey fromPeer = signedData.getAccountKey();
            if (!this.challengeList.containsKey(fromPeer)) {
                log.warn("response from an unkown challenge");
                return null;
            }
            HashMap<AccountKey, ChallengeRequest> hashMap = this.challengeList;
            synchronized (hashMap) {
                ChallengeRequest challengeRequest = this.challengeList.get(fromPeer);
                Hash challengeToken = challengeRequest.getToken();
                if (!challengeToken.equals(token)) {
                    log.warn("invalid response token sent");
                    return null;
                }
                AccountKey challengeFromPeer = challengeRequest.getPeerKey();
                if (!signedData.getAccountKey().equals(challengeFromPeer)) {
                    log.warn("response key does not match requested key, sent from a different peer");
                    return null;
                }
                Hash challengeSourceHash = challengeRequest.getSendHash();
                if (!challengeHash.equals(challengeSourceHash)) {
                    log.warn("response hash of the challenge does not match");
                    return null;
                }
                this.challengeList.remove(fromPeer);
                Connection connection = this.getConnection(fromPeer);
                if (connection != null) {
                    connection.setTrustedPeerKey(fromPeer);
                }
                return fromPeer;
            }
        }
        catch (Throwable t) {
            log.error("Response Error: {}", t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestChallenge(AccountKey toPeerKey, Connection connection, Peer thisPeer) {
        HashMap<AccountKey, ChallengeRequest> hashMap = this.challengeList;
        synchronized (hashMap) {
            ChallengeRequest request;
            if (connection.isTrusted()) {
                return;
            }
            if (this.challengeList.containsKey(toPeerKey)) {
                if (!this.challengeList.get(toPeerKey).isTimedout()) {
                    return;
                }
                this.challengeList.remove(toPeerKey);
            }
            if ((request = ChallengeRequest.create(toPeerKey)).send(connection, thisPeer) >= 0L) {
                this.challengeList.put(toPeerKey, request);
            }
        }
    }

    public synchronized void broadcast(Message msg) throws InterruptedException {
        HashMap<AccountKey, Connection> hm = this.getCurrentConnections();
        long start = Utils.getCurrentTimestamp();
        while (!hm.isEmpty() && start + 1000L > Utils.getCurrentTimestamp()) {
            ArrayList<Map.Entry<AccountKey, Connection>> left = new ArrayList<Map.Entry<AccountKey, Connection>>(hm.entrySet());
            Utils.shuffle(left);
            for (Map.Entry<AccountKey, Connection> me : left) {
                Connection pc = me.getValue();
                try {
                    boolean sent = pc.sendMessage(msg);
                    if (!sent) continue;
                    hm.remove(me.getKey());
                }
                catch (ClosedChannelException e) {
                    log.debug("Closed channel during broadcast");
                    pc.close();
                }
                catch (IOException e) {
                    log.debug("IO Error in broadcast: ", (Throwable)e);
                    pc.close();
                }
            }
            if (hm.isEmpty()) break;
            LoadMonitor.down();
            Thread.sleep(10L);
            LoadMonitor.up();
        }
        if (!hm.isEmpty() && this.server.isLive()) {
            log.warn("Unable to send broadcast to " + hm.size() + " peers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<AccountKey, Connection> getCurrentConnections() {
        HashMap<AccountKey, Connection> hashMap = this.connections;
        synchronized (hashMap) {
            return new HashMap<AccountKey, Connection>(this.connections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connectToPeer(InetSocketAddress hostAddress) {
        Connection newConn = null;
        try {
            ConvexRemote convex = Convex.connect(hostAddress);
            Result result = convex.requestStatusSync(10000L);
            AVector status = (AVector)result.getValue();
            ((Convex)convex).close();
            if (status == null || status.count() != 8L) {
                throw new Error("Bad status message from remote Peer");
            }
            AccountKey peerKey = RT.ensureAccountKey((ACell)status.get(3));
            if (peerKey == null) {
                return null;
            }
            Connection existing = this.connections.get(peerKey);
            if (existing != null && !existing.isClosed()) {
                return existing;
            }
            HashMap<AccountKey, Connection> hashMap = this.connections;
            synchronized (hashMap) {
                newConn = Connection.connect(hostAddress, this.server.peerReceiveAction, this.server.getStore(), null, 0x100000, 0x100000);
                this.connections.put(peerKey, newConn);
            }
        }
        catch (IOException | TimeoutException convex) {
        }
        catch (UnresolvedAddressException e) {
            log.info("Unable to resolve host address: " + hostAddress);
        }
        return newConn;
    }

    @Override
    public void close() {
        try {
            Message msg = Message.createGoodBye();
            this.broadcast(msg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.close();
    }

    @Override
    public void start() {
        Object _pollDelay = this.server.getConfig().get(Keywords.POLL_DELAY);
        this.pollDelay = _pollDelay == null ? 2000L : (long)Utils.toInt((Object)_pollDelay);
        super.start();
    }

    @Override
    protected void loop() throws InterruptedException {
        LoadMonitor.down();
        Thread.sleep(500L);
        LoadMonitor.up();
        this.maintainConnections();
        this.pollBelief();
    }

    @Override
    protected String getThreadName() {
        return "Connection Manager thread at " + this.server.getPort();
    }
}

