/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Belief;
import convex.core.Peer;
import convex.core.util.LatestUpdateQueue;
import convex.core.util.LoadMonitor;
import convex.peer.AThreadedComponent;
import convex.peer.Server;
import java.util.concurrent.TimeUnit;

public class CVMExecutor
extends AThreadedComponent {
    private Peer peer;
    private LatestUpdateQueue<Belief> update = new LatestUpdateQueue();

    public CVMExecutor(Server server) {
        super(server);
    }

    @Override
    protected void loop() throws InterruptedException {
        LoadMonitor.down();
        Belief beliefUpdate = (Belief)this.update.poll(1000L, TimeUnit.MILLISECONDS);
        LoadMonitor.up();
        if (beliefUpdate != null) {
            this.peer = this.peer.updateBelief(beliefUpdate);
        }
        this.peer = this.peer.updateState();
        this.server.transactionHandler.maybeReportTransactions(this.peer);
    }

    @Override
    protected String getThreadName() {
        return "CVM Executor thread on port " + this.server.getPort();
    }

    public void setPeer(Peer peer) {
        this.peer = peer;
    }

    public Peer getPeer() {
        return this.peer;
    }

    public void queueUpdate(Belief belief) {
        this.update.offer((Object)belief);
    }
}

