/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Belief;
import convex.core.Block;
import convex.core.ErrorCodes;
import convex.core.MergeContext;
import convex.core.Order;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.MissingDataException;
import convex.core.util.LoadMonitor;
import convex.core.util.Utils;
import convex.net.message.Message;
import convex.peer.AThreadedComponent;
import convex.peer.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeliefPropagator
extends AThreadedComponent {
    private static final long AWAIT_BELIEFS_PAUSE = 60L;
    public static final int BELIEF_REBROADCAST_DELAY = 300;
    public static final int BELIEF_BROADCAST_DELAY = 10;
    public static final int BELIEF_BROADCAST_POLL_TIME = 1000;
    private ArrayBlockingQueue<Message> beliefQueue = new ArrayBlockingQueue(500);
    static final Logger log = LoggerFactory.getLogger((String)BeliefPropagator.class.getName());
    private static final boolean ANALYSE_MISSING = false;
    long beliefReceivedCount = 0L;
    long lastBroadcastTime = 0L;
    private long beliefBroadcastCount = 0L;
    Belief belief = null;
    private Belief lastBroadcastBelief;

    public BeliefPropagator(Server server) {
        super(server);
    }

    public boolean isRebroadcastDue() {
        return this.lastBroadcastTime + 300L < Utils.getCurrentTimestamp();
    }

    public long getBeliefBroadcastCount() {
        return this.beliefBroadcastCount;
    }

    public synchronized boolean queueBelief(Message beliefMessage) {
        return this.beliefQueue.offer(beliefMessage);
    }

    @Override
    protected void loop() throws InterruptedException {
        Belief incomingBelief = this.awaitBelief();
        boolean updated = this.maybeUpdateBelief(incomingBelief);
        if (this.server.manager.getConnectionCount() > 0) {
            long ts = Utils.getCurrentTimestamp();
            if (updated || ts > this.lastBroadcastTime + 10L) {
                this.lastBroadcastTime = ts;
                Message msg = this.createBeliefUpdateMessage();
                if (updated) {
                    this.server.updateBelief(this.belief);
                }
                this.doBroadcast(msg);
            }
        }
        this.belief = (Belief)ACell.createPersisted((ACell)this.belief).getValue();
        if (updated) {
            this.server.updateBelief(this.belief);
        }
    }

    @Override
    public void start() {
        this.belief = this.server.getBelief();
        super.start();
    }

    protected boolean maybeUpdateBelief(Belief newBelief) throws InterruptedException {
        boolean updated = this.maybeMergeBeliefs(newBelief);
        if (updated) {
            this.maybeMergeBeliefs(new Belief[0]);
        }
        SignedData<Block> signedBlock = this.server.transactionHandler.maybeGenerateBlock(this.server.getPeer());
        boolean published = false;
        if (signedBlock != null) {
            this.belief = this.belief.proposeBlock(this.server.getKeyPair(), signedBlock);
            if (log.isDebugEnabled()) {
                Block bl = (Block)signedBlock.getValue();
                log.debug("New block proposed: {} transaction(s), size= {}, hash={}", new Object[]{bl.getTransactions().count(), signedBlock.getMemorySize(), signedBlock.getHash()});
            }
            published = true;
        }
        return updated || published;
    }

    protected boolean maybeMergeBeliefs(Belief ... newBeliefs) {
        try {
            long ts = Utils.getCurrentTimestamp();
            AKeyPair kp = this.server.getKeyPair();
            MergeContext mc = MergeContext.create((Belief)this.belief, (AKeyPair)kp, (long)ts, (State)this.server.getPeer().getConsensusState());
            Belief newBelief = this.belief.merge(mc, newBeliefs);
            boolean beliefChanged = this.belief != newBelief;
            this.belief = newBelief;
            return beliefChanged;
        }
        catch (MissingDataException e) {
            throw new Error("Missing data in belief update: " + e.getMissingHash().toHexString(), e);
        }
        catch (InvalidDataException e) {
            throw new Error("Invalid data in belief update!", e);
        }
    }

    private Belief awaitBelief() throws InterruptedException {
        ArrayList<Message> beliefMessages = new ArrayList<Message>();
        LoadMonitor.down();
        Message firstEvent = this.beliefQueue.poll(60L, TimeUnit.MILLISECONDS);
        LoadMonitor.up();
        if (firstEvent == null) {
            return null;
        }
        beliefMessages.add(firstEvent);
        this.beliefQueue.drainTo(beliefMessages);
        HashMap newOrders = this.belief.getOrdersHashMap();
        boolean anyOrderChanged = false;
        for (Message m : beliefMessages) {
            anyOrderChanged = this.mergeBeliefMessage(newOrders, m);
        }
        if (!anyOrderChanged) {
            return null;
        }
        Belief newBelief = Belief.create((HashMap)newOrders);
        return newBelief;
    }

    protected boolean mergeBeliefMessage(HashMap<AccountKey, SignedData<Order>> newOrders, Message m) {
        boolean changed = false;
        AccountKey myKey = this.server.getPeerKey();
        try {
            ++this.beliefReceivedCount;
            try {
                Object payload = m.getPayload();
                Collection a = Belief.extractOrders(payload);
                for (SignedData so : a) {
                    try {
                        AccountKey key = so.getAccountKey();
                        if (Utils.equals((ACell)myKey, (ACell)key)) continue;
                        if (newOrders.containsKey(key)) {
                            Order newOrder = (Order)so.getValue();
                            Order oldOrder = (Order)newOrders.get(key).getValue();
                            boolean replace = Belief.compareOrders((Order)oldOrder, (Order)newOrder);
                            if (!replace) continue;
                        }
                        if (!so.checkSignature()) {
                            log.warn("Bad Order signature");
                            m.reportResult(Result.create((CVMLong)m.getID(), (ACell)Strings.BAD_SIGNATURE, (ACell)ErrorCodes.SIGNATURE));
                            continue;
                        }
                        so = (SignedData)ACell.createPersisted((ACell)so).getValue();
                        newOrders.put(key, (SignedData<Order>)so);
                        changed = true;
                    }
                    catch (MissingDataException e) {
                        Hash h = e.getMissingHash();
                        log.warn("Missing data in Order! {}", (Object)h);
                        this.analyseMissing(h, m, (SignedData<Order>)so);
                        if (m.sendMissingData(e.getMissingHash())) continue;
                        log.warn("Unable to request Missing data in Belief!");
                    }
                }
            }
            catch (MissingDataException e) {
                Hash h = e.getMissingHash();
                log.warn("Missing data in Belief! {}", (Object)h);
                if (!m.sendMissingData(e.getMissingHash())) {
                    log.warn("Unable to request Missing data in Belief!");
                }
            }
        }
        catch (ClassCastException e) {
            log.warn("Class cast exception in Belief!", (Throwable)e);
            m.reportResult(Result.create((CVMLong)m.getID(), (ACell)Strings.BAD_FORMAT, (ACell)ErrorCodes.FORMAT));
        }
        catch (Exception e) {
            log.warn("Unexpected exception getting Belief", (Throwable)e);
        }
        return changed;
    }

    private void analyseMissing(Hash h, Message m, SignedData<Order> so) throws BadFormatException {
    }

    private void doBroadcast(Message msg) throws InterruptedException {
        this.server.manager.broadcast(msg);
        ++this.beliefBroadcastCount;
    }

    private Message createBeliefUpdateMessage() {
        ArrayList<ACell> novelty = new ArrayList<ACell>();
        Consumer<Ref> noveltyHandler = r -> {
            ACell o = r.getValue();
            novelty.add(o);
        };
        this.lastBroadcastBelief = this.belief = (Belief)ACell.createAnnounced((ACell)this.belief, noveltyHandler);
        Message msg = Message.createBelief(this.belief, novelty);
        long mdc = msg.getMessageData().count();
        if ((double)mdc >= 9500000.0) {
            log.warn("Long Belief Delta message: " + mdc);
        }
        return msg;
    }

    public Belief getLastBroadcastBelief() {
        return this.lastBroadcastBelief;
    }

    @Override
    protected String getThreadName() {
        return "Belief propagator thread on port " + this.server.getPort();
    }
}

