/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Peer;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Lists;
import convex.core.init.Init;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Utils;
import convex.peer.ConnectionManager;
import convex.peer.Server;
import etch.EtchStore;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class API {
    protected static final Logger log = LoggerFactory.getLogger((String)API.class.getName());

    public static Server launchPeer(Map<Keyword, Object> peerConfig) {
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>(peerConfig);
        if (!(config.containsKey(Keywords.STATE) || config.containsKey(Keywords.STORE) || config.containsKey(Keywords.SOURCE))) {
            throw new IllegalArgumentException("Peer launch requires a genesis :state, remote :source or existing :store in config");
        }
        if (!config.containsKey(Keywords.KEYPAIR)) {
            throw new IllegalArgumentException("Peer launch requires a " + Keywords.KEYPAIR + " in config");
        }
        AStore tempStore = Stores.current();
        try {
            InetAddress ip;
            EtchStore store;
            if (!config.containsKey(Keywords.PORT)) {
                config.put(Keywords.PORT, null);
            }
            if (config.containsKey(Keywords.STORE)) {
                store = (AStore)config.get(Keywords.STORE);
            } else {
                store = EtchStore.createTemp((String)"defaultPeerStore");
                config.put(Keywords.STORE, store);
            }
            Stores.setCurrent((AStore)store);
            if (!config.containsKey(Keywords.RESTORE)) {
                config.put(Keywords.RESTORE, true);
            }
            if (!config.containsKey(Keywords.PERSIST)) {
                config.put(Keywords.PERSIST, true);
            }
            if (!config.containsKey(Keywords.AUTO_MANAGE)) {
                config.put(Keywords.AUTO_MANAGE, true);
            }
            if (config.containsKey(Keywords.URL) && !config.containsKey(Keywords.BIND_ADDRESS) && !(ip = InetAddress.getByName((String)config.get(Keywords.URL))).isAnyLocalAddress() && !ip.isLoopbackAddress()) {
                config.put(Keywords.BIND_ADDRESS, "0.0.0.0");
            }
            Server server = Server.create(config);
            server.launch();
            Server server2 = server;
            return server2;
        }
        catch (Throwable t) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)t);
        }
        finally {
            Stores.setCurrent((AStore)tempStore);
        }
    }

    public static Server launchPeer() {
        AKeyPair kp = AKeyPair.generate();
        State genesis = Init.createBaseState((List)Lists.of((Object[])new Object[]{kp.getAccountKey()}));
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
        config.put(Keywords.KEYPAIR, kp);
        config.put(Keywords.STATE, genesis);
        return API.launchPeer(config);
    }

    public static List<Server> launchLocalPeers(List<AKeyPair> keyPairs, State genesisState) {
        return API.launchLocalPeers(keyPairs, genesisState, null);
    }

    public static List<Server> launchLocalPeers(List<AKeyPair> keyPairs, State genesisState, int[] peerPorts) {
        Server server;
        int count = keyPairs.size();
        ArrayList<Server> serverList = new ArrayList<Server>();
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
        config.put(Keywords.PORT, null);
        config.put(Keywords.STATE, genesisState);
        config.put(Keywords.AUTO_MANAGE, true);
        for (int i = 0; i < count; ++i) {
            AKeyPair keyPair = keyPairs.get(i);
            config.put(Keywords.KEYPAIR, keyPair);
            if (peerPorts != null) {
                if (peerPorts.length > i) {
                    config.put(Keywords.PORT, peerPorts[i]);
                } else {
                    config.put(Keywords.PORT, 0);
                }
            }
            server = API.launchPeer(config);
            serverList.add(server);
        }
        Server genesisServer = (Server)serverList.get(0);
        genesisServer.setHostname("localhost:" + genesisServer.getPort());
        for (int i = 1; i < count; ++i) {
            server = (Server)serverList.get(i);
            ConnectionManager cm = server.getConnectionManager();
            cm.connectToPeer(genesisServer.getHostAddress());
            genesisServer.getConnectionManager().connectToPeer(server.getHostAddress());
            server.setHostname("localhost:" + server.getPort());
        }
        return serverList;
    }

    public static boolean isNetworkReady(List<Server> serverList, long timeoutMillis) {
        boolean isReady = false;
        long timeoutTime = Utils.getTimeMillis() + timeoutMillis;
        while (timeoutTime > Utils.getTimeMillis()) {
            isReady = true;
            Hash consensusHash = null;
            for (Server server : serverList) {
                Peer peer = server.getPeer();
                if (consensusHash == null) {
                    consensusHash = peer.getConsensusState().getHash();
                }
                if (consensusHash.equals(peer.getConsensusState().getHash())) continue;
                isReady = false;
            }
            if (isReady) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return isReady;
    }
}

