/*
 * Decompiled with CFR 0.152.
 */
package convex.net.message;

import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.prim.CVMLong;
import convex.net.Connection;
import convex.net.MessageType;
import convex.net.message.Message;
import java.io.IOException;

public class MessageRemote
extends Message {
    private final Connection connection;

    protected MessageRemote(Connection conn, MessageType type, ACell payload, Blob data) {
        super(type, payload, data);
        this.connection = conn;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public MessageRemote withConnection(Connection peerConnection) {
        return new MessageRemote(peerConnection, this.type, this.payload, this.messageData);
    }

    @Override
    public boolean reportResult(Result res) {
        Connection pc;
        CVMLong id = this.getID();
        if (id != null) {
            res = res.withID((ACell)id);
        }
        if ((pc = this.getConnection()) == null || pc.isClosed()) {
            return false;
        }
        try {
            Message msg = Message.createResult(res);
            return pc.sendMessage(msg);
        }
        catch (IOException t) {
            log.warn("Error reporting result: {}", (Object)t.getMessage());
            return false;
        }
    }

    public boolean reportResult(CVMLong id, ACell reply) {
        Connection pc = this.getConnection();
        if (pc == null || pc.isClosed()) {
            return false;
        }
        try {
            Message msg = Message.createResult(id, reply, null);
            return pc.sendMessage(msg);
        }
        catch (IOException t) {
            log.debug("Error reporting result: {}", (Object)t.getMessage());
            return false;
        }
    }

    @Override
    public String getOriginString() {
        Connection pc = this.getConnection();
        if (pc == null) {
            return "Disconnected message";
        }
        return pc.getRemoteAddress().toString();
    }

    @Override
    public boolean sendData(ACell data) {
        Connection pc = this.getConnection();
        if (pc == null) {
            return false;
        }
        try {
            Blob enc = Format.encodedBlob((ACell)data);
            return pc.sendData(enc);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean sendMissingData(Hash hash) {
        Connection pc = this.getConnection();
        if (pc == null) {
            return false;
        }
        try {
            pc.sendMissingData(hash);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public void closeConnection() {
        Connection pc = this.getConnection();
        if (pc != null) {
            pc.close();
        }
    }
}

