/*
 * Decompiled with CFR 0.152.
 */
package convex.net.message;

import convex.core.Belief;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;
import convex.core.util.Utils;
import convex.net.Connection;
import convex.net.MessageType;
import convex.net.message.MessageRemote;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message {
    protected static final Logger log = LoggerFactory.getLogger((String)Message.class.getName());
    protected ACell payload;
    protected Blob messageData;
    protected MessageType type;

    protected Message(MessageType type, ACell payload, Blob data) {
        this.type = type;
        this.messageData = data;
        this.payload = payload;
    }

    public static MessageRemote create(Connection peerConnection, MessageType type, ACell payload, Blob data) {
        return new MessageRemote(peerConnection, type, payload, data);
    }

    public static Message createData(ACell o) {
        return Message.create(null, MessageType.DATA, o, null);
    }

    public static Message createMissingData(Hash missingHash) {
        return Message.create(null, MessageType.DATA, (ACell)missingHash, null);
    }

    public static Message createMissingData(CVMLong id, Hash ... missingHashes) {
        int n = 32;
        if (n == 1) {
            return Message.create(null, MessageType.DATA, (ACell)missingHashes[0], null);
        }
        ACell[] cs = new ACell[n + 1];
        cs[0] = id;
        for (int i = 0; i < n; ++i) {
            cs[i + 1] = missingHashes[i];
        }
        return Message.create(null, MessageType.DATA, (ACell)Vectors.create((ACell[])cs), null);
    }

    public static Message createBelief(Belief belief) {
        return Message.create(null, MessageType.BELIEF, (ACell)belief, null);
    }

    public static Message createBelief(Belief belief, List<ACell> novelty) {
        int n = novelty.size();
        if (n == 0) {
            novelty.add(n, (ACell)belief);
        } else if (!(novelty.get(n - 1) instanceof Belief)) {
            novelty.add(n, (ACell)belief);
        }
        Blob data = Format.encodeDelta(novelty);
        return Message.create(null, MessageType.BELIEF, (ACell)belief, data);
    }

    public static Message createBeliefRequest() {
        return Message.create(null, MessageType.REQUEST_BELIEF, null, null);
    }

    public static Message createChallenge(SignedData<ACell> challenge) {
        return Message.create(null, MessageType.CHALLENGE, challenge, null);
    }

    public static Message createResponse(SignedData<ACell> response) {
        return Message.create(null, MessageType.RESPONSE, response, null);
    }

    public static Message createGoodBye() {
        return Message.create(null, MessageType.GOODBYE, null, Blob.NULL_ENCODING);
    }

    public <T extends ACell> T getPayload() {
        if (this.payload == null) {
            if (this.messageData == null) {
                throw new IllegalStateException("Null payload and data in Message?!? Type = " + this.type);
            }
            if (this.messageData.count() == 1L && this.messageData.byteAt(0L) == 0) {
                return null;
            }
            try {
                this.payload = Format.decodeMultiCell((Blob)this.messageData);
            }
            catch (BadFormatException e) {
                log.warn("Bad format in Message payload", (Throwable)e);
                throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
            }
        }
        return (T)this.payload;
    }

    public Blob getMessageData() {
        if (this.messageData == null) {
            this.messageData = Format.encodedBlob((ACell)this.payload);
        }
        return this.messageData;
    }

    public MessageType getType() {
        return this.type;
    }

    public String toString() {
        return "#message {:type " + this.getType() + " :payload " + RT.print(this.getPayload(), (long)1000L) + "}";
    }

    public CVMLong getID() {
        switch (this.type) {
            case QUERY: 
            case TRANSACT: {
                return (CVMLong)((AVector)this.getPayload()).get(0);
            }
            case RESULT: {
                return (CVMLong)((Result)this.getPayload()).getID();
            }
            case STATUS: {
                return (CVMLong)this.getPayload();
            }
        }
        return null;
    }

    public abstract boolean reportResult(Result var1);

    public abstract String getOriginString();

    public abstract boolean sendData(ACell var1);

    public abstract boolean sendMissingData(Hash var1);

    public abstract Connection getConnection();

    public boolean hasData() {
        return this.messageData != null;
    }

    public static Message createResult(Result res) {
        Blob enc = Format.encodeMultiCell((ACell)res);
        return Message.create(null, MessageType.RESULT, (ACell)res, enc);
    }

    public static Message createResult(CVMLong id, ACell value, ACell error) {
        Result r = Result.create((CVMLong)id, (ACell)value, (ACell)error);
        return Message.createResult(r);
    }

    public abstract void closeConnection();
}

