/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.core.util.Counters;
import convex.core.util.Utils;
import convex.net.MessageReceiver;
import convex.net.MessageSender;
import convex.net.MessageType;
import convex.net.message.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    final ByteChannel channel;
    private long idCounter = 0L;
    private long lastActivity;
    private final AStore store;
    private AccountKey trustedPeerKey;
    private static final Logger log = LoggerFactory.getLogger((String)Connection.class.getName());
    private final MessageReceiver receiver;
    private final MessageSender sender;
    private static Selector selector;
    private static Thread selectorThread;
    private static Runnable selectorLoop;

    private Connection(ByteChannel clientChannel, Consumer<Message> receiveAction, AStore store, AccountKey trustedPeerKey) {
        this.channel = clientChannel;
        this.receiver = new MessageReceiver(receiveAction, this);
        this.sender = new MessageSender(clientChannel);
        this.store = store;
        this.lastActivity = Utils.getCurrentTimestamp();
        this.trustedPeerKey = trustedPeerKey;
    }

    public static Connection create(ByteChannel channel, Consumer<Message> receiveAction, AStore store, AccountKey trustedPeerKey) throws IOException {
        Connection.ensureSelectorLoop();
        return new Connection(channel, receiveAction, store, trustedPeerKey);
    }

    public static Connection connect(InetSocketAddress hostAddress, Consumer<Message> receiveAction, AStore store) throws IOException, TimeoutException {
        return Connection.connect(hostAddress, receiveAction, store, null);
    }

    public static Connection connect(InetSocketAddress hostAddress, Consumer<Message> receiveAction, AStore store, AccountKey trustedPeerKey) throws IOException, TimeoutException {
        return Connection.connect(hostAddress, receiveAction, store, trustedPeerKey, 131072, 65536);
    }

    public static Connection connect(InetSocketAddress hostAddress, Consumer<Message> receiveAction, AStore store, AccountKey trustedPeerKey, int sendBufferSize, int receiveBufferSize) throws IOException, TimeoutException {
        Connection.ensureSelectorLoop();
        if (store == null) {
            throw new Error("Connection requires a store");
        }
        SocketChannel clientChannel = SocketChannel.open();
        clientChannel.configureBlocking(false);
        clientChannel.socket().setReceiveBufferSize(receiveBufferSize);
        clientChannel.socket().setSendBufferSize(sendBufferSize);
        clientChannel.socket().setTcpNoDelay(true);
        clientChannel.connect(hostAddress);
        long start = Utils.getCurrentTimestamp();
        while (!clientChannel.finishConnect()) {
            long now = Utils.getCurrentTimestamp();
            long elapsed = now - start;
            if (elapsed > 10000L) {
                throw new TimeoutException("Couldn't connect after " + elapsed + "ms");
            }
            try {
                Thread.sleep(10L + elapsed / 5L);
            }
            catch (InterruptedException e) {
                throw new IOException("Connect interrupted", e);
            }
        }
        Connection pc = Connection.create(clientChannel, receiveAction, store, trustedPeerKey);
        pc.startClientListening();
        log.debug("Connect succeeded for host: {}", (Object)hostAddress);
        return pc;
    }

    public long getReceivedCount() {
        return this.receiver.getReceivedCount();
    }

    public void setReceiveHook(Consumer<Message> hook) {
        this.receiver.setHook(hook);
    }

    public InetSocketAddress getRemoteAddress() {
        if (!(this.channel instanceof SocketChannel)) {
            return null;
        }
        try {
            return (InetSocketAddress)((SocketChannel)this.channel).getRemoteAddress();
        }
        catch (Exception e) {
            return null;
        }
    }

    public AStore getStore() {
        return this.store;
    }

    public InetSocketAddress getLocalAddress() {
        if (!(this.channel instanceof SocketChannel)) {
            return null;
        }
        try {
            return (InetSocketAddress)((SocketChannel)this.channel).getLocalAddress();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean sendData(Blob data) throws IOException {
        log.trace("Sending data: {}", (Object)data);
        return this.sendBuffer(MessageType.DATA, data);
    }

    public boolean sendMissingData(Hash hash) throws IOException {
        log.trace("Requested missing data for hash {} with store {}", (Object)hash.toHexString(), (Object)Stores.current());
        return this.sendObject(MessageType.MISSING_DATA, (ACell)hash);
    }

    public long sendQuery(ACell form) throws IOException {
        return this.sendQuery(form, null);
    }

    public long sendQuery(ACell form, Address address) throws IOException {
        AStore temp = Stores.current();
        long id = ++this.idCounter;
        AVector v = Vectors.of((Object[])new Object[]{id, form, address});
        boolean sent = this.sendObject(MessageType.QUERY, (ACell)v);
        return sent ? id : -1L;
    }

    public long sendStatusRequest() throws IOException {
        long id;
        CVMLong idPayload;
        boolean sent;
        AStore temp = Stores.current();
        return (sent = this.sendObject(MessageType.STATUS, (ACell)(idPayload = CVMLong.create((long)(id = ++this.idCounter))))) ? id : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendChallenge(SignedData<ACell> challenge) throws IOException {
        AStore temp = Stores.current();
        try {
            long id = ++this.idCounter;
            boolean sent = this.sendObject(MessageType.CHALLENGE, (ACell)challenge);
            long l = sent ? id : -1L;
            return l;
        }
        finally {
            Stores.setCurrent((AStore)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendResponse(SignedData<ACell> response) throws IOException {
        AStore temp = Stores.current();
        try {
            long id = ++this.idCounter;
            boolean sent = this.sendObject(MessageType.RESPONSE, (ACell)response);
            long l = sent ? id : -1L;
            return l;
        }
        finally {
            Stores.setCurrent((AStore)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendTransaction(SignedData<ATransaction> signed) throws IOException {
        AStore temp = Stores.current();
        try {
            Stores.setCurrent((AStore)this.store);
            long id = ++this.idCounter;
            AVector v = Vectors.of((Object[])new Object[]{id, signed});
            boolean sent = this.sendObject(MessageType.TRANSACT, (ACell)v);
            long l = sent ? id : -1L;
            return l;
        }
        finally {
            Stores.setCurrent((AStore)temp);
        }
    }

    public boolean sendMessage(Message msg) throws IOException {
        if (msg.hasData()) {
            return this.sendBuffer(msg.getType(), msg.getMessageData());
        }
        return this.sendObject(msg.getType(), (ACell)msg.getPayload());
    }

    public boolean sendObject(MessageType type, ACell payload) throws IOException {
        ++Counters.sendCount;
        Blob enc = Format.encodeMultiCell((ACell)payload);
        if (log.isTraceEnabled()) {
            log.trace("Sending message: " + type + " :: " + payload + " to " + this.getRemoteAddress() + " format: " + Format.encodedBlob((ACell)payload).toHexString());
        }
        boolean sent = this.sendBuffer(type, enc);
        return sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBuffer(MessageType type, Blob data) throws IOException {
        MessageSender messageSender = this.sender;
        synchronized (messageSender) {
            if (!this.sender.canSendMessage()) {
                return false;
            }
            int dataLength = Utils.checkedInt((long)data.count());
            int messageLength = dataLength + 1;
            ByteBuffer frameBuf = ByteBuffer.allocate(messageLength + 10);
            Format.writeMessageLength((ByteBuffer)frameBuf, (int)messageLength);
            frameBuf.put(type.getMessageCode());
            int headerLength = frameBuf.position();
            frameBuf.put(headerLength, data.getInternalArray(), data.getInternalOffset(), dataLength);
            frameBuf.position(headerLength + dataLength);
            frameBuf.flip();
            boolean sent = this.sender.bufferMessage(frameBuf);
            if (sent) {
                this.lastActivity = System.currentTimeMillis();
                if (this.channel instanceof SocketChannel) {
                    SocketChannel chan = (SocketChannel)this.channel;
                    try {
                        chan.register(selector, 5, this);
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        // empty catch block
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace("Sent message " + type + " of length: " + dataLength + " Connection ID: " + System.identityHashCode(this));
                }
            } else {
                log.warn("sendBuffer failed with message {} of length: {} Connection ID: {}", new Object[]{type, dataLength, System.identityHashCode(this)});
            }
            return sent;
        }
    }

    public synchronized void close() {
        SocketChannel chan = (SocketChannel)this.channel;
        if (chan != null) {
            try {
                chan.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void finalize() {
        this.close();
    }

    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    private void startClientListening() throws IOException {
        SocketChannel chan = (SocketChannel)this.channel;
        chan.register(selector, 5, this);
        selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureSelectorLoop() {
        if (selectorThread != null) return;
        Class<Connection> clazz = Connection.class;
        synchronized (Connection.class) {
            if (selectorThread != null) return;
            try {
                selector = Selector.open();
            }
            catch (IOException e) {
                throw new Error("Error initialising client selector", e);
            }
            selectorThread = new Thread(selectorLoop, "Connection NIO client selector loop");
            selectorThread.setDaemon(true);
            selectorThread.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected static void selectRead(SelectionKey key) throws IOException {
        Connection conn = (Connection)key.attachment();
        if (conn == null) {
            throw new Error("No PeerConnection specified");
        }
        try {
            int n = conn.handleChannelRecieve();
            if (n < 0) {
                log.debug("Cancelled Key due to EOS");
                key.cancel();
            }
        }
        catch (ClosedChannelException e) {
            log.debug("Channel closed from: {}", (Object)conn.getRemoteAddress());
            key.cancel();
        }
        catch (BadFormatException e) {
            log.warn("Cancelled connection to Peer: Bad data format from: " + conn.getRemoteAddress() + " " + e.getMessage());
            key.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handleChannelRecieve() throws IOException, BadFormatException {
        AStore tempStore = Stores.current();
        try {
            int recd;
            Stores.setCurrent((AStore)this.store);
            int total = recd = this.receiver.receiveFromChannel(this.channel);
            while (recd > 0) {
                recd = this.receiver.receiveFromChannel(this.channel);
                total += recd;
            }
            if (recd > 0) {
                this.lastActivity = System.currentTimeMillis();
            }
            int n = total;
            return n;
        }
        finally {
            Stores.setCurrent((AStore)tempStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void selectWrite(SelectionKey key) throws IOException {
        Connection pc = (Connection)key.attachment();
        MessageSender messageSender = pc.sender;
        synchronized (messageSender) {
            boolean allSent = pc.sender.maybeSendBytes();
            if (allSent) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
            }
        }
    }

    public boolean flushBytes() throws IOException {
        return this.sender.maybeSendBytes();
    }

    public String toString() {
        return "PeerConnection: " + this.channel;
    }

    public AccountKey getTrustedPeerKey() {
        return this.trustedPeerKey;
    }

    public void setTrustedPeerKey(AccountKey value) {
        this.trustedPeerKey = value;
    }

    public boolean isTrusted() {
        return this.trustedPeerKey != null;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    static {
        selectorLoop = new Runnable(){

            @Override
            public void run() {
                log.debug("Client selector loop starting...");
                while (true) {
                    try {
                        block7: while (true) {
                            selector.select(300L);
                            Set<SelectionKey> keys = selector.selectedKeys();
                            Iterator<SelectionKey> it = keys.iterator();
                            while (true) {
                                if (!it.hasNext()) continue block7;
                                SelectionKey key = it.next();
                                it.remove();
                                if (!key.isValid()) continue;
                                try {
                                    if (key.isReadable()) {
                                        Connection.selectRead(key);
                                        continue;
                                    }
                                    if (!key.isWritable()) continue;
                                    Connection.selectWrite(key);
                                }
                                catch (ClosedChannelException e) {
                                    log.trace("Unexpected ChannelClosedException, cancelling key: {}", (Throwable)e);
                                    key.cancel();
                                }
                                catch (IOException e) {
                                    log.trace("Unexpected IOException, cancelling key: {}", (Throwable)e);
                                    key.cancel();
                                }
                                catch (CancelledKeyException e) {
                                    log.debug("Cancelled key");
                                }
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        log.warn("Uncaught error in PeerConnection client selector loop: ", t);
                        continue;
                    }
                    break;
                }
            }
        };
    }
}

