/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.MissingDataException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.lang.Symbols;
import convex.core.lang.ops.Special;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.transactions.Transfer;
import convex.core.util.Utils;
import convex.net.Connection;
import convex.net.Message;
import convex.net.ResultConsumer;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Convex {
    private static final Logger log = LoggerFactory.getLogger((String)Convex.class.getName());
    private long timeout = 6000L;
    protected AKeyPair keyPair;
    protected Address address;
    protected Connection connection;
    private boolean autoSequence = true;
    protected Long sequence = null;
    private HashMap<Long, CompletableFuture<Result>> awaiting = new HashMap();
    private final Consumer<Message> internalHandler = new ResultConsumer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized void handleResult(long id, Result v) {
            if (v != null && ErrorCodes.SEQUENCE.equals(v.getErrorCode())) {
                Convex.this.sequence = null;
            }
            HashMap<Long, CompletableFuture<Result>> hashMap = Convex.this.awaiting;
            synchronized (hashMap) {
                CompletableFuture<Result> cf = Convex.this.awaiting.get(id);
                if (cf != null) {
                    Convex.this.awaiting.remove(id);
                    cf.complete(v);
                    log.debug("Completed Result received for message ID: {}", (Object)id);
                } else {
                    log.warn("Ignored Result received for unexpected message ID: {}", (Object)id);
                }
            }
        }

        @Override
        public void accept(Message m) {
            super.accept(m);
            if (Convex.this.delegatedHandler != null) {
                try {
                    Convex.this.delegatedHandler.accept(m);
                }
                catch (Throwable t) {
                    log.warn("Exception thrown in user-supplied handler function: {}", t);
                }
            }
        }
    };
    private Consumer<Message> delegatedHandler = null;

    private Convex(Address address, AKeyPair keyPair) {
        this.keyPair = keyPair;
        this.address = address;
    }

    public static Convex connect(InetSocketAddress hostAddress) throws IOException, TimeoutException {
        return Convex.connect(hostAddress, null, null);
    }

    public static Convex connect(InetSocketAddress peerAddress, Address address, AKeyPair keyPair) throws IOException, TimeoutException {
        return Convex.connect(peerAddress, address, keyPair, Stores.current());
    }

    public static Convex connect(InetSocketAddress peerAddress, Address address, AKeyPair keyPair, AStore store) throws IOException, TimeoutException {
        Convex convex = new Convex(address, keyPair);
        convex.connectToPeer(peerAddress, store);
        return convex;
    }

    public synchronized void setAddress(Address address) {
        if (this.address == address) {
            return;
        }
        this.address = address;
        this.sequence = null;
    }

    public synchronized void setAddress(Address addr, AKeyPair kp) {
        this.setAddress(addr);
        this.setKeyPair(kp);
    }

    public synchronized void setKeyPair(AKeyPair kp) {
        this.keyPair = kp;
    }

    private long getIncrementedSequence() {
        long next = this.getSequence() + 1L;
        this.sequence = next;
        return next;
    }

    public void setNextSequence(long nextSequence) {
        this.sequence = nextSequence - 1L;
    }

    public void setHandler(Consumer<Message> handler) {
        this.delegatedHandler = handler;
    }

    public long getSequence() {
        if (this.sequence == null) {
            try {
                Future<Result> f = this.query((ACell)Special.forSymbol((Symbol)Symbols.STAR_SEQUENCE));
                Result r = f.get();
                if (r.isError()) {
                    throw new Error("Error querying *sequence*: " + r.getErrorCode() + " " + r.getValue());
                }
                ACell result = r.getValue();
                if (!(result instanceof CVMLong)) {
                    throw new Error("*sequence* query did not return Long, got: " + result);
                }
                this.sequence = (Long)RT.jvm((ACell)result);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new Error("Error trying to get sequence number", e);
            }
        }
        return this.sequence;
    }

    private void connectToPeer(InetSocketAddress peerAddress, AStore store) throws IOException, TimeoutException {
        this.setConnection(Connection.connect(peerAddress, this.internalHandler, store));
    }

    public <T extends ACell> SignedData<T> signData(T value) {
        return this.keyPair.signData(value);
    }

    public InetSocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public Address createAccountSync(AccountKey publicKey) throws TimeoutException, IOException {
        Invoke trans = Invoke.create((Address)this.address, (long)0L, (String)("(create-account 0x" + publicKey.toHexString() + ")"));
        Result r = this.transactSync((ATransaction)trans);
        if (r.isError()) {
            throw new Error("Error creating account: " + r.getErrorCode() + " " + r.getValue());
        }
        return (Address)r.getValue();
    }

    public CompletableFuture<Address> createAccount(AccountKey publicKey) throws TimeoutException, IOException {
        Invoke trans = Invoke.create((Address)this.address, (long)0L, (String)("(create-account 0x" + publicKey.toHexString() + ")"));
        CompletableFuture<Result> fr = this.transact((ATransaction)trans);
        return fr.thenApply(r -> (Address)r.getValue());
    }

    public boolean isConnected() {
        Connection c = this.connection;
        return c != null && !c.isClosed();
    }

    public Connection getConnection() {
        return this.connection;
    }

    private synchronized ATransaction applyNextSequence(ATransaction t) {
        if (this.sequence != null) {
            this.sequence = this.sequence + 1L;
            return t.withSequence(this.sequence.longValue());
        }
        return t.withSequence(this.getIncrementedSequence());
    }

    public synchronized CompletableFuture<Result> transact(ATransaction transaction) throws IOException {
        if (transaction.getAddress() == null) {
            transaction = transaction.withAddress(this.address);
        }
        if ((this.autoSequence || transaction.getSequence() <= 0L) && Utils.equals((ACell)transaction.getAddress(), (ACell)this.address)) {
            transaction = this.applyNextSequence(transaction);
        }
        SignedData signed = this.keyPair.signData((ACell)transaction);
        return this.transact((SignedData<ATransaction>)signed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<Result> transact(SignedData<ATransaction> signed) throws IOException {
        CompletableFuture<Result> cf;
        long id = -1L;
        HashMap<Long, CompletableFuture<Result>> hashMap = this.awaiting;
        synchronized (hashMap) {
            while (id < 0L) {
                id = this.connection.sendTransaction(signed);
                if (id >= 0L) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            cf = this.awaitResult(id);
        }
        log.debug("Sent transaction with message ID: {} awaiting count = {}", (Object)id, (Object)this.awaiting.size());
        return cf;
    }

    public CompletableFuture<Result> transfer(Address target, long amount) throws IOException {
        Transfer trans = Transfer.create((Address)this.getAddress(), (long)0L, (Address)target, (long)amount);
        return this.transact((ATransaction)trans);
    }

    public Result transferSync(Address target, long amount) throws IOException, TimeoutException {
        Transfer trans = Transfer.create((Address)this.getAddress(), (long)0L, (Address)target, (long)amount);
        return this.transactSync((ATransaction)trans);
    }

    public Result transactSync(SignedData<ATransaction> transaction) throws TimeoutException, IOException {
        return this.transactSync(transaction, this.timeout);
    }

    public Result transactSync(ATransaction transaction) throws TimeoutException, IOException {
        return this.transactSync(transaction, this.timeout);
    }

    public Result transactSync(ATransaction transaction, long timeout) throws TimeoutException, IOException {
        Result result;
        long start = Utils.getTimeMillis();
        CompletableFuture<Result> cf = this.transact(transaction);
        long now = Utils.getTimeMillis();
        timeout = Math.max(0L, timeout - (now - start));
        try {
            result = (Result)cf.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error("Not possible? Since there is no Thread for the future....", e);
        }
        return result;
    }

    public Result transactSync(SignedData<ATransaction> transaction, long timeout) throws TimeoutException, IOException {
        Result result;
        long start = Utils.getTimeMillis();
        CompletableFuture<Result> cf = this.transact(transaction);
        long now = Utils.getTimeMillis();
        timeout = Math.max(0L, timeout - (now - start));
        try {
            result = (Result)cf.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error("Not possible? Since there is no Thread for the future....", e);
        }
        return result;
    }

    public Future<Result> query(ACell query) throws IOException {
        return this.query(query, this.getAddress());
    }

    public <T extends ACell> Future<T> acquire(Hash hash) {
        return this.acquire(hash, Stores.current());
    }

    public <T extends ACell> Future<T> acquire(final Hash hash, final AStore store) {
        final CompletableFuture f = new CompletableFuture();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Stores.setCurrent((AStore)store);
                try {
                    Ref ref = store.refForHash(hash);
                    HashSet<Hash> missingSet = new HashSet<Hash>();
                    while (!f.isDone()) {
                        missingSet.clear();
                        if (ref == null) {
                            missingSet.add(hash);
                        } else {
                            if (ref.getStatus() >= 2) {
                                f.complete(ref.getValue());
                                return;
                            }
                            ref.findMissing(missingSet);
                        }
                        for (Hash h : missingSet) {
                            log.debug("Request missing data: {}", (Object)h);
                            boolean sent = Convex.this.connection.sendMissingData(h);
                            if (sent) continue;
                            log.debug("Send Queue full!");
                            break;
                        }
                        Thread.sleep(100L);
                        ref = store.refForHash(hash);
                        if (ref == null) continue;
                        if (ref.getStatus() >= 2) {
                            f.complete(ref.getValue());
                            return;
                        }
                        try {
                            ref = ref.persist();
                            f.complete(ref.getValue());
                        }
                        catch (MissingDataException e) {
                            Hash missing = e.getMissingHash();
                            log.debug("Still missing: {}", (Object)missing);
                            Convex.this.connection.sendMissingData(missing);
                        }
                    }
                }
                catch (Throwable t) {
                    f.completeExceptionally(t);
                }
            }
        }).start();
        return f;
    }

    public Result requestStatusSync(long timeoutMillis) throws IOException, TimeoutException {
        Future<Result> statusFuture = this.requestStatus();
        try {
            return statusFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error("Unable to get network status ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Result> requestStatus() throws IOException {
        HashMap<Long, CompletableFuture<Result>> hashMap = this.awaiting;
        synchronized (hashMap) {
            long id = this.connection.sendStatusRequest();
            if (id < 0L) {
                throw new IOException("Failed to send status request due to full buffer");
            }
            CompletableFuture<Result> cf = this.awaitResult(id);
            return cf;
        }
    }

    protected CompletableFuture<Result> awaitResult(long id) {
        CompletableFuture<Result> cf = new CompletableFuture<Result>();
        this.awaiting.put(id, cf);
        return cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Result> requestChallenge(SignedData<ACell> data) throws IOException {
        HashMap<Long, CompletableFuture<Result>> hashMap = this.awaiting;
        synchronized (hashMap) {
            long id = this.connection.sendChallenge(data);
            if (id < 0L) {
                throw new IOException("Failed to send challenge due to full buffer");
            }
            return this.awaitResult(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Result> query(ACell query, Address address) throws IOException {
        HashMap<Long, CompletableFuture<Result>> hashMap = this.awaiting;
        synchronized (hashMap) {
            long id = this.connection.sendQuery(query, address);
            if (id < 0L) {
                throw new IOException("Failed to send query due to full buffer");
            }
            return this.awaitResult(id);
        }
    }

    public Result querySync(ACell query) throws TimeoutException, IOException {
        return this.querySync(query, this.getAddress());
    }

    public Result querySync(ACell query, long timeoutMillis) throws IOException, TimeoutException {
        return this.querySync(query, this.getAddress(), timeoutMillis);
    }

    public Result querySync(ACell query, Address address) throws IOException, TimeoutException {
        return this.querySync(query, address, this.timeout);
    }

    public Result querySync(ACell query, Address address, long timeoutMillis) throws TimeoutException, IOException {
        Result result;
        Future<Result> cf = this.query(query, address);
        try {
            result = cf.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new Error("Not possible? Since there is no Thread for the future....", e);
        }
        return result;
    }

    public AccountKey getAccountKey() {
        return this.keyPair.getAccountKey();
    }

    public Address getAddress() {
        return this.address;
    }

    private void setConnection(Connection conn) {
        if (this.connection == conn) {
            return;
        }
        this.close();
        this.connection = conn;
    }

    public synchronized void close() {
        Connection c = this.connection;
        if (c != null) {
            c.close();
        }
        this.connection = null;
        this.awaiting.clear();
    }

    public void finalize() {
        this.close();
    }

    protected boolean isAutoSequence() {
        return this.autoSequence;
    }

    protected void setAutoSequence(boolean autoSequence) {
        this.autoSequence = autoSequence;
    }

    public Long getBalance(Address address) throws IOException {
        try {
            Future<Result> future = this.query(Reader.read((String)("(balance " + address.toString() + ")")));
            Result result = future.get(this.timeout, TimeUnit.MILLISECONDS);
            if (result.isError()) {
                throw new Error(result.toString());
            }
            CVMLong bal = (CVMLong)result.getValue();
            return bal.longValue();
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new IOException("Unable to query balance", ex);
        }
    }

    public static Convex connect(Server server) throws IOException, TimeoutException {
        return Convex.connect(server.getHostAddress(), server.getPeerController(), server.getKeyPair());
    }

    public static Convex wrap(Connection c) {
        Convex convex = new Convex(null, null);
        convex.setConnection(c);
        return convex;
    }

    public Future<State> acquireState() throws TimeoutException {
        try {
            Future<Result> sF = this.requestStatus();
            AVector status = (AVector)sF.get(this.timeout, TimeUnit.MILLISECONDS).getValue();
            Hash stateHash = RT.ensureHash((ACell)status.get(4));
            if (stateHash == null) {
                throw new Error("Bad status response from Peer");
            }
            return this.acquire(stateHash);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    public void closeButMaintainConnection() {
        this.connection = null;
        this.close();
    }
}

