/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.exceptions.MissingDataException;
import convex.core.store.Stores;
import convex.core.util.Utils;
import convex.net.Message;
import convex.net.MessageType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultConsumer
implements Consumer<Message> {
    private static final Logger log = LoggerFactory.getLogger((String)ResultConsumer.class.getName());
    private HashMap<Hash, ArrayList<Message>> bufferedMessages = new HashMap();

    @Override
    public void accept(Message m) {
        try {
            MessageType type = m.getType();
            switch (type) {
                case DATA: {
                    this.handleDataProvided(m);
                    break;
                }
                case MISSING_DATA: {
                    this.handleMissingDataRequest(m);
                    break;
                }
                case RESULT: {
                    this.handleResultMessage(m);
                    break;
                }
                default: {
                    log.error("Message type ignored: ", (Object)type);
                    break;
                }
            }
        }
        catch (Throwable t) {
            log.warn("Failed to accept message! {}", t);
            t.printStackTrace();
        }
    }

    private void handleDataProvided(Message m) {
        try {
            Object o = m.getPayload();
            Ref r = Ref.get(o);
            r.persistShallow();
            Hash h = r.getHash();
            log.trace("Recieved DATA for hash {}", (Object)h);
            this.unbuffer(h);
        }
        catch (MissingDataException missingDataException) {
            // empty catch block
        }
    }

    private void handleMissingDataRequest(Message m) {
        Hash h = (Hash)m.getPayload();
        Ref r = Stores.current().refForHash(h);
        if (r != null) {
            try {
                m.getConnection().sendData(r.getValue());
            }
            catch (IOException e) {
                log.debug("Error replying to MISSING DATA request", (Throwable)e);
            }
        }
    }

    private synchronized void buffer(Hash hash, Message m) {
        ArrayList<Message> msgs = this.bufferedMessages.get(hash);
        if (msgs == null) {
            msgs = new ArrayList();
            this.bufferedMessages.put(hash, msgs);
        }
        msgs.add(m);
    }

    protected synchronized void unbuffer(Hash hash) {
        ArrayList<Message> msgs = this.bufferedMessages.get(hash);
        if (msgs != null) {
            this.bufferedMessages.remove(hash);
            for (Message m : msgs) {
                this.accept(m);
            }
        }
    }

    protected void handleResult(long id, Object value) {
        this.handleResult(value);
    }

    protected void handleResult(Object value) {
        log.debug("RESULT RECEIVED: {}", value);
    }

    protected void handleResultMessage(Message m) {
        Result result = (Result)m.getPayload();
        try {
            ACell.createPersisted((ACell)result);
            ACell rv = result.getValue();
            long id = m.getID().longValue();
            ACell err = result.getErrorCode();
            if (err != null) {
                this.handleError(id, err, rv);
            } else {
                this.handleResult(id, rv);
            }
        }
        catch (MissingDataException e) {
            Hash hash = e.getMissingHash();
            try {
                if (m.getConnection().sendMissingData(hash)) {
                    log.debug("Missing data {} requested by client for RESULT of type: {}", (Object)hash.toHexString(), (Object)Utils.getClassName((Object)result));
                    this.buffer(hash, m);
                } else {
                    log.debug("Unable to request missing data");
                }
            }
            catch (IOException e1) {
                log.warn("IO Exception handling result - {}", (Throwable)e1);
            }
            return;
        }
    }

    protected void handleError(long id, Object code, Object errorMessage) {
        this.handleError(code, errorMessage);
    }

    protected void handleError(Object code, Object errorMessage) {
        log.debug("Error received: {} :  {}", code, errorMessage);
    }
}

