/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.core.util.Counters;
import convex.core.util.Utils;
import convex.net.Message;
import convex.net.MessageReceiver;
import convex.net.MessageSender;
import convex.net.MessageType;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    final ByteChannel channel;
    private static long idCounter = 0L;
    private final AStore store;
    private AccountKey trustedPeerKey;
    private static final Logger log = LoggerFactory.getLogger((String)Connection.class.getName());
    private final ByteBuffer frameBuf = ByteBuffer.allocateDirect(8211);
    private final MessageReceiver receiver;
    private final MessageSender sender;
    private final IRefFunction sendAll = r -> {
        ACell o = r.getValue();
        if (o == null) {
            return r;
        }
        o.updateRefs(this.sender());
        if (!o.isEmbedded()) {
            try {
                this.sendData(o);
            }
            catch (IOException e) {
                throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
            }
        }
        return r;
    };
    private static final Selector selector;
    private static Thread loopThread;
    private static Runnable selectorLoop;

    private Connection(ByteChannel clientChannel, Consumer<Message> receiveAction, AStore store, AccountKey trustedPeerKey) {
        this.channel = clientChannel;
        this.receiver = new MessageReceiver(receiveAction, this);
        this.sender = new MessageSender(clientChannel);
        this.store = store;
        this.trustedPeerKey = trustedPeerKey;
    }

    public static Connection create(ByteChannel channel, Consumer<Message> receiveAction, AStore store, AccountKey trustedPeerKey) throws IOException {
        return new Connection(channel, receiveAction, store, trustedPeerKey);
    }

    public static long getCounter() {
        return idCounter;
    }

    public static Connection connect(InetSocketAddress hostAddress, Consumer<Message> receiveAction, AStore store) throws IOException, TimeoutException {
        return Connection.connect(hostAddress, receiveAction, store, null);
    }

    public static Connection connect(InetSocketAddress hostAddress, Consumer<Message> receiveAction, AStore store, AccountKey trustedPeerKey) throws IOException, TimeoutException {
        return Connection.connect(hostAddress, receiveAction, store, trustedPeerKey, 65536, 65536);
    }

    public static Connection connect(InetSocketAddress hostAddress, Consumer<Message> receiveAction, AStore store, AccountKey trustedPeerKey, int sendBufferSize, int receiveBufferSize) throws IOException, TimeoutException {
        if (store == null) {
            throw new Error("Connection requires a store");
        }
        SocketChannel clientChannel = SocketChannel.open();
        clientChannel.configureBlocking(false);
        clientChannel.socket().setReceiveBufferSize(receiveBufferSize);
        clientChannel.socket().setSendBufferSize(sendBufferSize);
        clientChannel.socket().setTcpNoDelay(true);
        clientChannel.connect(hostAddress);
        long start = Utils.getCurrentTimestamp();
        while (!clientChannel.finishConnect()) {
            long now = Utils.getCurrentTimestamp();
            long elapsed = now - start;
            if (elapsed > 6000L) {
                throw new TimeoutException("Couldn't connect");
            }
            try {
                Thread.sleep(10L + elapsed / 5L);
            }
            catch (InterruptedException e) {
                throw new IOException("Connect interrupted", e);
            }
        }
        Connection pc = Connection.create(clientChannel, receiveAction, store, trustedPeerKey);
        pc.startClientListening();
        log.debug("Connect succeeded for host: {}", (Object)hostAddress);
        return pc;
    }

    public long getReceivedCount() {
        return this.receiver.getReceivedCount();
    }

    public InetSocketAddress getRemoteAddress() {
        if (!(this.channel instanceof SocketChannel)) {
            return null;
        }
        try {
            return (InetSocketAddress)((SocketChannel)this.channel).getRemoteAddress();
        }
        catch (Exception e) {
            return null;
        }
    }

    public AStore getStore() {
        return this.store;
    }

    public InetSocketAddress getLocalAddress() {
        if (!(this.channel instanceof SocketChannel)) {
            return null;
        }
        try {
            return (InetSocketAddress)((SocketChannel)this.channel).getLocalAddress();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean sendData(ACell value) throws IOException {
        log.trace("Sending data: {}", (Object)value);
        ByteBuffer buf = Format.encodedBuffer((ACell)value);
        return this.sendBuffer(MessageType.DATA, buf);
    }

    public boolean sendMissingData(Hash value) throws IOException {
        log.trace("Requested missing data for hash {} with store {}", (Object)value.toHexString(), (Object)Stores.current());
        return this.sendObject(MessageType.MISSING_DATA, (ACell)value);
    }

    public long sendQuery(ACell form) throws IOException {
        return this.sendQuery(form, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendQuery(ACell form, Address address) throws IOException {
        AStore temp = Stores.current();
        try {
            long id = ++idCounter;
            AVector v = Vectors.of((Object[])new Object[]{id, form, address});
            boolean sent = this.sendObject(MessageType.QUERY, (ACell)v);
            long l = sent ? id : -1L;
            return l;
        }
        finally {
            Stores.setCurrent((AStore)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendStatusRequest() throws IOException {
        AStore temp = Stores.current();
        try {
            long id = ++idCounter;
            CVMLong idPayload = CVMLong.create((long)id);
            this.sendObject(MessageType.STATUS, (ACell)idPayload);
            long l = id;
            return l;
        }
        finally {
            Stores.setCurrent((AStore)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendChallenge(SignedData<ACell> challenge) throws IOException {
        AStore temp = Stores.current();
        try {
            long id = ++idCounter;
            boolean sent = this.sendObject(MessageType.CHALLENGE, (ACell)challenge);
            long l = sent ? id : -1L;
            return l;
        }
        finally {
            Stores.setCurrent((AStore)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendResponse(SignedData<ACell> response) throws IOException {
        AStore temp = Stores.current();
        try {
            long id = ++idCounter;
            boolean sent = this.sendObject(MessageType.RESPONSE, (ACell)response);
            long l = sent ? id : -1L;
            return l;
        }
        finally {
            Stores.setCurrent((AStore)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendTransaction(SignedData<ATransaction> signed) throws IOException {
        AStore temp = Stores.current();
        try {
            Stores.setCurrent((AStore)this.store);
            long id = ++idCounter;
            AVector v = Vectors.of((Object[])new Object[]{id, signed});
            boolean sent = this.sendObject(MessageType.TRANSACT, (ACell)v);
            long l = sent ? id : -1L;
            return l;
        }
        finally {
            Stores.setCurrent((AStore)temp);
        }
    }

    public boolean sendResult(CVMLong id, ACell value) throws IOException {
        return this.sendResult(id, value, null);
    }

    public boolean sendResult(CVMLong id, ACell value, ACell errorCode) throws IOException {
        Result result = Result.create((CVMLong)id, (ACell)value, (ACell)errorCode);
        return this.sendObject(MessageType.RESULT, (ACell)result);
    }

    public boolean sendResult(Result result) throws IOException {
        return this.sendObject(MessageType.RESULT, (ACell)result);
    }

    private IRefFunction sender() {
        return this.sendAll;
    }

    public boolean sendMessage(Message msg) throws IOException {
        return this.sendObject(msg.getType(), (ACell)msg.getPayload());
    }

    public boolean sendObject(MessageType type, ACell payload) throws IOException {
        ++Counters.sendCount;
        ACell sendVal = payload;
        ACell.createPersisted((ACell)sendVal, r -> {
            try {
                ACell data = r.getValue();
                boolean bl = this.sendData(data);
            }
            catch (IOException e) {
                throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
            }
        });
        ByteBuffer buf = Format.encodedBuffer((ACell)sendVal);
        if (log.isTraceEnabled()) {
            log.trace("Sending message: " + type + " :: " + payload + " to " + this.getRemoteAddress() + " format: " + Format.encodedBlob((ACell)payload).toHexString());
        }
        boolean sent = this.sendBuffer(type, buf);
        return sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBuffer(MessageType type, ByteBuffer buf) throws IOException {
        boolean sent;
        int dataLength = buf.remaining();
        int messageLength = dataLength + 1;
        ByteBuffer byteBuffer = this.frameBuf;
        synchronized (byteBuffer) {
            this.frameBuf.clear();
            Format.writeMessageLength((ByteBuffer)this.frameBuf, (int)messageLength);
            this.frameBuf.put(type.getMessageCode());
            int headerLength = this.frameBuf.position();
            this.frameBuf.put(buf);
            this.frameBuf.flip();
            sent = this.sender.bufferMessage(this.frameBuf);
        }
        if (sent) {
            if (this.channel instanceof SocketChannel) {
                SocketChannel chan = (SocketChannel)this.channel;
                try {
                    chan.register(selector, 5, this);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
                selector.wakeup();
            }
            if (log.isTraceEnabled()) {
                log.trace("Sent message " + type + " of length: " + dataLength + " Connection ID: " + System.identityHashCode(this));
            }
        } else {
            log.debug("sendBuffer failed with message {} of length: {} Connection ID: {}", new Object[]{type, dataLength, System.identityHashCode(this)});
        }
        return sent;
    }

    public synchronized void close() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    private void startClientListening() throws IOException {
        SocketChannel chan = (SocketChannel)this.channel;
        chan.register(selector, 5, this);
        Connection.ensureSelectorLoop();
        selector.wakeup();
    }

    public void wakeUp() {
        selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureSelectorLoop() {
        if (loopThread != null) return;
        Class<Connection> clazz = Connection.class;
        synchronized (Connection.class) {
            if (loopThread != null) return;
            loopThread = new Thread(selectorLoop, "PeerConnection NIO client selector loop");
            loopThread.setDaemon(true);
            loopThread.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected static void selectRead(SelectionKey key) throws IOException {
        Connection conn = (Connection)key.attachment();
        if (conn == null) {
            throw new Error("No PeerConnection specified");
        }
        try {
            int n = conn.handleChannelRecieve();
        }
        catch (ClosedChannelException e) {
            log.debug("Channel closed from: {}", (Object)conn.getRemoteAddress());
            key.cancel();
        }
        catch (BadFormatException e) {
            log.warn("Cancelled connection to Peer: Bad data format from: " + conn.getRemoteAddress() + " " + e.getMessage());
            key.cancel();
        }
    }

    public int handleChannelRecieve() throws IOException, BadFormatException {
        AStore tempStore = Stores.current();
        try {
            Stores.setCurrent((AStore)this.store);
            int n = this.receiver.receiveFromChannel(this.channel);
            return n;
        }
        finally {
            Stores.setCurrent((AStore)tempStore);
        }
    }

    static void selectWrite(SelectionKey key) throws IOException {
        Connection pc = (Connection)key.attachment();
        boolean allSent = pc.sender.maybeSendBytes();
        if (allSent) {
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
        }
    }

    public boolean flushBytes() throws IOException {
        return this.sender.maybeSendBytes();
    }

    public String toString() {
        return "PeerConnection: " + this.channel;
    }

    public AccountKey getTrustedPeerKey() {
        return this.trustedPeerKey;
    }

    public void setTrustedPeerKey(AccountKey value) {
        this.trustedPeerKey = value;
    }

    public boolean isTrusted() {
        return this.trustedPeerKey != null;
    }

    static {
        try {
            selector = Selector.open();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        selectorLoop = new Runnable(){

            @Override
            public void run() {
                log.debug("Client selector loop started");
                while (true) {
                    try {
                        block7: while (true) {
                            selector.select(1000L);
                            Set<SelectionKey> keys = selector.selectedKeys();
                            Iterator<SelectionKey> it = keys.iterator();
                            while (true) {
                                if (!it.hasNext()) continue block7;
                                SelectionKey key = it.next();
                                it.remove();
                                if (!key.isValid()) continue;
                                try {
                                    if (key.isReadable()) {
                                        Connection.selectRead(key);
                                        continue;
                                    }
                                    if (!key.isWritable()) continue;
                                    Connection.selectWrite(key);
                                }
                                catch (ClosedChannelException e) {
                                    log.debug("Unexpected ChannelClosedException, cancelling key: {}", (Throwable)e);
                                    key.cancel();
                                }
                                catch (IOException e) {
                                    log.debug("Unexpected IOException, cancelling key: {}", (Throwable)e);
                                    key.cancel();
                                }
                                catch (CancelledKeyException e) {
                                    log.debug("Cancelled key");
                                }
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        log.error("Uncaught error in PeerConnection client selector loop: {}", t);
                        t.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
    }
}

