/*
 * Decompiled with CFR 0.152.
 */
package convex.observer;

import convex.core.store.AStore;
import convex.core.store.Stores;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AObserverQueue<T> {
    static final Logger log = LoggerFactory.getLogger((String)AObserverQueue.class.getName());
    private boolean running;
    private AStore store;
    private Thread thread;
    protected final ArrayBlockingQueue<Supplier<T>> queue;

    public AObserverQueue(AStore store) {
        this.store = store;
        this.queue = new ArrayBlockingQueue(this.getQueueSize());
    }

    protected int getQueueSize() {
        return 5000;
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        String name = this.getThreadName();
        this.thread = new Thread(new QueueTask());
        this.thread.setName(name);
        log.debug("Thread started: {}", (Object)name);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected String getThreadName() {
        return "Observability Task Queue";
    }

    public synchronized void close() {
        Thread t = this.thread;
        this.running = false;
        t.interrupt();
    }

    public abstract void loop() throws InterruptedException;

    private class QueueTask
    implements Runnable {
        private QueueTask() {
        }

        @Override
        public void run() {
            Stores.setCurrent((AStore)AObserverQueue.this.store);
            while (AObserverQueue.this.running) {
                try {
                    AObserverQueue.this.loop();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.debug("Component thread interrupted: {}", (Object)AObserverQueue.this.thread);
                    break;
                }
                catch (Exception e) {
                    log.warn("Unexpected exception in " + this.getClass().getSimpleName(), (Throwable)e);
                }
            }
            AObserverQueue.this.close();
        }
    }
}

