/*
 * Decompiled with CFR 0.152.
 */
package convex.java;

import convex.api.Convex;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.SourceCodes;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Maps;
import convex.core.data.SignedData;
import convex.core.exceptions.MissingDataException;
import convex.core.exceptions.ParseException;
import convex.core.exceptions.TODOException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.message.Message;
import convex.core.store.AStore;
import convex.core.util.JSON;
import convex.core.util.Utils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;

public class ConvexHTTP
extends Convex {
    private final URI uri;
    private final HttpClient httpClient;

    protected ConvexHTTP(Address address, AKeyPair keyPair, URI uri) {
        super(address, keyPair);
        this.uri = uri;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(30L)).build();
    }

    public static ConvexHTTP connect(URI uri, Address address, AKeyPair keyPair) {
        return new ConvexHTTP(address, keyPair, uri);
    }

    private String getAPIPath() {
        int port = this.uri.getPort();
        Object ps = port == -1 ? "" : ":" + port;
        return this.uri.getScheme() + "://" + this.uri.getHost() + (String)ps + "/api/v1";
    }

    public boolean isConnected() {
        return true;
    }

    public CompletableFuture<Result> transact(SignedData<ATransaction> signedTransaction) {
        String transactPath = this.getAPIPath() + "/transact";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(transactPath)).header("Accept", "application/cvx-raw").header("Content-Type", "application/cvx-raw").POST(HttpRequest.BodyPublishers.ofByteArray(Format.encodeMultiCell(signedTransaction, (boolean)true).getBytes())).build();
        CompletableFuture<HttpResponse<byte[]>> future = this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofByteArray());
        CompletionStage result = future.thenApply(response -> this.extractResult((HttpResponse<byte[]>)response));
        return result;
    }

    private Result extractResult(HttpResponse<byte[]> response) {
        String type = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
        try {
            if ("application/cvx".equals(type)) {
                String body = new String(response.body());
                ACell data = Reader.read((String)body);
                return Result.fromData((ACell)data);
            }
            if ("application/cvx-raw".equals(type)) {
                byte[] body = response.body();
                try {
                    ACell v = Format.decodeMultiCell((Blob)Blob.wrap((byte[])body));
                    if (v instanceof Result) {
                        return (Result)v;
                    }
                    return Result.error((Keyword)ErrorCodes.FORMAT, (String)("cvx-raw data not a result but was : " + Utils.getClassName((Object)v)));
                }
                catch (MissingDataException e) {
                    return Result.error((Keyword)ErrorCodes.MISSING, (String)("Missing data in Result : " + String.valueOf(e.getMissingHash()) + " with encoding " + String.valueOf(Blob.wrap((byte[])body))));
                }
            }
            String body = new String(response.body());
            ACell m = JSON.parse((String)body);
            return Result.fromJSON((Object)m);
        }
        catch (ParseException e) {
            return Result.error((Keyword)ErrorCodes.FORMAT, (String)("Can't read response of type " + type + " : " + e.getMessage()));
        }
        catch (Exception e) {
            return Result.fromException((Throwable)e);
        }
    }

    public <T extends ACell> CompletableFuture<T> acquire(Hash hash, AStore store) {
        return null;
    }

    public CompletableFuture<Result> requestStatus() {
        String statusPath = this.getAPIPath() + "/status";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(statusPath)).header("Accept", "application/cvx").GET().build();
        CompletableFuture<HttpResponse<String>> future = this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        CompletionStage result = future.handle((response, ex) -> {
            if (ex != null) {
                return Result.fromException((Throwable)ex).withSource(SourceCodes.NET);
            }
            int statusCode = response.statusCode();
            if (statusCode != 200) {
                return Result.error((Keyword)ErrorCodes.IO, (String)("HTTP status " + statusCode + ": " + (String)response.body())).withSource(SourceCodes.NET);
            }
            String body = (String)response.body();
            try {
                ACell data = Reader.read((String)body);
                if (!(data instanceof AMap)) {
                    return Result.error((Keyword)ErrorCodes.FORMAT, (String)("Expected status map but got: " + Utils.getClassName((Object)data)));
                }
                return Result.value((ACell)data);
            }
            catch (ParseException e) {
                return Result.error((Keyword)ErrorCodes.FORMAT, (String)("Can't read CVX response: " + body));
            }
            catch (Exception e) {
                return Result.fromException((Throwable)e).withSource(SourceCodes.NET);
            }
        });
        return result;
    }

    public CompletableFuture<Result> requestChallenge(SignedData<ACell> data) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Result> query(ACell form, Address address) {
        String queryPath = this.getAPIPath() + "/query";
        AHashMap query = Maps.of((Object[])new Object[]{Keywords.SOURCE, form, Keywords.ADDRESS, address});
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(queryPath)).header("Accept", "application/cvx").header("Content-Type", "application/cvx").POST(HttpRequest.BodyPublishers.ofString(RT.toString((ACell)query))).build();
        CompletableFuture<HttpResponse<String>> future = this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        CompletionStage result = future.handle((response, ex) -> {
            if (ex != null) {
                return Result.fromException((Throwable)ex).withSource(SourceCodes.NET);
            }
            String body = (String)response.body();
            try {
                ACell data = Reader.read((String)body);
                return Result.fromData((ACell)data);
            }
            catch (ParseException e) {
                return Result.error((Keyword)ErrorCodes.FORMAT, (String)("Can't read CVX response: " + body));
            }
            catch (Exception e) {
                return Result.fromException((Throwable)e).withSource(SourceCodes.NET);
            }
        });
        return result;
    }

    public CompletableFuture<Result> messageRaw(Blob message) {
        throw new TODOException();
    }

    public CompletableFuture<Result> message(Message message) {
        throw new TODOException();
    }

    public void close() {
    }

    public String toString() {
        return "Convex HTTP connection to peer " + String.valueOf(this.uri);
    }

    public InetSocketAddress getHostAddress() {
        Integer port = this.uri.getPort();
        if (port == -1) {
            port = "https".equals(this.uri.getScheme()) ? Integer.valueOf(443) : Integer.valueOf(8080);
        }
        return new InetSocketAddress(this.uri.getHost(), (int)port);
    }

    public void reconnect() throws IOException, TimeoutException, InterruptedException {
    }
}

