/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.wallet;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.cvm.Address;
import convex.core.data.ACell;
import convex.core.data.prim.AInteger;
import convex.gui.components.AbstractGUI;
import convex.gui.components.ActionButton;
import convex.gui.components.ActionPanel;
import convex.gui.components.BalanceLabel;
import convex.gui.components.DecimalAmountField;
import convex.gui.utils.SymbolIcon;
import convex.gui.utils.Toolkit;
import convex.gui.wallet.TokenButton;
import convex.gui.wallet.TokenInfo;
import convex.net.IPUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class SwapPanel
extends AbstractGUI {
    protected Convex convex;
    protected TokenInfo token1;
    protected TokenInfo token2;
    private DecimalAmountField amountField;
    private JPanel swapPanel;
    private BalanceLabel receiveLabel;

    private SwapPanel(String title) {
        super(title);
    }

    public SwapPanel(Convex convex, TokenInfo token1, TokenInfo token2) {
        this("Token Swap for account " + String.valueOf(convex.getAddress()));
        this.convex = convex;
        this.token1 = token1;
        this.token2 = token2;
        this.setLayout((LayoutManager)new MigLayout("fill,wrap", "[]", "[][][grow]"));
        this.setBorder(Toolkit.createDialogBorder());
        this.swapPanel = new JPanel();
        this.addSwapComponents();
        this.add((Component)this.swapPanel, "align center,span,growx");
        ActionPanel actionPanel = new ActionPanel();
        actionPanel.add(new ActionButton("Trade!", 59699, e -> {
            this.executeTrade();
            super.closeGUI();
        }));
        actionPanel.add(new ActionButton("Close", 58825, e -> super.closeGUI()));
        actionPanel.add(new ActionButton("Refresh", 58837, e -> this.refreshRates()));
        this.add((Component)actionPanel, "dock south");
        this.refreshRates();
    }

    protected void addSwapComponents() {
        this.swapPanel.removeAll();
        this.swapPanel.setLayout((LayoutManager)new MigLayout("fill,wrap 3"));
        this.swapPanel.add(new JLabel("Amount:"));
        this.amountField = new DecimalAmountField(this.token1.getDecimals());
        this.amountField.setFont(Toolkit.BIG_FONT);
        this.swapPanel.add(new TokenButton(this.token1));
        this.swapPanel.add((Component)this.amountField, "span");
        this.amountField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwapPanel.this.refreshRates();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwapPanel.this.refreshRates();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.amountField.setToolTipText("Input amount of " + this.token1.getSymbol() + " to swap into " + this.token2.getSymbol());
        JButton switchButton = new JButton(SymbolIcon.get(59605, Toolkit.ICON_SIZE));
        switchButton.addActionListener(e -> {
            TokenInfo temp = this.token1;
            this.token1 = this.token2;
            this.token2 = temp;
            String amt = this.receiveLabel.getText();
            System.err.println("Switching amount: " + amt);
            this.addSwapComponents();
            this.amountField.setText(amt);
            System.err.println("Amount Set: " + String.valueOf(this.amountField.getAmount()));
            this.refreshRates();
        });
        this.swapPanel.add(new JLabel());
        this.swapPanel.add((Component)switchButton, "center,span");
        this.swapPanel.add(new JLabel("To:"));
        this.swapPanel.add(new TokenButton(this.token2));
        this.receiveLabel = new BalanceLabel();
        this.receiveLabel.setFont(Toolkit.BIG_FONT);
        this.receiveLabel.setDecimals(this.token2.getDecimals());
        this.receiveLabel.setToolTipText("Amount you will receive when swap occurs");
        this.swapPanel.add(this.receiveLabel);
        this.swapPanel.validate();
        this.swapPanel.repaint();
    }

    protected void refreshRates() {
        String qs;
        Address torus = TokenInfo.getTorusAddress(this.convex);
        this.receiveLabel.setDecimals(this.token2.getDecimals());
        AInteger amount = this.amountField.getAmount();
        if (amount == null) {
            this.receiveLabel.setText("-");
            return;
        }
        if (this.token1.isConvex()) {
            System.err.println(String.valueOf(amount) + " :dec " + this.token1.getDecimals());
            qs = "(" + String.valueOf(torus) + "/sell-cvx " + String.valueOf(this.token2.getID()) + " " + String.valueOf(amount) + ")";
        } else {
            qs = this.token2.isConvex() ? "(" + String.valueOf(torus) + "/sell-quote " + String.valueOf(this.token1.getID()) + " " + String.valueOf(amount) + ")" : "(" + String.valueOf(torus) + "/sell-quote " + String.valueOf(this.token1.getID()) + " " + String.valueOf(amount) + " " + String.valueOf(this.token2.getID()) + ")";
        }
        this.convex.query(qs).thenAccept(r -> {
            System.err.println(qs + " => " + String.valueOf(r));
            ACell val = r.getValue();
            if (val instanceof AInteger) {
                this.receiveLabel.setBalance((AInteger)val);
            } else {
                this.receiveLabel.setBalance(null);
            }
        });
    }

    protected void executeTrade() {
        String qs;
        Address torus = TokenInfo.getTorusAddress(this.convex);
        this.receiveLabel.setDecimals(this.token2.getDecimals());
        AInteger amount = this.amountField.getAmount();
        if (this.token1.isConvex()) {
            System.err.println(String.valueOf(amount) + " :dec " + this.token1.getDecimals());
            qs = "(" + String.valueOf(torus) + "/sell-cvx " + String.valueOf(this.token2.getID()) + " " + String.valueOf(amount) + ")";
        } else {
            qs = this.token2.isConvex() ? "(" + String.valueOf(torus) + "/sell-tokens " + String.valueOf(this.token1.getID()) + " " + String.valueOf(amount) + ")" : "(" + String.valueOf(torus) + "/sell " + String.valueOf(this.token1.getID()) + " " + String.valueOf(amount) + " " + String.valueOf(this.token2.getID()) + ")";
        }
        System.out.println(qs);
        this.convex.transact(qs).thenAccept(r -> {
            ACell val = r.getValue();
            System.out.println(r);
            if (val instanceof AInteger) {
                this.receiveLabel.setBalance((AInteger)val);
            } else {
                this.receiveLabel.setBalance(null);
            }
        });
    }

    public static void main(String[] args) throws InterruptedException, IOException, TimeoutException {
        Toolkit.init();
        InetSocketAddress sa = IPUtils.toInetSocketAddress((String)"localhost:18888");
        ConvexRemote convex = Convex.connect((InetSocketAddress)sa);
        convex.setAddress(Address.create((long)11L));
        new SwapPanel((Convex)convex, TokenInfo.getFungible((Convex)convex, "currency.USDF"), TokenInfo.convexCoin()).run();
    }
}

