/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.state;

import convex.core.cvm.Address;
import convex.core.data.ACell;
import convex.core.data.ACountable;
import convex.core.data.ADataStructure;
import convex.core.data.AMap;
import convex.core.data.ARecord;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.MapEntry;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class StateTreePanel
extends JPanel {
    private final ACell state;
    private static final TreeWillExpandListener expandListener = new TreeWillExpandListener(){

        @Override
        public void treeWillExpand(TreeExpansionEvent tee) throws ExpandVetoException {
            TreePath path = tee.getPath();
            Node tn = (Node)path.getLastPathComponent();
            tn.loadChildren();
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent tee) throws ExpandVetoException {
        }
    };

    public StateTreePanel(ACell state) {
        this.state = state;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 400));
        Node tNode = new Node(this.state);
        tNode.setAllowsChildren(true);
        tNode.loadChildren();
        DefaultTreeModel tModel = new DefaultTreeModel(tNode);
        JTree tree = new JTree(tModel);
        tree.addTreeWillExpandListener(expandListener);
        tree.expandPath(new TreePath(tNode.getPath()));
        this.add((Component)new JScrollPane(tree), "Center");
    }

    private static class Node
    extends DefaultMutableTreeNode {
        private boolean container;
        private boolean loaded = false;
        private String name;

        public Node(String name, ACell val) {
            super(val);
            if (val instanceof ADataStructure) {
                if (RT.count((ACell)val) > 0L) {
                    this.container = true;
                } else {
                    name = (String)name + " (empty)";
                }
            }
            this.name = name;
        }

        public Node(ACell val) {
            this(null, val);
        }

        @Override
        public boolean isLeaf() {
            return !this.container;
        }

        private static String getString(ACell a) {
            if (a instanceof AString) {
                return "\"" + a.toString() + "\"";
            }
            if (a instanceof Address) {
                return a.toString();
            }
            if (a instanceof ACountable) {
                return Utils.getClass((Object)a).getSimpleName();
            }
            AString s = RT.print((ACell)a);
            return s == null ? "<too big>" : s.toString();
        }

        @Override
        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            this.name = Node.getString((ACell)this.userObject);
            return this.name;
        }

        public void loadChildren() {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            ACell a = (ACell)this.userObject;
            if (a instanceof ARecord) {
                ARecord r = (ARecord)a;
                for (ACell k : r.getKeys()) {
                    ACell c = r.get(k);
                    this.add(new Node(String.valueOf(k) + " = " + Node.getString(c), c));
                }
                return;
            }
            if (a instanceof AMap) {
                AMap m = (AMap)a;
                long n = m.count();
                for (long i = 0L; i < n; ++i) {
                    MapEntry e = m.entryAt(i);
                    ACell c = e.getValue();
                    this.add(new Node(RT.toString((ACell)e.getKey()) + " -> " + Node.getString(c), c));
                }
                return;
            }
            if (a instanceof AVector) {
                AVector v = (AVector)a;
                long n = v.count();
                for (long i = 0L; i < n; ++i) {
                    ACell c = v.get(i);
                    this.add(new Node("[" + i + "] -> " + Node.getString(c), c));
                }
                return;
            }
            if (!this.container) {
                return;
            }
            ACell rc = a;
            int n = rc.getRefCount();
            for (int i = 0; i < n; ++i) {
                ACell child = rc.getRef(i).getValue();
                this.add(new Node(child));
            }
        }
    }
}

