/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.state;

import convex.core.crypto.AKeyPair;
import convex.core.cvm.State;
import convex.core.data.ACell;
import convex.core.data.Cells;
import convex.core.init.Init;
import convex.core.lang.RT;
import convex.core.util.Utils;
import convex.gui.components.AbstractGUI;
import convex.gui.components.CodeLabel;
import convex.gui.state.StateTreePanel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;

public class StateExplorer
extends AbstractGUI {
    JTabbedPane tabbedPane = new JTabbedPane(1);
    protected ACell state;

    public StateExplorer(ACell state) {
        super("State Explorer");
        this.state = state;
        this.setLayout(new BorderLayout());
        StringBuilder sb = new StringBuilder();
        sb.append("HASH: " + String.valueOf(Cells.getHash((ACell)state)) + "\n");
        sb.append("TYPE: " + Utils.getClass((Object)state).getSimpleName() + "\n");
        this.add((Component)new CodeLabel(sb.toString()), "North");
        this.tabbedPane.addTab("Tree", null, new StateTreePanel(state), null);
        this.tabbedPane.addTab("Text", null, this.createTextPanel(state), null);
        CodeLabel encLabel = new CodeLabel(Cells.getEncoding((ACell)state).toHexString());
        encLabel.setMaxColumns(64);
        encLabel.setColumns(64);
        encLabel.setWrapStyleWord(false);
        encLabel.setLineWrap(true);
        this.tabbedPane.addTab("Encoding", null, new JScrollPane(encLabel), null);
        this.add((Component)this.tabbedPane, "Center");
    }

    protected JComponent createTextPanel(ACell state) {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add((Component)new JScrollPane(new CodeLabel(RT.toString((ACell)state, (long)10000L))), "dock center");
        return panel;
    }

    public static void explore(ACell a) {
        EventQueue.invokeLater(() -> new StateExplorer(a).run());
    }

    public static void main(String[] args) {
        Toolkit.init();
        AKeyPair kp = AKeyPair.createSeeded((long)564646L);
        State state = Init.createState(List.of(kp.getAccountKey()));
        StateExplorer gui = new StateExplorer((ACell)state);
        gui.run();
        gui.waitForClose();
        System.exit(0);
    }
}

