/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.gui.utils.Toolkit;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class RightCopyMenu
extends JPopupMenu
implements ActionListener {
    JMenuItem copyMenuItem = new JMenuItem("Copy", Toolkit.menuIcon(57677));
    JMenuItem cutMenuItem = new JMenuItem("Cut", Toolkit.menuIcon(985278));
    JMenuItem pasteMenuItem = new JMenuItem("Paste", Toolkit.menuIcon(57679));
    JTextComponent comp;

    public RightCopyMenu(JTextComponent invoker) {
        this.comp = invoker;
        this.copyMenuItem.addActionListener(this);
        this.cutMenuItem.addActionListener(this);
        this.pasteMenuItem.addActionListener(this);
        this.add(this.copyMenuItem);
        if (invoker.isEditable()) {
            this.add(this.cutMenuItem);
            this.add(this.pasteMenuItem);
        }
        this.setInvoker(invoker);
    }

    public static void addTo(final JTextComponent tf) {
        final RightCopyMenu menu = new RightCopyMenu(tf);
        tf.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                switch (e.getButton()) {
                    case 3: {
                        menu.show(tf, e.getX(), e.getY());
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Component invoker = this.getInvoker();
        if (invoker instanceof JTextComponent) {
            JTextComponent tf = (JTextComponent)invoker;
            if (source == this.cutMenuItem) {
                tf.cut();
            } else if (source == this.copyMenuItem) {
                tf.copy();
            } else if (source == this.pasteMenuItem) {
                tf.paste();
            }
        }
    }
}

