/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import convex.core.util.Utils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class QRCode
extends JPanel {
    protected final String data;
    protected BufferedImage image;

    public QRCode(String data, int scale) {
        this.data = data;
        this.image = QRCode.createQR(data, scale);
        this.setLayout((LayoutManager)new MigLayout());
        this.setMinimumSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
        this.setToolTipText(data);
    }

    public static BufferedImage createQR(String data, int scale) {
        try {
            BitMatrix matrix = new MultiFormatWriter().encode(data, BarcodeFormat.QR_CODE, scale, scale);
            return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
        }
        catch (WriterException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.image, 0, 0, this);
    }
}

