/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.Blobs;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.prim.CVMLong;
import convex.core.lang.RT;
import convex.gui.components.AbstractGUI;
import convex.gui.utils.Toolkit;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;
import net.miginfocom.swing.MigLayout;

public class Identicon
extends JLabel {
    protected int displaySize = Toolkit.IDENTICON_SIZE;
    protected static final int SIZE = 7;
    private static WeakHashMap<AArrayBlob, ImageIcon> wm = new WeakHashMap();

    public static BufferedImage createImage(AArrayBlob data, int renderSize) {
        if (data == null || data.isEmpty()) {
            return new BufferedImage(renderSize, renderSize, 1);
        }
        long n = data.count();
        BufferedImage bi = new BufferedImage(7, 7, 1);
        int[] cols = new int[4];
        for (int i = 0; i < 4; ++i) {
            int col;
            int r = 0xFF & data.byteAt(Math.floorMod(n - 12L + (long)(i * 3) + 0L, n));
            int g = 0xFF & data.byteAt(Math.floorMod(n - 12L + (long)(i * 3) + 1L, n));
            int b = 0xFF & data.byteAt(Math.floorMod(n - 12L + (long)(i * 3) + 2L, n));
            cols[i] = col = 0x800000 ^ (r << 16 | g << 8 | b);
        }
        int width = 4;
        for (int y = 0; y < 7; ++y) {
            int i;
            int byteIndex;
            for (int x = 0; x <= width && (long)(byteIndex = (i = x + y * width) / 4) < n; ++x) {
                byte b = data.byteAt((long)byteIndex);
                int bits = 3 & b >> 2 * (3 - i % 4);
                int rgb = cols[bits];
                bi.setRGB(x, y, rgb);
                bi.setRGB(7 - x - 1, y, rgb);
            }
        }
        return Toolkit.pixelResize(bi, renderSize, renderSize);
    }

    public static ImageIcon createIcon(AArrayBlob hash, int size) {
        ImageIcon cached = wm.get(hash);
        if (cached != null && cached.getImage().getWidth(null) == size) {
            return cached;
        }
        ImageIcon result = new ImageIcon(Identicon.createImage(hash, size));
        result.setDescription(RT.toString((ACell)hash));
        wm.put(hash, result);
        return result;
    }

    public Identicon(final AArrayBlob a, int displaySize) {
        this.displaySize = displaySize;
        this.setKey(a);
        this.setFont(Toolkit.MONO_FONT);
        this.setBorder(new BevelBorder(0, null, null, null, null));
        Toolkit.addPopupMenu(this, new JPopupMenu(){
            {
                JMenuItem closeButton = new JMenuItem("Copy Public Key", Toolkit.menuIcon(57677));
                closeButton.addActionListener(e -> Toolkit.copyToClipboard(a.toString()));
                this.add(closeButton);
            }
        });
    }

    public Identicon(AArrayBlob a) {
        this(a, Toolkit.IDENTICON_SIZE);
    }

    public static void main(String ... args) {
        Toolkit.init();
        IdenticApp app = new IdenticApp();
        app.run();
    }

    public void setKey(AArrayBlob a) {
        ImageIcon icon = Identicon.createIcon(a, this.displaySize);
        this.setToolTipText(icon.getDescription());
        this.setIcon(icon);
    }

    public static class IdenticApp
    extends AbstractGUI {
        public IdenticApp() {
            super("Convex Identicons");
            int i;
            this.setLayout(new FlowLayout());
            for (i = 0; i < 64; ++i) {
                this.add(new Identicon((AArrayBlob)CVMLong.create((long)i).getHash().toCVMString(100L).toFlatBlob()));
            }
            for (i = 0; i < 64; ++i) {
                this.add(new Identicon((AArrayBlob)Keyword.create((String)Integer.toString(i)).getEncoding()));
            }
            for (i = 0; i < 64; ++i) {
                this.add(new Identicon((AArrayBlob)Blobs.createFilled((int)(i * 4), (long)32L).toFlatBlob()));
            }
            for (i = 0; i < 64; ++i) {
                this.add(new Identicon((AArrayBlob)Hash.get((ACell)CVMLong.create((long)i).getHash())));
            }
            this.add(new Identicon(null));
        }

        @Override
        public void setupFrame(JFrame frame) {
            frame.getContentPane().setLayout((LayoutManager)new MigLayout());
            frame.getContentPane().add((Component)this, "dock center");
        }
    }
}

