/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.text.Text;
import convex.gui.components.RightCopyMenu;
import convex.gui.utils.Toolkit;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JTextArea;

public class CodeLabel
extends JTextArea {
    private static final int EXTRA = 5;
    private int maxColumns = 0;

    public CodeLabel() {
        this("");
    }

    public CodeLabel(String text) {
        super(Text.lineCount((String)text), 0);
        this.setText(text);
        this.setEditable(false);
        this.setFont(Toolkit.MONO_FONT);
        RightCopyMenu.addTo(this);
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxColumns(int maxColumns) {
        if (maxColumns < 0) {
            throw new IllegalArgumentException("Max columns must be 0 or positive");
        }
        this.maxColumns = maxColumns;
    }

    @Override
    public Dimension getPreferredSize() {
        int rows;
        Dimension d = new Dimension(400, 400);
        Insets insets = this.getInsets();
        int columns = this.getColumns();
        if (columns == 0) {
            columns = this.maxColumns;
        }
        if (columns != 0) {
            if (this.maxColumns > 0 && columns > this.maxColumns) {
                columns = this.maxColumns;
            }
            d.width = columns * this.getColumnWidth() + insets.left + insets.right + 5;
        }
        if ((rows = this.getRows()) != 0) {
            d.height = rows * this.getRowHeight() + insets.top + insets.bottom;
        }
        return d;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.maxColumns != 0) {
            return false;
        }
        return super.getScrollableTracksViewportWidth();
    }

    @Override
    public Dimension getMaximumSize() {
        int cw = this.getColumnWidth();
        Dimension d = new Dimension(cw, cw);
        Insets insets = this.getInsets();
        int columns = this.getColumns();
        if (this.maxColumns > 0 && columns > this.maxColumns) {
            columns = this.maxColumns;
        }
        d.width = columns * cw + insets.left + insets.right + 5;
        return d;
    }

    @Override
    public void setColumns(int columns) {
        if (this.maxColumns != 0 && columns > this.maxColumns) {
            columns = this.maxColumns;
        }
        super.setColumns(columns);
    }
}

