/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.server;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.Networks;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.Address;
import convex.core.cvm.transactions.ATransaction;
import convex.core.cvm.transactions.Invoke;
import convex.core.cvm.transactions.Multi;
import convex.core.cvm.transactions.Transfer;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Hash;
import convex.core.data.Strings;
import convex.core.lang.Reader;
import convex.core.text.Text;
import convex.core.util.ThreadUtils;
import convex.core.util.Utils;
import convex.gui.components.ActionPanel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressPanel
extends JPanel {
    static final Logger log = LoggerFactory.getLogger((String)StressPanel.class.getName());
    protected Convex peerConvex;
    private ActionPanel actionPanel;
    private JButton btnRun;
    private JSpinner requestCountSpinner;
    private JSpinner transactionCountSpinner;
    private JSpinner opCountSpinner;
    private JSpinner clientCountSpinner;
    private JSpinner repeatTimeSpinner;
    private JCheckBox syncCheckBox;
    private JCheckBox distCheckBox;
    private JCheckBox repeatCheckBox;
    private JCheckBox queryCheckBox;
    private JSplitPane splitPane;
    private JPanel resultPanel;
    private JTextArea resultArea;
    private JComboBox<String> txTypeBox;
    NumberFormat formatter = new DecimalFormat("#0.000");

    public StressPanel(Convex peerView) {
        this.peerConvex = peerView;
        this.setLayout(new BorderLayout());
        this.actionPanel = new ActionPanel();
        this.add((Component)this.actionPanel, "South");
        this.btnRun = new JButton("Run Test");
        this.actionPanel.add(this.btnRun);
        this.btnRun.addActionListener(e -> {
            int confirm;
            Hash network = peerView.getLocalServer().getPeer().getGenesisHash();
            if (network.equals(Networks.PRONONET_GENESIS) && (confirm = JOptionPane.showConfirmDialog(this, "This is the live network. Running a stress test is likley to be expensive! Are you really sure you want to do this?", "Run test on Live network?", 2)) != 0) {
                return;
            }
            this.btnRun.setEnabled(false);
            Address address = this.peerConvex.getAddress();
            AKeyPair kp = this.peerConvex.getKeyPair();
            new StressTest(kp, address).execute();
        });
        this.splitPane = new JSplitPane();
        this.add((Component)this.splitPane, "Center");
        JPanel panel = new JPanel();
        this.splitPane.setLeftComponent(panel);
        FlowLayout flowLayout = (FlowLayout)panel.getLayout();
        flowLayout.setAlignment(0);
        flowLayout.setAlignOnBaseline(true);
        JPanel optionPanel = new JPanel();
        panel.add(optionPanel);
        optionPanel.setLayout(new GridLayout(0, 2, 0, 0));
        JLabel lblClients = new JLabel("Clients");
        optionPanel.add(lblClients);
        this.clientCountSpinner = new JSpinner();
        this.clientCountSpinner.setModel(new SpinnerNumberModel(100, 1, 1000, 1));
        optionPanel.add(this.clientCountSpinner);
        JLabel lblRequests = new JLabel("Requests per client");
        optionPanel.add(lblRequests);
        this.requestCountSpinner = new JSpinner();
        this.requestCountSpinner.setModel(new SpinnerNumberModel(100, 1, 1000000, 10));
        optionPanel.add(this.requestCountSpinner);
        JLabel lblTrans = new JLabel("Transactions per Request");
        optionPanel.add(lblTrans);
        this.transactionCountSpinner = new JSpinner();
        this.transactionCountSpinner.setModel(new SpinnerNumberModel(10, 1, 1000, 1));
        optionPanel.add(this.transactionCountSpinner);
        JLabel lblOps = new JLabel("Ops per Transaction");
        optionPanel.add(lblOps);
        this.opCountSpinner = new JSpinner();
        this.opCountSpinner.setModel(new SpinnerNumberModel(1, 1, 1000, 10));
        optionPanel.add(this.opCountSpinner);
        JLabel lblSync = new JLabel("Sync Requests?");
        optionPanel.add(lblSync);
        this.syncCheckBox = new JCheckBox();
        optionPanel.add(this.syncCheckBox);
        this.syncCheckBox.setSelected(false);
        this.distCheckBox = new JCheckBox();
        this.distCheckBox.setSelected(false);
        optionPanel.add(new JLabel("Repeat requests?"));
        this.repeatCheckBox = new JCheckBox();
        optionPanel.add(this.repeatCheckBox);
        this.repeatCheckBox.setSelected(false);
        optionPanel.add(new JLabel("Query"));
        this.queryCheckBox = new JCheckBox();
        optionPanel.add(this.queryCheckBox);
        this.queryCheckBox.setSelected(false);
        optionPanel.add(new JLabel("Repeat timeout"));
        this.repeatTimeSpinner = new JSpinner();
        this.repeatTimeSpinner.setModel(new SpinnerNumberModel(60, 0, 3600, 1));
        optionPanel.add(this.repeatTimeSpinner);
        JLabel lblTxType = new JLabel("Transaction Type");
        this.txTypeBox = new JComboBox();
        this.txTypeBox.addItem("Transfer");
        this.txTypeBox.addItem("Define Data");
        this.txTypeBox.addItem("Null Op");
        optionPanel.add(lblTxType);
        optionPanel.add(this.txTypeBox);
        this.resultPanel = new JPanel();
        this.splitPane.setRightComponent(this.resultPanel);
        this.resultPanel.setLayout(new BorderLayout(0, 0));
        this.resultArea = new JTextArea();
        this.resultArea.setText("No results yet");
        this.resultArea.setLineWrap(true);
        this.resultArea.setEditable(false);
        this.resultPanel.add(this.resultArea);
        this.resultArea.setFont(Toolkit.MONO_FONT);
    }

    private final class StressTest
    extends SwingWorker<String, Object> {
        long errors = 0L;
        long values = 0L;
        private final AKeyPair kp;
        private final Address address;
        int transCount;
        int requestCount;
        int opCount;
        int clientCount;
        String type;
        ArrayList<AKeyPair> kps;
        ArrayList<Convex> clients;
        InetSocketAddress sa;

        private StressTest(AKeyPair kp, Address address) {
            this.transCount = (Integer)StressPanel.this.transactionCountSpinner.getValue();
            this.requestCount = (Integer)StressPanel.this.requestCountSpinner.getValue();
            this.opCount = (Integer)StressPanel.this.opCountSpinner.getValue();
            this.clientCount = (Integer)StressPanel.this.clientCountSpinner.getValue();
            this.type = (String)StressPanel.this.txTypeBox.getSelectedItem();
            this.kps = new ArrayList(this.clientCount);
            this.clients = new ArrayList(this.clientCount);
            this.sa = StressPanel.this.peerConvex.getHostAddress();
            this.kp = kp;
            this.address = address;
        }

        @Override
        protected String doInBackground() {
            String result = null;
            try {
                boolean running = true;
                while (running) {
                    result = this.doStressRun();
                    running = StressPanel.this.repeatCheckBox.isSelected();
                    if (!running) continue;
                    Thread.sleep((Integer)StressPanel.this.repeatTimeSpinner.getValue() * 1000);
                }
            }
            catch (ExecutionException e) {
                log.info("Stress test worker terminated", (Throwable)e);
                StressPanel.this.resultArea.setText("Test Error: " + String.valueOf(e));
            }
            catch (Exception e) {
                log.warn("Stress test worker terminated unexpectedly", (Throwable)e);
                StressPanel.this.resultArea.setText("Test Error: " + String.valueOf(e));
            }
            finally {
                StressPanel.this.btnRun.setEnabled(true);
            }
            return result;
        }

        protected String doStressRun() throws Exception {
            StringBuilder sb = new StringBuilder();
            StressPanel.this.resultArea.setText("Connecting clients...");
            ArrayList frs = new ArrayList();
            ConvexRemote pc = Convex.connect((InetSocketAddress)this.sa, (Address)this.address, (AKeyPair)this.kp);
            StringBuilder cmdsb = new StringBuilder();
            cmdsb.append("(let [f (fn [k] (let [a (deploy `(do (set-key ~k) (set-controller #13))] (transfer a 1000000000) a))] ");
            cmdsb.append("  (mapv f [");
            for (int i = 0; i < this.clientCount; ++i) {
                AKeyPair kp = AKeyPair.generate();
                this.kps.add(kp);
                cmdsb.append(" " + String.valueOf(kp.getAccountKey()));
            }
            cmdsb.append("]))");
            Result ccr = pc.transactSync((ACell)Invoke.create((Address)this.address, (long)0L, (String)cmdsb.toString()));
            if (ccr.isError()) {
                throw new Error("Creating accounts failed: " + String.valueOf(ccr));
            }
            AVector clientAddresses = (AVector)ccr.getValue();
            this.connectClients((AVector<Address>)clientAddresses);
            this.setupClients();
            StressPanel.this.resultArea.setText("Syncing...");
            pc.transactSync((ACell)Invoke.create((Address)this.address, (long)0L, (ACell)Strings.create((String)"sync")));
            long startTime = Utils.getCurrentTimestamp();
            StressPanel.this.resultArea.setText("Sending transactions...");
            ExecutorService ex = ThreadUtils.getVirtualExecutor();
            ArrayList cfutures = ThreadUtils.futureMap((ExecutorService)ex, cc -> {
                try {
                    for (int i = 0; i < this.requestCount; ++i) {
                        CompletableFuture<Result> fr;
                        Address origin = cc.getAddress();
                        ATransaction t = this.buildTransaction(origin, i);
                        if (StressPanel.this.queryCheckBox.isSelected()) {
                            if (StressPanel.this.syncCheckBox.isSelected()) {
                                r = cc.querySync((ACell)t);
                                fr = CompletableFuture.completedFuture(r);
                            } else {
                                fr = cc.query((ACell)t);
                            }
                        } else if (StressPanel.this.syncCheckBox.isSelected()) {
                            r = cc.transactSync((ACell)t);
                            fr = CompletableFuture.completedFuture(r);
                        } else {
                            fr = cc.transact(t);
                        }
                        ArrayList arrayList = frs;
                        synchronized (arrayList) {
                            frs.add(fr);
                            continue;
                        }
                    }
                }
                catch (Exception e) {
                    throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
                }
                return null;
            }, this.clients);
            for (int i = 0; i < this.clientCount; ++i) {
                ((CompletableFuture)cfutures.get(i)).get();
            }
            int futureCount = frs.size();
            StressPanel.this.resultArea.setText("Awaiting " + futureCount + " results...");
            List results = (List)ThreadUtils.completeAll(frs).get();
            long endTime = Utils.getCurrentTimestamp();
            HashMap errorMap = new HashMap();
            for (Result r : results) {
                if (r.isError()) {
                    ++this.errors;
                    Utils.histogramAdd(errorMap, (Object)r.getErrorCode());
                    continue;
                }
                ++this.values;
            }
            for (int i = 0; i < this.clientCount; ++i) {
                this.clients.get(i).close();
            }
            Thread.sleep(100L);
            long totalCount = this.clientCount * this.transCount * this.requestCount;
            sb.append("Results for " + Text.toFriendlyNumber((long)totalCount) + " transactions\n");
            sb.append(this.values + " values received\n");
            sb.append(this.errors + " errors received\n");
            if (this.errors > 0L) {
                sb.append(errorMap);
                sb.append("\n");
            }
            double time = (double)(endTime - startTime) * 0.001;
            sb.append("\n");
            sb.append("Total time:     " + StressPanel.this.formatter.format(time) + "s\n");
            sb.append("\n");
            sb.append("Approx TPS:     " + Text.toFriendlyIntString((double)((double)totalCount / time)) + "\n");
            sb.append("Approx OPS:     " + Text.toFriendlyIntString((double)((double)((long)this.opCount * totalCount) / time)) + "\n");
            String report = sb.toString();
            return report;
        }

        private void setupClients() throws IOException, TimeoutException {
            for (Convex c : this.clients) {
                String code = null;
                switch (this.type) {
                    case "AMM Trade": {
                        code = "nil";
                        break;
                    }
                }
                if (code == null) continue;
                c.transact(code);
            }
        }

        protected void connectClients(AVector<Address> clientAddresses) throws IOException, TimeoutException, InterruptedException {
            for (int i = 0; i < this.clientCount; ++i) {
                AKeyPair kp = this.kps.get(i);
                Address clientAddr = (Address)clientAddresses.get(i);
                ConvexRemote cc = Convex.connect((InetSocketAddress)this.sa, (Address)clientAddr, (AKeyPair)kp);
                this.clients.add((Convex)cc);
            }
        }

        protected ATransaction buildTransaction(Address origin, int reqNo) {
            ATransaction[] trxs = new ATransaction[this.transCount];
            for (int k = 0; k < this.transCount; ++k) {
                trxs[k] = this.buildSubTransaction(reqNo, k, origin);
            }
            Object t = this.transCount != 1 ? Multi.create((Address)origin, (long)0L, (int)0, (ATransaction[])trxs) : trxs[0];
            return t;
        }

        protected ATransaction buildSubTransaction(int reqNo, int txNo, Address origin) {
            Address target = this.clients.get((1 + reqNo + txNo * 6969) % this.clients.size()).getAddress();
            if (this.type.equals("Transfer")) {
                Transfer t = Transfer.create((Address)origin, (long)0L, (Address)target, (long)100L);
                return t;
            }
            StringBuilder tsb = new StringBuilder();
            if (this.opCount > 1) {
                tsb.append("(loop [i 0] ");
            }
            block8: for (int j = 0; j < this.opCount; ++j) {
                switch (this.type) {
                    case "Define Data": {
                        tsb.append("(def a" + txNo + " " + reqNo + ") ");
                        continue block8;
                    }
                    case "Null Op": {
                        tsb.append("nil ");
                        continue block8;
                    }
                    default: {
                        throw new Error("Bad TX type: " + this.type);
                    }
                }
            }
            if (this.opCount > 1) {
                tsb.append(" (cond (> i " + this.opCount + ") nil (recur (inc i)) ) )");
            }
            String source = tsb.toString();
            Invoke t = Invoke.create((Address)origin, (long)0L, (ACell)Reader.read((String)source));
            return t;
        }

        @Override
        protected void done() {
            try {
                StressPanel.this.resultArea.setText((String)this.get());
            }
            catch (Exception e) {
                StressPanel.this.resultArea.setText(e.getMessage());
            }
        }
    }
}

