/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.peer;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.api.ConvexRemote;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.wallet.AWalletEntry;
import convex.core.cvm.Address;
import convex.core.cvm.Peer;
import convex.core.cvm.PeerStatus;
import convex.core.cvm.State;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AccountKey;
import convex.core.text.Text;
import convex.core.util.FileUtils;
import convex.core.util.Utils;
import convex.etch.EtchStore;
import convex.gui.components.BaseImageButton;
import convex.gui.components.BaseListComponent;
import convex.gui.components.CodeLabel;
import convex.gui.components.DropdownMenu;
import convex.gui.components.Identicon;
import convex.gui.etch.EtchWindow;
import convex.gui.keys.KeyRingPanel;
import convex.gui.models.StateModel;
import convex.gui.peer.BlockViewComponent;
import convex.gui.peer.PeerGUI;
import convex.gui.repl.REPLClient;
import convex.gui.server.PeerWindow;
import convex.gui.state.StateExplorer;
import convex.gui.utils.Toolkit;
import convex.gui.wallet.WalletApp;
import convex.peer.ConnectionManager;
import convex.peer.Server;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Objects;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerComponent
extends BaseListComponent {
    public ConvexLocal convex;
    CodeLabel description;
    private static final Logger log = LoggerFactory.getLogger((String)PeerComponent.class.getName());

    public void launchPeerWindow(ConvexLocal peer) {
        Server server = peer.getLocalServer();
        ConvexLocal newConvex = this.connectLocalControllerWallet(server);
        PeerWindow pw = new PeerWindow(newConvex);
        pw.run();
    }

    private ConvexLocal connectLocalControllerWallet(Server server) {
        AKeyPair kp = null;
        Address controller = server.getPeerController();
        if (controller != null) {
            try {
                AccountKey key = server.getPeer().getConsensusState().getAccount(controller).getAccountKey();
                AWalletEntry we = KeyRingPanel.getKeyRingEntry(key);
                kp = we.getKeyPair();
            }
            catch (Exception e) {
                log.warn("Error getting controller details", (Throwable)e);
            }
        }
        ConvexLocal convex = ConvexLocal.connect((Server)server, (Address)controller, kp);
        return convex;
    }

    public void launchEtchWindow(ConvexLocal peer) {
        EtchWindow ew = new EtchWindow(peer);
        ew.run();
    }

    public void launchExploreWindow(Convex peer) {
        Server s = peer.getLocalServer();
        State p = s.getPeer().getConsensusState();
        StateExplorer pw = new StateExplorer((ACell)p);
        pw.run();
    }

    public PeerComponent(ConvexLocal value) {
        this.convex = value;
        this.setLayout((LayoutManager)new MigLayout());
        BaseImageButton button = new BaseImageButton(Toolkit.CONVEX);
        button.setFocusable(false);
        button.addActionListener(e -> this.launchPeerWindow(this.convex));
        button.setToolTipText("Launch Peer management window for this peer server");
        this.add((Component)button, "dock west");
        JPanel centralPanel = new JPanel();
        centralPanel.setLayout((LayoutManager)new MigLayout("wrap 2", "[][]"));
        Server server = this.convex.getLocalServer();
        AccountKey peerKey = server.getPeerKey();
        Identicon identicon = new Identicon((AArrayBlob)peerKey, Toolkit.IDENTICON_SIZE_LARGE);
        centralPanel.add(identicon);
        CodeLabel peerKeyLabel = new CodeLabel("0x" + peerKey.toChecksumHex());
        peerKeyLabel.setMaxColumns(66);
        peerKeyLabel.setToolTipText("Public key of the peer.");
        centralPanel.add((Component)peerKeyLabel, "span");
        this.description = new CodeLabel(this.getPeerDescription());
        this.description.setFont(Toolkit.MONO_FONT);
        this.description.setEditable(false);
        this.description.setMaxColumns(80);
        this.description.setBorder(null);
        this.description.setBackground(null);
        centralPanel.add((Component)this.description, "span 2");
        this.add((Component)centralPanel, "dock center");
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem closeButton = new JMenuItem("Shutdown Peer", Toolkit.menuIcon(59564));
        closeButton.addActionListener(e -> server.shutdown());
        popupMenu.add(closeButton);
        JMenuItem exploreButton = new JMenuItem("Explore state", Toolkit.menuIcon(59770));
        exploreButton.addActionListener(e -> this.launchExploreWindow((Convex)this.convex));
        popupMenu.add(exploreButton);
        if (server.getStore() instanceof EtchStore) {
            JMenuItem storeButton = new JMenuItem("Explore Etch store", Toolkit.menuIcon(63502));
            storeButton.addActionListener(e -> this.launchEtchWindow(this.convex));
            popupMenu.add(storeButton);
        }
        JMenuItem killConn = new JMenuItem("Kill Connections", Toolkit.menuIcon(57711));
        killConn.addActionListener(e -> server.getConnectionManager().closeAllConnections());
        popupMenu.add(killConn);
        JMenuItem replButton = new JMenuItem("Launch REPL", Toolkit.menuIcon(60302));
        replButton.addActionListener(e -> this.launchPeerWindow(this.convex));
        popupMenu.add(replButton);
        JMenuItem walletButton = new JMenuItem("Open controller Wallet", Toolkit.menuIcon(59472));
        walletButton.addActionListener(e -> new WalletApp((Convex)this.connectLocalControllerWallet(server)).run());
        popupMenu.add(walletButton);
        JMenuItem saveButton = new JMenuItem("Save Peer Data...", Toolkit.menuIcon(57697));
        saveButton.addActionListener(e -> this.savePeerData(this.convex));
        popupMenu.add(saveButton);
        JMenuItem loadButton = new JMenuItem("Load Peer Data...", Toolkit.menuIcon(60147));
        loadButton.addActionListener(e -> this.loadPeerData(this.convex));
        popupMenu.add(loadButton);
        DropdownMenu dm = new DropdownMenu(popupMenu);
        this.add((Component)dm, "dock east");
        BlockViewComponent blockView = new BlockViewComponent(this.convex);
        StateModel<Peer> model = PeerGUI.getStateModel((Convex)this.convex);
        if (model != null) {
            model.addPropertyChangeListener(e -> {
                blockView.repaint();
                this.description.setText(this.getPeerDescription());
            });
            model.addPropertyChangeListener(e -> this.updateDescription());
        }
        this.add((Component)blockView, "dock south");
        this.updateDescription();
    }

    private void loadPeerData(ConvexLocal convex) {
        JFileChooser chooser = Toolkit.createCAD3Chooser(null);
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            System.out.println("Loading: " + String.valueOf(chooser.getSelectedFile()));
        }
    }

    private void savePeerData(ConvexLocal convex) {
        Peer p = convex.getLocalServer().getPeer();
        AMap data = p.toData();
        String fileName = "peer-data-" + p.getPeerKey().toHexString(8) + "-" + Utils.timeString() + ".cad3";
        JFileChooser chooser = Toolkit.createCAD3Chooser(fileName);
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            Path path = chooser.getSelectedFile().toPath();
            try {
                FileUtils.writeCAD3((Path)path, (ACell)data);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Peer data save failed:\n " + String.valueOf(e), "Save Error", 0);
            }
        }
    }

    protected void updateDescription() {
        String current = this.description.getText();
        String updated = this.getPeerDescription();
        if (Objects.equals(updated, current)) {
            return;
        }
        int ss = this.description.getSelectionStart();
        int se = this.description.getSelectionEnd();
        this.description.setText(updated);
        this.description.select(ss, se);
    }

    protected void launchClientWindow(Convex peer) {
        try {
            ConvexRemote convex = ConvexRemote.connect((InetSocketAddress)peer.getHostAddress());
            Address addr = peer.getAddress();
            AKeyPair kp = null;
            Server s = peer.getLocalServer();
            if (s != null) {
                kp = s.getControllerKey();
            }
            convex.setAddress(addr, kp);
            new REPLClient((Convex)convex).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPeerDescription() {
        StringBuilder sb = new StringBuilder();
        Server server = this.convex.getLocalServer();
        if (server != null) {
            State state = server.getPeer().getConsensusState();
            AccountKey paddr = server.getPeerKey();
            if (server.isLive()) {
                sb.append("Local server on port: " + server.getPort() + "\n");
            } else {
                sb.append("Inactive Peer\n");
            }
            PeerStatus ps = state.getPeer(paddr);
            if (ps != null) {
                sb.append("Controller: " + String.valueOf(ps.getController()));
                sb.append("   ");
                sb.append("Stake: " + Text.toFriendlyBalance((long)ps.getPeerStake(), (int)2));
                sb.append("   ");
                sb.append("Delegated Stake: " + Text.toFriendlyBalance((long)ps.getDelegatedStake(), (int)2));
                sb.append("   ");
            } else {
                sb.append("Not currently a registered peer    ");
            }
            ConnectionManager cm = server.getConnectionManager();
            sb.append("C: " + cm.getConnectionCount());
        } else if (this.convex != null) {
            sb.append(this.convex.toString());
        } else {
            sb.append("Unknown");
        }
        return sb.toString();
    }
}

