/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.keys;

import convex.core.crypto.wallet.AWalletEntry;
import convex.gui.components.Identicon;
import convex.gui.utils.Toolkit;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class UnlockWalletDialog
extends JDialog {
    private JPasswordField passwordField;
    private char[] passPhrase = null;

    public static UnlockWalletDialog show(Component parent, AWalletEntry walletEntry) {
        UnlockWalletDialog dialog = new UnlockWalletDialog(walletEntry);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog;
    }

    public char[] getPassPhrase() {
        return this.passPhrase;
    }

    public UnlockWalletDialog(AWalletEntry walletEntry) {
        this.setIconImage(Toolkit.WARNING.getImage());
        this.setAlwaysOnTop(true);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle("Unlock Key");
        this.setModal(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout((LayoutManager)new MigLayout("", "", "[fill]"));
        mainPanel.setBorder(Toolkit.createDialogBorder());
        this.getContentPane().add((Component)mainPanel, "North");
        Identicon a = new Identicon(walletEntry.getIdenticonData(), Toolkit.IDENTICON_SIZE_LARGE);
        a.setText("0x" + walletEntry.getPublicKey().toChecksumHex());
        mainPanel.add((Component)a, "span");
        JPanel passPanel = new JPanel();
        JLabel lblPassphrase = new JLabel("Unlock Password: ");
        passPanel.add(lblPassphrase);
        this.passwordField = new JPasswordField();
        this.passwordField.setFont(new Font("Monospaced", 1, 13));
        this.passwordField.setColumns(40);
        passPanel.add(Toolkit.wrapPasswordField(this.passwordField));
        mainPanel.add(passPanel);
        JPanel buttonPanel = new JPanel();
        JButton btnUnlock = new JButton("Unlock");
        buttonPanel.add(btnUnlock);
        btnUnlock.addActionListener(e -> {
            this.passPhrase = this.passwordField.getPassword();
            this.close();
        });
        JButton btnCancel = new JButton("Cancel");
        buttonPanel.add(btnCancel);
        btnCancel.addActionListener(e -> this.close());
        mainPanel.add((Component)buttonPanel, "dock south");
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnlockWalletDialog.this.close();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
        this.getRootPane().getActionMap().put("close", closeAction);
        this.pack();
        this.passwordField.requestFocus();
    }

    public void close() {
        this.passwordField = null;
        this.setVisible(false);
    }

    public static boolean offerUnlock(Component parent, AWalletEntry walletEntry) {
        UnlockWalletDialog dialog = UnlockWalletDialog.show(parent, walletEntry);
        char[] passPhrase = dialog.getPassPhrase();
        if (passPhrase != null) {
            try {
                walletEntry.unlock(passPhrase);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(parent, "Unable to unlock keypair: " + e1.getMessage(), "Unlock Failed", 2);
            }
        }
        return !walletEntry.isLocked();
    }
}

