/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.dlfs;

import convex.dlfs.DLFileSystem;
import convex.gui.dlfs.DLFSTreeCellRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class DirectoryTree
extends JTree {
    protected DLFileSystem fileSystem;

    public DirectoryTree(DLFileSystem dlfs) {
        this.fileSystem = dlfs;
        this.setModel(new DLFileTreeModel(dlfs));
        this.setExpandsSelectedPaths(true);
        this.setEnabled(true);
        DLFSTreeCellRenderer renderer = new DLFSTreeCellRenderer();
        this.setCellRenderer(renderer);
        this.setShowsRootHandles(false);
        this.setRootVisible(true);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selPath = DirectoryTree.this.getPathForLocation(e.getX(), e.getY());
                DirectoryTree.this.setSelectionPath(selPath);
                DirectoryTree.this.validate();
            }
        });
        this.addTreeWillExpandListener(new TreeWillExpandListener(this){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath treePath = event.getPath();
                if (treePath.getLastPathComponent() instanceof Node) {
                    Node node = (Node)treePath.getLastPathComponent();
                    node.loadChildren();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
    }

    public static class DLFileTreeModel
    extends DefaultTreeModel {
        protected Path root;

        public DLFileTreeModel(DLFileSystem filesystem) {
            super(DLFileTreeModel.getNode((Path)filesystem.getRoot()));
        }

        static Node getNode(Path path) {
            Node node = new Node(path);
            node.loadChildren();
            return node;
        }
    }

    public static class Node
    extends DefaultMutableTreeNode {
        private boolean childrenLoaded = false;
        private boolean isDirectory = false;

        public Node(Path path) {
            super(path);
            this.isDirectory = Files.isDirectory(path, new LinkOption[0]);
            if (this.isDirectory) {
                this.setAllowsChildren(true);
            }
        }

        public Path getFilePath() {
            return (Path)this.getUserObject();
        }

        public void loadChildren() {
            if (this.childrenLoaded) {
                this.removeAllChildren();
            }
            if (!this.isDirectory) {
                return;
            }
            Path p = this.getFilePath();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(p);){
                for (Path path : stream) {
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    this.add(new Node(path));
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            this.childrenLoaded = true;
        }

        @Override
        public boolean isLeaf() {
            return !this.isDirectory;
        }

        @Override
        public String toString() {
            Path name = this.getFilePath().getFileName();
            return name == null ? "DLFS Root" : name.toString();
        }
    }
}

