/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components.account;

import convex.api.Convex;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.wallet.AWalletEntry;
import convex.core.cvm.Address;
import convex.core.cvm.Symbols;
import convex.core.cvm.ops.Special;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Symbol;
import convex.core.exceptions.ResultException;
import convex.gui.components.BalanceLabel;
import convex.gui.components.ConnectPanel;
import convex.gui.components.DropdownMenu;
import convex.gui.components.account.AddressCombo;
import convex.gui.components.account.KeyPairCombo;
import convex.gui.keys.KeyRingPanel;
import convex.gui.keys.UnlockWalletDialog;
import convex.gui.utils.Toolkit;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountChooserPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger((String)AccountChooserPanel.class.getName());
    private JComboBox<String> modeCombo;
    public final AddressCombo addressCombo;
    public final KeyPairCombo keyCombo;
    private BalanceLabel balanceLabel;
    protected Convex convex;
    AWalletEntry previousSelection = null;

    public AccountChooserPanel(Convex convex) {
        this.convex = convex;
        MigLayout layout = new MigLayout();
        this.setLayout((LayoutManager)layout);
        JPanel mp = new JPanel();
        mp.setLayout((LayoutManager)new MigLayout());
        mp.add(new JLabel("Account:"));
        Address address = convex.getAddress();
        this.addressCombo = new AddressCombo();
        this.addressCombo.setSelectedItem(address);
        this.addressCombo.setToolTipText("Select Account for use");
        this.addressCombo.addItemListener(e -> this.updateAddress(this.addressCombo.getAddress()));
        mp.add(this.addressCombo);
        this.keyCombo = KeyPairCombo.forConvex(convex);
        this.keyCombo.setToolTipText("Select a key pair from your Keyring. This will be used to sign transactions.");
        this.keyCombo.addItemListener(e -> {
            AWalletEntry we = (AWalletEntry)e.getItem();
            if (e.getStateChange() == 2) {
                this.previousSelection = we;
                return;
            }
            this.setKeyPair(we);
        });
        mp.add(this.keyCombo);
        mp.add(new JLabel("Balance: "));
        this.balanceLabel = new BalanceLabel();
        this.balanceLabel.setToolTipText("Convex Coin balance of the currently selected Account");
        mp.add(this.balanceLabel);
        this.updateBalance(this.getAddress());
        this.add((Component)mp, "dock west");
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem clearSeqButton = new JMenuItem("Clear sequence", Toolkit.menuIcon(59861));
        clearSeqButton.addActionListener(e -> convex.clearSequence());
        popupMenu.add(clearSeqButton);
        JMenuItem setSeqButton = new JMenuItem("Set sequence...", Toolkit.menuIcon(59092));
        setSeqButton.addActionListener(e -> {
            try {
                long seq = convex.getSequence();
                String s = JOptionPane.showInputDialog(this, "Current sequence number is " + seq + ", so the next sequence number expected is " + (seq + 1L), "Enter next sequence number", 3);
                if (s == null) {
                    return;
                }
                long nextSeq = Long.parseLong(s);
                convex.setNextSequence(nextSeq);
                System.err.println("Sequence number set: " + convex.getSequence());
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(this, "Invalid sequence number");
            }
            catch (ResultException e1) {
                e1.printStackTrace();
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
            convex.clearSequence();
        });
        popupMenu.add(setSeqButton);
        JMenuItem reconnectButton = new JMenuItem("Reconnect", Toolkit.menuIcon(57687));
        reconnectButton.addActionListener(e -> {
            try {
                convex.reconnect();
            }
            catch (Exception ex) {
                log.info("Reconnect failed", (Throwable)ex);
            }
        });
        popupMenu.add(reconnectButton);
        JMenuItem connInfoButton = new JMenuItem("Connection Info...", Toolkit.menuIcon(57687));
        connInfoButton.addActionListener(e -> {
            try {
                ConnectPanel.showConnectionInfo(this, convex);
            }
            catch (Exception ex) {
                log.info("Reconnect failed", (Throwable)ex);
            }
        });
        popupMenu.add(connInfoButton);
        DropdownMenu dm = new DropdownMenu(popupMenu, Toolkit.SMALL_ICON_SIZE);
        this.add(dm);
        mp = new JPanel();
        mp.setLayout((LayoutManager)new MigLayout());
        mp.setBorder(null);
        this.modeCombo = new JComboBox();
        this.modeCombo.setToolTipText("Use Transact to execute transactions (uses Convex Coins).\n\nUse Query to compute results without changing on-chain state (free).\n\nUse Prepare to prepare the transcation without submitting.");
        this.modeCombo.addItem("Transact");
        this.modeCombo.addItem("Query");
        this.modeCombo.addItem("Prepare");
        this.modeCombo.setFocusable(false);
        if (convex.getKeyPair() == null) {
            this.modeCombo.setSelectedItem("Query");
        }
        mp.add(this.modeCombo);
        this.add((Component)mp, "dock east");
    }

    public Address getAddress() {
        return this.convex.getAddress();
    }

    public void updateAddress(Address a) {
        this.convex.setAddress(a);
        this.convex.query((ACell)Special.forSymbol((Symbol)Symbols.STAR_KEY)).thenAcceptAsync(r -> {
            if (r.isError()) {
                System.err.println("Account key query failed: " + String.valueOf(r));
                this.setKeyPair(null);
            } else {
                AccountKey ak = AccountKey.parse((Object)r.getValue());
                AWalletEntry we = KeyRingPanel.getKeyRingEntry(ak);
                this.setKeyPair(we);
            }
        });
        this.updateBalance();
    }

    public void setKeyPair(AWalletEntry we) {
        if (we != this.keyCombo.getWalletEntry()) {
            this.keyCombo.setSelectedItem(we);
            return;
        }
        System.err.println("Setting wallet entry:" + String.valueOf(we));
        if (we == null) {
            this.convex.setKeyPair(null);
        } else {
            AKeyPair kp;
            if (we.isLocked()) {
                boolean unlock = UnlockWalletDialog.offerUnlock(this, we);
                if (!unlock) {
                    this.keyCombo.setSelectedItem(this.previousSelection);
                    return;
                }
                kp = we.getKeyPair();
                we.lock();
            } else {
                kp = we.getKeyPair();
            }
            this.convex.setKeyPair(kp);
        }
    }

    public void updateBalance() {
        this.updateBalance(this.getAddress());
    }

    private void updateBalance(Address a) {
        try {
            this.convex.query((ACell)Special.get((String)"*balance*"), a).thenAccept(r -> this.balanceLabel.setFromResult((Result)r));
        }
        catch (NullPointerException t) {
            this.balanceLabel.setText(t.getClass().getName());
        }
    }

    public String getMode() {
        return (String)this.modeCombo.getSelectedItem();
    }

    public Convex getConvex() {
        return this.convex;
    }
}

