/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.FontUIResource;
import mdlaf.MaterialLookAndFeel;
import mdlaf.themes.MaterialOceanicTheme;
import mdlaf.themes.MaterialTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Toolkit {
    private static final Logger log = LoggerFactory.getLogger((String)Toolkit.class.getName());
    public static final ImageIcon LOCKED_ICON;
    public static final ImageIcon UNLOCKED_ICON;
    public static final ImageIcon WARNING;
    public static final ImageIcon CAKE;
    public static final ImageIcon CONVEX;
    public static final ImageIcon COG;
    public static final Font DEFAULT_FONT;
    public static final Font MONO_FONT;
    public static final Font SMALL_MONO_FONT;
    public static final Font SMALL_MONO_BOLD;

    public static ImageIcon scaledIcon(int size, String resourcePath) {
        URL imgURL = Toolkit.class.getResource(resourcePath);
        if (imgURL == null) {
            throw new Error("No image: " + resourcePath);
        }
        ImageIcon imageIcon = new ImageIcon(imgURL);
        Image image = imageIcon.getImage();
        image = image.getScaledInstance(size, size, 4);
        return new ImageIcon(image);
    }

    public static BufferedImage smoothResize(BufferedImage src, int w, int h) {
        BufferedImage newImage = new BufferedImage(w, h, 2);
        Graphics2D graphics = (Graphics2D)newImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics.drawImage(src, 0, 0, w, h, null);
        return newImage;
    }

    public static DocumentListener createDocumentListener(final Runnable a) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(a);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(a);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(a);
            }
        };
    }

    public static void init() {
    }

    public static Image getImage(URL resourceURL) {
        return java.awt.Toolkit.getDefaultToolkit().getImage(resourceURL);
    }

    static {
        try {
            UIManager.installLookAndFeel("Material", "mdlaf.MaterialLookAndFeel");
            Class.forName("mdlaf.MaterialLookAndFeel");
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                String name = info.getName();
                if (!name.equals("Nimbus")) continue;
                UIManager.setLookAndFeel(info.getClassName());
            }
            MaterialOceanicTheme theme = new MaterialOceanicTheme();
            MaterialLookAndFeel material = new MaterialLookAndFeel((MaterialTheme)theme);
            UIManager.setLookAndFeel((LookAndFeel)material);
            theme.setFontBold(new FontUIResource(theme.getFontBold().deriveFont(14.0f)));
            theme.setFontItalic(new FontUIResource(theme.getFontItalic().deriveFont(14.0f)));
            theme.setFontMedium(new FontUIResource(theme.getFontMedium().deriveFont(14.0f)));
            theme.setFontRegular(new FontUIResource(theme.getFontRegular().deriveFont(14.0f)));
            UIManager.getLookAndFeelDefaults().put("TextField.caretForeground", Color.white);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("Unable to set look and feel: {}", (Throwable)e);
        }
        LOCKED_ICON = Toolkit.scaledIcon(36, "/images/padlock.png");
        UNLOCKED_ICON = Toolkit.scaledIcon(36, "/images/padlock-open.png");
        WARNING = Toolkit.scaledIcon(36, "/images/ic_priority_high_black_36dp.png");
        CAKE = Toolkit.scaledIcon(36, "/images/ic_cake_black_36dp.png");
        CONVEX = Toolkit.scaledIcon(36, "/images/Convex.png");
        COG = Toolkit.scaledIcon(36, "/images/cog.png");
        DEFAULT_FONT = new JLabel().getFont();
        MONO_FONT = new Font("Monospaced", 1, 16);
        SMALL_MONO_FONT = new Font("Monospaced", 0, 10);
        SMALL_MONO_BOLD = SMALL_MONO_FONT.deriveFont(1);
    }
}

