/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.api.ConvexRemote;
import convex.core.Peer;
import convex.core.State;
import convex.core.data.AccountKey;
import convex.core.data.PeerStatus;
import convex.core.util.Text;
import convex.gui.components.models.StateModel;
import convex.gui.manager.PeerGUI;
import convex.peer.ConnectionManager;
import convex.peer.Server;
import java.net.InetSocketAddress;

public class PeerView {
    public ConvexRemote peerConnection = null;
    public Server peerServer = null;
    public StateModel<Peer> peerModel = new StateModel<Object>(null);
    public StateModel<State> stateModel = new StateModel<Object>(null);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.peerServer != null) {
            State state = PeerGUI.getLatestState();
            AccountKey paddr = this.peerServer.getPeerKey();
            sb.append("0x" + paddr.toChecksumHex() + "\n");
            sb.append("Local peer on: " + this.peerServer.getHostAddress() + " with store " + this.peerServer.getStore() + "\n");
            PeerStatus ps = state.getPeer(paddr);
            if (ps != null) {
                sb.append("Peer Stake:  " + Text.toFriendlyBalance((long)ps.getPeerStake()));
                sb.append("    ");
                sb.append("Delegated Stake:  " + Text.toFriendlyBalance((long)ps.getDelegatedStake()));
            }
            ConnectionManager cm = this.peerServer.getConnectionManager();
            sb.append("\n");
            sb.append("Connections: " + cm.getConnectionCount());
        } else if (this.peerConnection != null) {
            sb.append("Remote peer at: " + this.peerConnection.getRemoteAddress() + "\n");
        } else {
            sb.append("Unknown");
        }
        return sb.toString();
    }

    public Peer checkPeer() {
        if (this.peerServer != null) {
            Peer p = this.peerServer.getPeer();
            this.peerModel.setValue(p);
            if (p != null) {
                this.stateModel.setValue(p.getConsensusState());
            }
            return p;
        }
        return null;
    }

    public void close() {
        if (this.peerServer != null) {
            this.peerServer.close();
        }
        if (this.peerConnection != null) {
            this.peerConnection.close();
        }
    }

    public InetSocketAddress getHostAddress() {
        if (this.peerServer != null) {
            return this.peerServer.getHostAddress();
        }
        return this.peerConnection.getRemoteAddress();
    }

    public boolean isLocal() {
        return this.peerServer != null;
    }

    public StateModel<State> getStateModel() {
        return this.stateModel;
    }
}

