/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.windows.peer;

import convex.core.util.Text;
import convex.gui.components.ActionPanel;
import convex.gui.components.PeerView;
import convex.gui.utils.Toolkit;
import convex.peer.AThreadedComponent;
import convex.peer.Server;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class PeerInfoPanel
extends JPanel {
    private final JTextArea textArea;

    public PeerInfoPanel(final PeerView p) {
        this.setLayout(new BorderLayout(0, 0));
        ActionPanel panel = new ActionPanel();
        this.add((Component)panel, "South");
        JButton refreshButton = new JButton("Refresh");
        panel.add(refreshButton);
        JPanel panel_1 = new JPanel();
        this.add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setBackground(null);
        this.textArea.setFont(Toolkit.SMALL_MONO_FONT);
        int INTERVAL = 500;
        final Timer timer = new Timer(INTERVAL, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeerInfoPanel.this.updateState(p);
            }
        });
        timer.start();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent ce) {
                timer.stop();
            }

            @Override
            public void componentShown(ComponentEvent ce) {
                timer.start();
            }
        });
        panel_1.add(this.textArea);
        refreshButton.addActionListener(e -> this.updateState(p));
        this.updateState(p);
    }

    protected String lpad(Object s) {
        return Text.leftPad((String)s.toString(), (int)30);
    }

    private void updateState(PeerView p) {
        StringBuilder sb = new StringBuilder();
        Server s = p.peerServer;
        if (s == null) {
            sb.append("Not a local Peer");
        } else {
            sb.append("Running:              " + s.isLive() + "\n");
            sb.append("Key:                  " + s.getPeerKey() + "\n");
            sb.append("Address:              " + s.getHostAddress() + "\n");
            sb.append("\n");
            sb.append(s.getStatusVector() + "\n");
            sb.append("\n");
            sb.append("Transactions Pending: " + s.getTransactionHandler().countInterests());
            sb.append("\n");
            sb.append("Beliefs Sent:         " + s.getBeliefPropagator().getBeliefBroadcastCount() + "\n");
            sb.append("Beliefs Received:     " + s.getBeliefReceivedCount() + "\n");
            sb.append("\n");
            sb.append("Load averages:\n");
            sb.append("- Transaction handler:  " + this.load((AThreadedComponent)s.getTransactionHandler()) + "\n");
            sb.append("- Query handler:        " + this.load((AThreadedComponent)s.getQueryProcessor()) + "\n");
            sb.append("- Belief Propagator:    " + this.load((AThreadedComponent)s.getBeliefPropagator()) + "\n");
            sb.append("- CVM Executor:         " + this.load((AThreadedComponent)s.getCVMExecutor()) + "\n");
            sb.append("- Connection Manager:   " + this.load((AThreadedComponent)s.getConnectionManager()) + "\n");
        }
        this.textArea.setText(sb.toString());
    }

    private String load(AThreadedComponent comp) {
        double ld = comp.getLoad();
        return Text.leftPad((String)((long)(ld * 100.0) + "%"), (int)6);
    }
}

