/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.mainpanels;

import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.exceptions.ParseException;
import convex.core.lang.Reader;
import convex.core.util.Utils;
import convex.gui.components.ActionPanel;
import convex.gui.manager.PeerGUI;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MessageFormatPanel
extends JPanel {
    final JTextArea dataArea;
    final JTextArea messageArea;
    private JPanel buttonPanel;
    protected PeerGUI manager;
    private JButton clearButton;
    private JPanel upperPanel;
    private JPanel instructionsPanel;
    private JLabel lblNewLabel;
    private JTextField hashLabel;
    private static String HASHLABEL = "Hash: ";

    public MessageFormatPanel(PeerGUI manager) {
        this.manager = manager;
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.5);
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        this.upperPanel = new JPanel();
        this.upperPanel.setLayout(new BorderLayout(0, 0));
        this.dataArea = new JTextArea();
        this.dataArea.setToolTipText("Enter data objects here");
        this.upperPanel.add((Component)this.dataArea, "Center");
        this.dataArea.setFont(Toolkit.MONO_FONT);
        this.dataArea.setLineWrap(true);
        this.dataArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> this.updateData()));
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BorderLayout(0, 0));
        this.messageArea = new JTextArea();
        this.messageArea.setToolTipText("Enter binary hex representation here");
        this.messageArea.setFont(Toolkit.MONO_FONT);
        lowerPanel.add((Component)this.messageArea, "Center");
        splitPane.setRightComponent(lowerPanel);
        this.hashLabel = new JTextField(HASHLABEL);
        this.hashLabel.setToolTipText("Hash code of the data object's serilaised representation = Data Object ID");
        this.hashLabel.setBorder(null);
        this.hashLabel.setBackground(null);
        this.hashLabel.setFont(Toolkit.MONO_FONT);
        lowerPanel.add((Component)this.hashLabel, "South");
        this.messageArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> this.updateMessage()));
        splitPane.setLeftComponent(this.upperPanel);
        this.buttonPanel = new ActionPanel();
        this.add((Component)this.buttonPanel, "South");
        this.clearButton = new JButton("Clear");
        this.clearButton.setToolTipText("Press to clear the input areas");
        this.buttonPanel.add(this.clearButton);
        this.instructionsPanel = new JPanel();
        this.add((Component)this.instructionsPanel, "North");
        this.lblNewLabel = new JLabel("Use this fine tool to convert data values to encoded binary representations, and vice versa");
        this.instructionsPanel.add(this.lblNewLabel);
        this.clearButton.addActionListener(e -> {
            this.dataArea.setText("");
            this.messageArea.setText("");
        });
    }

    private void updateMessage() {
        if (!this.messageArea.isFocusOwner()) {
            return;
        }
        Object data = "";
        String msg = this.messageArea.getText();
        try {
            Blob b = Blob.fromHex((String)Utils.stripWhiteSpace((String)msg));
            ACell o = Format.read((Blob)b);
            data = Utils.print((Object)o);
            this.hashLabel.setText(HASHLABEL + b.getContentHash().toHexString());
        }
        catch (ParseException e) {
            data = "Unable to interpret message: " + e.getMessage();
            this.hashLabel.setText(HASHLABEL + " <invalid>");
        }
        catch (Exception e) {
            data = e.getMessage();
        }
        this.dataArea.setText((String)data);
    }

    private void updateData() {
        if (!this.dataArea.isFocusOwner()) {
            return;
        }
        String msg = "";
        String data = this.dataArea.getText();
        this.hashLabel.setText(HASHLABEL + " <invalid>");
        if (!data.isBlank()) {
            try {
                this.messageArea.setEnabled(false);
                ACell o = Reader.read((String)data);
                Blob b = Format.encodedBlob((ACell)o);
                this.hashLabel.setText(HASHLABEL + b.getContentHash().toHexString());
                msg = b.toHexString();
                this.messageArea.setEnabled(true);
            }
            catch (ParseException e) {
                msg = e.getMessage();
            }
            catch (Exception e) {
                msg = e.getMessage();
            }
        }
        this.messageArea.setText(msg);
    }
}

