/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import convex.core.State;
import convex.core.crypto.WalletEntry;
import convex.core.data.ABlob;
import convex.core.data.Address;
import convex.core.util.Text;
import convex.gui.components.BaseListComponent;
import convex.gui.components.CodeLabel;
import convex.gui.components.Identicon;
import convex.gui.components.UnlockWalletDialog;
import convex.gui.manager.PeerGUI;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletComponent
extends BaseListComponent {
    private static final Logger log = LoggerFactory.getLogger((String)WalletComponent.class.getName());
    Icon icon = Toolkit.LOCKED_ICON;
    JButton lockButton;
    WalletEntry walletEntry;
    JPanel buttons = new JPanel();
    private Address address;

    public WalletComponent(WalletEntry initialWalletEntry) {
        this.walletEntry = initialWalletEntry;
        this.address = this.walletEntry.getAddress();
        this.setLayout(new BorderLayout());
        this.lockButton = new JButton("");
        this.buttons.add(this.lockButton);
        this.lockButton.setIcon(this.walletEntry.isLocked() ? Toolkit.LOCKED_ICON : Toolkit.UNLOCKED_ICON);
        this.lockButton.addActionListener(e -> {
            if (this.walletEntry.isLocked()) {
                UnlockWalletDialog dialog = UnlockWalletDialog.show(this);
                char[] passPhrase = dialog.getPassPhrase();
                try {
                    this.walletEntry = this.walletEntry.unlock(passPhrase);
                    this.icon = Toolkit.UNLOCKED_ICON;
                }
                catch (Throwable e1) {
                    JOptionPane.showMessageDialog(this, "Unable to unlock wallet: " + e1.getMessage());
                }
            } else {
                try {
                    this.walletEntry = this.walletEntry.lock();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.icon = Toolkit.LOCKED_ICON;
            }
            this.lockButton.setIcon(this.icon);
        });
        this.add((Component)this.buttons, "East");
        Identicon identicon = new Identicon((ABlob)this.walletEntry.getAddress().getHash());
        GridBagConstraints gbc_btnNewButton = new GridBagConstraints();
        gbc_btnNewButton.insets = new Insets(0, 0, 5, 5);
        gbc_btnNewButton.gridx = 0;
        gbc_btnNewButton.gridy = 0;
        JPanel idPanel = new JPanel();
        idPanel.setLayout(new GridBagLayout());
        idPanel.add(identicon);
        this.add((Component)idPanel, "West");
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new GridLayout(0, 1));
        CodeLabel addressLabel = new CodeLabel(this.address.toString());
        addressLabel.setFont(Toolkit.MONO_FONT);
        cPanel.add(addressLabel);
        CodeLabel infoLabel = new CodeLabel(this.getInfoString());
        cPanel.add(infoLabel);
        this.add((Component)cPanel, "Center");
        PeerGUI.getStateModel().addPropertyChangeListener(e -> infoLabel.setText(this.getInfoString()));
    }

    private String getInfoString() {
        State s = PeerGUI.getLatestState();
        Long bal = s.getBalance(this.address);
        return "Balance: " + (bal == null ? "Null" : Text.toFriendlyNumber((long)s.getBalance(this.address)));
    }
}

