/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.windows.actor;

import convex.api.Convex;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.WalletEntry;
import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AVector;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Lists;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.lang.AFn;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.lang.Symbols;
import convex.core.lang.impl.Fn;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.gui.components.AccountChooserPanel;
import convex.gui.components.BaseListComponent;
import convex.gui.components.CodeLabel;
import convex.gui.components.Toast;
import convex.gui.manager.PeerGUI;
import convex.gui.manager.windows.actor.ActorInvokePanel;
import convex.gui.manager.windows.actor.ArgBox;
import convex.gui.manager.windows.actor.ParamLabel;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartOpComponent
extends BaseListComponent {
    protected ActorInvokePanel parent;
    protected Symbol sym;
    int paramCount;
    private HashMap<Integer, JTextField> paramFields = new HashMap();
    private static final Logger log = LoggerFactory.getLogger((String)SmartOpComponent.class.getName());

    public SmartOpComponent(ActorInvokePanel parent, Address contract, Symbol sym) {
        this.parent = parent;
        this.sym = sym;
        this.setFont(Toolkit.SMALL_MONO_FONT);
        this.setLayout(new BorderLayout(0, 0));
        CodeLabel opName = new CodeLabel(sym.toString());
        opName.setFont(Toolkit.MONO_FONT);
        this.add((Component)opName, "North");
        JPanel paramPanel = new JPanel();
        paramPanel.setLayout(new GridLayout(0, 3, 4, 4));
        AccountStatus as = PeerGUI.getLatestState().getAccount(contract);
        AFn fn = as.getCallableFunction(sym);
        AVector params = fn instanceof Fn ? ((Fn)fn).getParams() : Vectors.of((Object[])new Object[]{Symbols.FOO});
        this.paramCount = params.size();
        for (int i = 0; i < this.paramCount; ++i) {
            ACell paramSym = params.get(i);
            paramPanel.add(new ParamLabel(RT.str((ACell)paramSym)));
            ArgBox argBox = new ArgBox();
            paramPanel.add(argBox);
            this.paramFields.put(i, argBox);
            paramPanel.add(new JLabel(""));
        }
        paramPanel.add(new ParamLabel("<offer funds>"));
        ArgBox offerBox = new ArgBox();
        this.paramFields.put(null, offerBox);
        paramPanel.add(offerBox);
        paramPanel.add(new JLabel("Offer funds (0 or blank for no offer)"));
        this.add((Component)paramPanel, "Center");
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new FlowLayout(0));
        JButton execButton = new JButton("Execute");
        aPanel.add(execButton);
        execButton.addActionListener(e -> this.execute());
        this.add((Component)aPanel, "South");
    }

    private void execute() {
        InetSocketAddress addr = PeerGUI.getDefaultPeer().getHostAddress();
        AVector args = Vectors.empty();
        for (int i = 0; i < this.paramCount; ++i) {
            JTextField argBox = this.paramFields.get(i);
            String s = argBox.getText();
            ACell arg = s.isBlank() ? null : Reader.read((String)s);
            args = args.conj(arg);
        }
        String offerString = this.paramFields.get(null).getText();
        Long offer = offerString.isBlank() ? null : Long.valueOf(Long.parseLong(offerString.trim()));
        AList rest = Lists.of((Object[])new Object[]{Lists.create((List)args).cons((ACell)this.sym)});
        if (offer != null) {
            rest = rest.cons(RT.cvm((Object)offer));
        }
        try {
            AList message = RT.cons((ACell)Symbols.CALL, (ACell)this.parent.contract, (ACell)rest);
            AccountChooserPanel execPanel = this.parent.execPanel;
            WalletEntry we = execPanel.getWalletEntry();
            Address myAddress = we.getAddress();
            Convex peerConnection = Convex.connect((InetSocketAddress)addr, (Address)we.getAddress(), (AKeyPair)we.getKeyPair());
            String mode = execPanel.getMode();
            Result r = null;
            if (mode.equals("Query")) {
                r = peerConnection.querySync((ACell)message);
            } else if (mode.equals("Transact")) {
                if (we.isLocked()) {
                    JOptionPane.showMessageDialog(this, "Please select an unlocked wallet address to use for transactions before sending");
                    return;
                }
                Invoke trans = Invoke.create((Address)myAddress, (long)-1L, (ACell)message);
                r = peerConnection.transactSync((ATransaction)trans);
            } else {
                throw new Error("Unexpected mode: " + mode);
            }
            if (r.isError()) {
                this.showError(r.getErrorCode(), r.getValue());
            } else {
                this.showResult(r.getValue());
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage());
            Toast.display((JComponent)this.parent, "Unexpected Error: " + e.getMessage(), Toast.FAIL);
        }
    }

    private void showError(Object code, Object msg) {
        String resultString = "Error executing transaction: " + code + " " + msg;
        log.info(resultString);
        Toast.display((JComponent)this.parent, resultString, Toast.FAIL);
    }

    private void showResult(Object v) {
        String resultString = "Transaction executed successfully";
        log.info(resultString);
        Toast.display((JComponent)this.parent, resultString, Toast.SUCCESS);
    }
}

