/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.windows.actor;

import convex.core.State;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.gui.manager.PeerGUI;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ActorInfoPanel
extends JPanel {
    protected PeerGUI manager;
    protected Address actor;
    protected JTextArea infoArea;

    public ActorInfoPanel(PeerGUI manager, Address contract) {
        this.manager = manager;
        this.actor = contract;
        this.setLayout(new BorderLayout(0, 0));
        this.setPreferredSize(new Dimension(600, 400));
        this.infoArea = new JTextArea();
        this.add((Component)this.infoArea, "Center");
        this.infoArea.setBackground(null);
        this.infoArea.setFont(Toolkit.SMALL_MONO_FONT);
        PeerGUI.getStateModel().addPropertyChangeListener(e -> this.updateInfo((State)e.getNewValue()));
        this.updateInfo(PeerGUI.getLatestState());
    }

    private void updateInfo(State latestState) {
        StringBuilder sb = new StringBuilder();
        AccountStatus as = latestState.getAccount(this.actor);
        sb.append("Actor Address: " + this.actor.toHexString() + "\n");
        sb.append("Actor Balance: " + as.getBalance() + "\n");
        sb.append("\n");
        this.infoArea.setText(sb.toString());
    }
}

