/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components.models;

import convex.core.State;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Keyword;
import convex.core.data.MapEntry;
import convex.core.data.Symbol;
import convex.core.util.Utils;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class OracleTableModel
extends AbstractTableModel
implements TableModel {
    private State state;
    private Address oracle;
    Symbol LIST_S = Symbol.create((String)"*list*");
    Symbol RESULTS_S = Symbol.create((String)"*results*");
    Keyword DESC_K = Keyword.create((String)"desc");
    private static final String[] FIXED_COLS = new String[]{"Key", "Description", "Finalised?", "Value"};

    public OracleTableModel(State state, Address oracle) {
        this.state = state;
        this.oracle = oracle;
    }

    @Override
    public String getColumnName(int col) {
        if (col < FIXED_COLS.length) {
            return FIXED_COLS[col];
        }
        return "FOO";
    }

    @Override
    public int getRowCount() {
        AccountStatus as = this.state.getAccount(this.oracle);
        if (as == null) {
            System.err.println("Missing OracleTableModel account: " + this.oracle);
            return 0;
        }
        AMap list = (AMap)as.getEnvironmentValue(this.LIST_S);
        if (list == null) {
            System.err.println("OracleTableModel missing oracle list? in " + this.oracle);
            return 0;
        }
        return Utils.checkedInt((long)list.count());
    }

    @Override
    public int getColumnCount() {
        return FIXED_COLS.length;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public AMap<ACell, ACell> getList() {
        AHashMap env = this.state.getAccount(this.oracle).getEnvironment();
        AMap list = (AMap)env.get((ACell)this.LIST_S);
        return list;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AHashMap env = this.state.getAccount(this.oracle).getEnvironment();
        AMap list = (AMap)env.get((ACell)this.LIST_S);
        MapEntry me = list.entryAt((long)rowIndex);
        ACell key = me.getKey();
        switch (columnIndex) {
            case 0: {
                return key.toString();
            }
            case 1: {
                AMap data = (AMap)me.getValue();
                return data.get((ACell)this.DESC_K);
            }
            case 2: {
                boolean done = ((AMap)env.get((ACell)this.RESULTS_S)).containsKey(key);
                return done ? "Yes" : "No";
            }
            case 3: {
                AMap results = (AMap)env.get((ACell)this.RESULTS_S);
                MapEntry rme = results.getEntry(key);
                return rme == null ? "" : rme.getValue();
            }
        }
        return "";
    }

    public void setState(State newState) {
        if (this.state != newState) {
            this.state = newState;
            this.fireTableDataChanged();
        }
    }
}

