/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.manager.mainpanels;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.Ed25519KeyPair;
import convex.core.crypto.Mnemonic;
import convex.core.crypto.WalletEntry;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.util.Utils;
import convex.gui.components.ActionPanel;
import convex.gui.manager.PeerGUI;
import convex.gui.utils.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class KeyGenPanel
extends JPanel {
    JTextArea mnemonicArea;
    JTextArea privateKeyArea;
    JTextArea publicKeyArea;
    JTextArea addressArea;
    JButton addWalletButton = new JButton("Add to wallet");

    private String hexKeyFormat(String pk) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pk.length() / 32; ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            for (int j = 0; j < 4; ++j) {
                if (j > 0) {
                    sb.append(' ');
                }
                int ix = 8 * (j + i * 4);
                sb.append(pk.substring(ix, ix + 8));
            }
        }
        return sb.toString();
    }

    private void updateMnemonic() {
        String s = this.mnemonicArea.getText();
        try {
            byte[] bs = Mnemonic.decode((String)s, (int)128);
            Hash h = Blob.wrap((byte[])bs).getContentHash();
            AKeyPair kp = AKeyPair.create((byte[])h.getBytes());
            String privateKeyString = kp.getEncodedPrivateKey().toHexString();
            this.privateKeyArea.setText(this.hexKeyFormat(privateKeyString));
        }
        catch (Exception ex) {
            String pks = "<mnemonic not valid>";
            if (s.isBlank()) {
                pks = "<enter valid private key or mnemonic>";
            }
            this.privateKeyArea.setText(pks);
        }
        this.updatePublicKeys();
    }

    private void updatePrivateKey() {
        try {
            this.mnemonicArea.setText("<can't calculate from private key>");
            this.updatePublicKeys();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            return;
        }
    }

    private void updatePublicKeys() {
        String s = this.privateKeyArea.getText();
        try {
            Blob b = Blob.fromHex((String)Utils.stripWhiteSpace((String)s));
            Ed25519KeyPair kp = Ed25519KeyPair.create((byte[])b.getBytes());
            this.addressArea.setText(kp.getAccountKey().toChecksumHex());
            this.publicKeyArea.setText(this.hexKeyFormat(kp.getAccountKey().toChecksumHex()));
            this.addWalletButton.setEnabled(true);
        }
        catch (Exception ex) {
            this.addressArea.setText("<enter valid private key>");
            this.publicKeyArea.setText("<enter valid private key>");
            this.addWalletButton.setEnabled(false);
            return;
        }
    }

    public KeyGenPanel(PeerGUI manager) {
        this.setLayout(new BorderLayout(0, 0));
        ActionPanel actionPanel = new ActionPanel();
        this.add((Component)actionPanel, "South");
        JButton btnRecreate = new JButton("Generate");
        actionPanel.add(btnRecreate);
        btnRecreate.addActionListener(e -> {
            this.mnemonicArea.setText(Mnemonic.createSecureRandom());
            this.updateMnemonic();
        });
        JButton btnNewButton = new JButton("Export...");
        actionPanel.add(btnNewButton);
        actionPanel.add(this.addWalletButton);
        this.addWalletButton.addActionListener(e -> {
            String pks = this.privateKeyArea.getText();
            pks = Utils.stripWhiteSpace((String)pks);
            WalletEntry we = WalletEntry.create(null, (AKeyPair)AKeyPair.create((byte[])Utils.hexToBytes((String)pks)));
            manager.getWalletPanel().addWalletEntry(we);
            manager.switchPanel("Wallet");
        });
        JPanel formPanel = new JPanel();
        formPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)formPanel, "North");
        GridBagLayout gbl_formPanel = new GridBagLayout();
        gbl_formPanel.columnWidths = new int[]{156, 347, 0};
        gbl_formPanel.rowHeights = new int[]{22, 0, 0, 0, 0};
        gbl_formPanel.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gbl_formPanel.rowWeights = new double[]{0.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        formPanel.setLayout(gbl_formPanel);
        JLabel lblNewLabel = new JLabel("Mnenomic Phrase");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        formPanel.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.mnemonicArea = new JTextArea();
        this.mnemonicArea.setWrapStyleWord(true);
        this.mnemonicArea.setLineWrap(true);
        this.mnemonicArea.setRows(3);
        GridBagConstraints gbc_mnemonicArea = new GridBagConstraints();
        gbc_mnemonicArea.fill = 2;
        gbc_mnemonicArea.insets = new Insets(0, 0, 5, 0);
        gbc_mnemonicArea.gridx = 1;
        gbc_mnemonicArea.gridy = 0;
        this.mnemonicArea.setColumns(32);
        this.mnemonicArea.setFont(new Font("Monospaced", 1, 13));
        formPanel.add((Component)this.mnemonicArea, gbc_mnemonicArea);
        this.mnemonicArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> {
            if (!this.mnemonicArea.isFocusOwner()) {
                return;
            }
            this.updateMnemonic();
        }));
        JLabel lblPrivateKey = new JLabel("Private key");
        GridBagConstraints gbc_lblPrivateKey = new GridBagConstraints();
        gbc_lblPrivateKey.anchor = 17;
        gbc_lblPrivateKey.insets = new Insets(0, 0, 5, 5);
        gbc_lblPrivateKey.gridx = 0;
        gbc_lblPrivateKey.gridy = 1;
        formPanel.add((Component)lblPrivateKey, gbc_lblPrivateKey);
        this.privateKeyArea = new JTextArea();
        this.privateKeyArea.setFont(new Font("Monospaced", 1, 13));
        GridBagConstraints gbc_privateKeyArea = new GridBagConstraints();
        gbc_privateKeyArea.insets = new Insets(0, 0, 5, 0);
        gbc_privateKeyArea.fill = 2;
        gbc_privateKeyArea.gridx = 1;
        gbc_privateKeyArea.gridy = 1;
        formPanel.add((Component)this.privateKeyArea, gbc_privateKeyArea);
        this.privateKeyArea.setText("(mnemonic not ready)");
        this.privateKeyArea.getDocument().addDocumentListener(Toolkit.createDocumentListener(() -> {
            if (!this.privateKeyArea.isFocusOwner()) {
                return;
            }
            this.updatePrivateKey();
        }));
        JLabel lblPublicKey = new JLabel("Public Key");
        GridBagConstraints gbc_lblPublicKey = new GridBagConstraints();
        gbc_lblPublicKey.anchor = 17;
        gbc_lblPublicKey.insets = new Insets(0, 0, 5, 5);
        gbc_lblPublicKey.gridx = 0;
        gbc_lblPublicKey.gridy = 2;
        formPanel.add((Component)lblPublicKey, gbc_lblPublicKey);
        this.publicKeyArea = new JTextArea();
        this.publicKeyArea.setEditable(false);
        this.publicKeyArea.setRows(4);
        this.publicKeyArea.setText("(private key not ready)");
        this.publicKeyArea.setFont(new Font("Monospaced", 1, 13));
        GridBagConstraints gbc_publicKeyArea = new GridBagConstraints();
        gbc_publicKeyArea.insets = new Insets(0, 0, 5, 0);
        gbc_publicKeyArea.fill = 2;
        gbc_publicKeyArea.gridx = 1;
        gbc_publicKeyArea.gridy = 2;
        formPanel.add((Component)this.publicKeyArea, gbc_publicKeyArea);
        JLabel lblNewLabel_1 = new JLabel("Address");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.anchor = 17;
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel_1.gridx = 0;
        gbc_lblNewLabel_1.gridy = 3;
        formPanel.add((Component)lblNewLabel_1, gbc_lblNewLabel_1);
        this.addressArea = new JTextArea();
        this.addressArea.setEditable(false);
        this.addressArea.setFont(new Font("Monospaced", 1, 13));
        this.addressArea.setColumns(40);
        GridBagConstraints gbc_addressArea = new GridBagConstraints();
        gbc_addressArea.fill = 2;
        gbc_addressArea.gridx = 1;
        gbc_addressArea.gridy = 3;
        formPanel.add((Component)this.addressArea, gbc_addressArea);
    }
}

