/*
 * Decompiled with CFR 0.152.
 */
package convex.dlfs.impl;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.dlfs.DLFSNode;
import convex.dlfs.DLFileSystem;
import convex.dlfs.DLPath;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Set;

public class DLFileChannel
implements SeekableByteChannel {
    private boolean isOpen = true;
    private boolean readOnly = true;
    private long position = 0L;
    private DLPath path;
    private DLFileSystem fileSystem;

    private DLFileChannel(DLFileSystem fs, DLPath path) {
        this.fileSystem = fs;
        this.path = path;
    }

    public static DLFileChannel create(DLFileSystem fs, Set<? extends OpenOption> options, DLPath path) throws IOException {
        AVector<ACell> node = fs.getNode(path);
        boolean append = false;
        boolean truncate = false;
        boolean readOnly = true;
        if (options != null) {
            if (options.contains(StandardOpenOption.WRITE)) {
                readOnly = false;
            }
            if (options.contains(StandardOpenOption.CREATE_NEW) && node != null && !DLFSNode.isTombstone(node)) {
                throw new FileAlreadyExistsException(path.toString());
            }
            if (options.contains(StandardOpenOption.APPEND)) {
                append = true;
            }
            if (options.contains(StandardOpenOption.TRUNCATE_EXISTING)) {
                truncate = true;
            }
        }
        if (node == null || DLFSNode.isTombstone(node)) {
            if (readOnly) {
                throw new NoSuchFileException(path.toString());
            }
            node = fs.createFile(path);
        } else if (DLFSNode.getData(node) == null) {
            throw new NoSuchFileException(path.toString());
        }
        DLFileChannel fc = new DLFileChannel(fs, path);
        fc.readOnly = readOnly;
        if (truncate) {
            fc.truncate(0L);
        }
        if (append) {
            fc.position = DLFSNode.getData(node).count();
        }
        return fc;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        DLFileChannel dLFileChannel = this;
        synchronized (dLFileChannel) {
            this.checkOpen();
            ABlob data = this.getData();
            if (this.position >= data.count()) {
                return -1;
            }
            int read = data.toByteBuffer(this.position, dst);
            this.position += (long)read;
            return read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        DLFileChannel dLFileChannel = this;
        synchronized (dLFileChannel) {
            this.checkOpen();
            long pos = this.position;
            AVector<ACell> node = this.getNode();
            ABlob data = DLFSNode.getData(node);
            if (data == null) {
                throw new NoSuchFileException(this.path.toString());
            }
            if (data.count() < pos) {
                data = data.append(Blobs.createZero(pos - data.count()));
            }
            Blob b = Blob.fromByteBuffer(src);
            long n = b.count();
            ABlob newData = data.replaceSlice(pos, b);
            this.position = pos + n;
            if (newData != data) {
                ASequence newNode = node.assoc(1L, (ACell)newData);
                this.updateNode((AVector<ACell>)newNode);
            }
            return (int)n;
        }
    }

    protected AVector<ACell> updateNode(AVector<ACell> newNode) throws IOException {
        if (this.readOnly) {
            throw new NonWritableChannelException();
        }
        return this.fileSystem.updateNode(this.path, newNode);
    }

    @Override
    public long position() throws IOException {
        this.checkOpen();
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.checkOpen();
        if (newPosition < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        this.position = newPosition;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        DLFileSystem dLFileSystem = this.fileSystem;
        synchronized (dLFileSystem) {
            this.checkOpen();
            ABlob data = this.getData();
            return data.count();
        }
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen) {
            throw new ClosedChannelException();
        }
    }

    private ABlob getData() throws NoSuchFileException {
        AVector<ACell> node = this.getNode();
        return DLFSNode.getData(node);
    }

    private AVector<ACell> getNode() throws NoSuchFileException {
        AVector<ACell> node = this.fileSystem.getNode(this.path);
        if (node == null) {
            throw new NoSuchFileException(this.path.toString());
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        this.checkOpen();
        if (size < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        DLFileSystem dLFileSystem = this.fileSystem;
        synchronized (dLFileSystem) {
            AVector<ACell> node = this.getNode();
            ABlob data = DLFSNode.getData(node);
            if (data == null) {
                throw new NoSuchFileException(this.path.toString());
            }
            long newSize = Math.min(size, data.count());
            ABlob newData = data.slice(0L, newSize);
            if (newData != data) {
                ASequence newNode = node.assoc(1L, (ACell)newData);
                this.updateNode((AVector<ACell>)newNode);
            }
            this.position = 0L;
        }
        return this;
    }
}

