/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.cvm.Address;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.AString;
import convex.core.data.ASymbolic;
import convex.core.data.Blob;
import convex.core.data.Keyword;
import convex.core.data.MapEntry;
import convex.core.data.StringShort;
import convex.core.data.Strings;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.data.util.BlobBuilder;
import convex.core.json.JSONReader;
import convex.core.lang.RT;
import convex.core.text.Text;
import convex.core.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONUtils {
    private static final StringShort QUOTED_BACKSLASH = StringShort.create("\\\\");
    private static final StringShort QUOTED_QUOTES = StringShort.create("\\\"");
    private static final StringShort QUOTED_NEWLINE = StringShort.create("\\n");
    private static final StringShort QUOTED_RETURN = StringShort.create("\\r");
    private static final StringShort QUOTED_TAB = StringShort.create("\\t");
    private static final StringShort JS_NAN = StringShort.create("NaN");
    private static final char CONTROL_CHARS_END = '\u001f';

    public static <T> T json(ACell o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CVMLong) {
            return (T)Long.valueOf(((CVMLong)o).longValue());
        }
        if (o instanceof CVMDouble) {
            return (T)Double.valueOf(((CVMDouble)o).doubleValue());
        }
        if (o instanceof CVMBool) {
            return (T)Boolean.valueOf(((CVMBool)o).booleanValue());
        }
        if (o instanceof CVMChar) {
            return (T)((CVMChar)o).toString();
        }
        if (o instanceof Address) {
            return (T)Long.valueOf(((Address)o).longValue());
        }
        if (o instanceof AMap) {
            AMap m = (AMap)o;
            return (T)JSONUtils.jsonMap(m);
        }
        if (o instanceof ASequence) {
            ASequence seq = (ASequence)o;
            long n = seq.count();
            ArrayList<T> list = new ArrayList<T>();
            for (long i = 0L; i < n; ++i) {
                Object cvmv = seq.get(i);
                T v = JSONUtils.json(cvmv);
                list.add(v);
            }
            return (T)list;
        }
        return (T)o.toString();
    }

    public static String jsonKey(ACell k) {
        if (k instanceof AString) {
            return k.toString();
        }
        if (k instanceof Keyword) {
            return ((Keyword)k).getName().toString();
        }
        return RT.toString(k);
    }

    public static String jsonKey(Object o) {
        if (o instanceof ACell) {
            ACell cell = (ACell)o;
            return JSONUtils.jsonKey(cell);
        }
        if (o instanceof String) {
            String s = (String)o;
            return s;
        }
        throw new IllegalArgumentException("Invalid type for JSON key: " + Utils.getClassName(o));
    }

    public static HashMap<String, Object> jsonMap(AMap<?, ?> m) {
        int n = m.size();
        HashMap<String, Object> hm = new HashMap<String, Object>(n);
        for (long i = 0L; i < (long)n; ++i) {
            MapEntry<?, ?> me = m.entryAt(i);
            Object k = me.getKey();
            String sk = JSONUtils.jsonKey((ACell)k);
            Object v = JSONUtils.json((ACell)me.getValue());
            hm.put(sk, v);
        }
        return hm;
    }

    public static String toString(Object value) {
        return JSONUtils.toJSONString(value).toString();
    }

    public static ACell parse(String jsonString) {
        return JSONReader.read(jsonString);
    }

    public static AString toJSONString(Object value) {
        BlobBuilder bb = new BlobBuilder();
        JSONUtils.appendJSON(bb, value);
        return Strings.create(bb.toBlob());
    }

    private static void appendJSON(BlobBuilder bb, Object value) {
        if (value == null) {
            bb.append(Strings.NULL);
            return;
        }
        if (value instanceof ACell) {
            ACell cell = (ACell)value;
            JSONUtils.appendJSON(bb, cell);
            return;
        }
        if (value instanceof Map) {
            Map mv = (Map)value;
            bb.append('{');
            int i = 0;
            for (Map.Entry me : mv.entrySet()) {
                if (i > 0) {
                    bb.append(",");
                }
                JSONUtils.appendJSON(bb, JSONUtils.jsonKey(me.getKey()));
                bb.append(':');
                bb.append(' ');
                JSONUtils.appendJSON(bb, me.getValue());
                ++i;
            }
            bb.append('}');
            return;
        }
        if (value instanceof List) {
            List lv = (List)value;
            bb.append('[');
            int n = lv.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    bb.append(',');
                }
                JSONUtils.appendJSON(bb, lv.get(i));
            }
            bb.append(']');
            return;
        }
        if (value instanceof Boolean) {
            Boolean bv = (Boolean)value;
            bb.append(bv != false ? Strings.TRUE : Strings.FALSE);
            return;
        }
        if (value instanceof String) {
            String cs = (String)value;
            bb.append('\"');
            JSONUtils.appendCVMStringQuoted(bb, cs);
            bb.append('\"');
            return;
        }
        if (value instanceof Number) {
            Number nv = (Number)value;
            if (value instanceof Double) {
                Double dv = (Double)value;
                if (Double.isFinite(dv)) {
                    bb.append(nv.toString());
                    return;
                }
                if (Double.isNaN(dv)) {
                    bb.append(JS_NAN);
                } else {
                    if (dv < 0.0) {
                        bb.append('-');
                    }
                    bb.append("Infinity");
                }
                return;
            }
            bb.append(nv.toString());
            return;
        }
        throw new IllegalArgumentException("Can't print type as JSON: " + Utils.getClassName(value));
    }

    private static void appendJSON(BlobBuilder bb, ACell value) {
        if (value == null) {
            bb.append(Strings.NULL);
            return;
        }
        if (value instanceof AString) {
            AString cs = (AString)value;
            bb.append('\"');
            JSONUtils.appendCVMStringQuoted(bb, cs.toString());
            bb.append('\"');
            return;
        }
        if (value instanceof ASymbolic) {
            ASymbolic cs = (ASymbolic)value;
            JSONUtils.appendJSON(bb, cs.getName());
            return;
        }
        if (value instanceof AMap) {
            AMap mv = (AMap)value;
            bb.append('{');
            long n = mv.size();
            for (long i = 0L; i < n; ++i) {
                if (i > 0L) {
                    bb.append(',');
                }
                MapEntry me = mv.entryAt(i);
                JSONUtils.appendJSON(bb, JSONUtils.jsonKey((ACell)me.getKey()));
                bb.append(':');
                bb.append(' ');
                JSONUtils.appendJSON(bb, (ACell)me.getValue());
            }
            bb.append('}');
            return;
        }
        if (value instanceof ACollection) {
            ACollection lv = (ACollection)value;
            bb.append('[');
            long n = lv.count();
            for (long i = 0L; i < n; ++i) {
                if (i > 0L) {
                    bb.append(',');
                }
                JSONUtils.appendJSON(bb, lv.get(i));
            }
            bb.append(']');
            return;
        }
        if (value instanceof CVMLong) {
            CVMLong nv = (CVMLong)value;
            JSONUtils.appendJSON(bb, nv.longValue());
            return;
        }
        if (value instanceof ABlob) {
            ABlob bv = (ABlob)value;
            bb.append("\"0x");
            bb.append(bv.toHexString());
            bb.append('\"');
            return;
        }
        if (value instanceof CVMDouble) {
            CVMDouble nv = (CVMDouble)value;
            JSONUtils.appendJSON(bb, nv.doubleValue());
            return;
        }
        if (value instanceof CVMBool) {
            CVMBool bv = (CVMBool)value;
            bb.append(bv.booleanValue() ? Strings.TRUE : Strings.FALSE);
            return;
        }
        throw new IllegalArgumentException("Can't print as JSON: " + Utils.getClassName(value));
    }

    private static void appendCVMStringQuoted(BlobBuilder bb, CharSequence cs) {
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            char c = cs.charAt(i);
            AString rep = JSONUtils.getReplacementString(c);
            if (rep != null) {
                bb.append(rep);
                continue;
            }
            bb.append(c);
        }
    }

    private static AString getReplacementString(char c) {
        if (c == '\\') {
            return QUOTED_BACKSLASH;
        }
        if (c > '\"') {
            return null;
        }
        if (c == '\"') {
            return QUOTED_QUOTES;
        }
        if (c > '\u001f') {
            return null;
        }
        if (c == '\n') {
            return QUOTED_NEWLINE;
        }
        if (c == '\r') {
            return QUOTED_RETURN;
        }
        if (c == '\t') {
            return QUOTED_TAB;
        }
        return StringShort.create(Blob.wrap(new byte[]{92, 117, 48, 48, (byte)Utils.toHexChar(c >> 4 & 0xF), (byte)Utils.toHexChar(c & 0xF)}));
    }

    public static AString escape(String content) {
        BlobBuilder bb = new BlobBuilder();
        JSONUtils.appendCVMStringQuoted(bb, content);
        return Strings.create(bb.toBlob());
    }

    public static AString unescape(String content) {
        String unes = Text.unescapeJava(content);
        return Strings.create(unes);
    }
}

