/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.exceptions.BadFormatException;
import convex.core.message.Message;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class FileUtils {
    public static String loadFileAsString(String fileName) throws IOException {
        String result = null;
        if ("-".equals(fileName = fileName.trim())) {
            byte[] bs = System.in.readAllBytes();
            result = new String(bs);
        } else {
            Path path = Paths.get(fileName, new String[0]);
            if (!path.toFile().exists()) {
                throw new FileNotFoundException("File does not exist: " + String.valueOf(path));
            }
            result = Files.readString(path, StandardCharsets.UTF_8);
        }
        return result;
    }

    public static Blob loadFileAsBlob(Path file) throws IOException {
        return Blob.wrap(Files.readAllBytes(file));
    }

    public static byte[] loadFileAsBytes(Path file) throws IOException {
        return Files.readAllBytes(file);
    }

    public static <T extends ACell> T loadCAD3(Path file) throws IOException, BadFormatException {
        Blob b = FileUtils.loadFileAsBlob(file);
        return Message.create(b).getPayload();
    }

    public static void writeCAD3(Path file, ACell value) throws IOException {
        Message m = Message.create(null, value);
        Blob b = m.getMessageData();
        byte[] bs = b.getInternalArray();
        if ((long)bs.length != b.count()) {
            bs = b.getBytes();
        }
        Files.write(file, bs, new OpenOption[0]);
    }

    public static void writeFileAsString(Path file, String content) throws IOException {
        byte[] bs = content.getBytes(StandardCharsets.UTF_8);
        Files.write(file, bs, new OpenOption[0]);
    }

    public static File ensureFilePath(File file) throws IOException {
        File target = FileUtils.getFile(file.getPath());
        String dirPath = target.getParent();
        Files.createDirectories(Path.of(dirPath, new String[0]), new FileAttribute[0]);
        return target;
    }

    public static File getFile(String path) {
        if (path != null && ((String)path).startsWith("~")) {
            path = System.getProperty("user.home") + ((String)path).substring(1);
            return new File((String)path);
        }
        path = new File((String)path).getAbsolutePath();
        return new File((String)path);
    }
}

