/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lattice;

import convex.core.data.ACell;
import convex.core.lattice.ALattice;
import java.util.Comparator;

public class CompareLattice<V extends ACell>
extends ALattice<V> {
    private Comparator<V> comparator;

    private CompareLattice(Comparator<V> comparator) {
        this.comparator = comparator;
    }

    public static <V extends ACell> CompareLattice<V> create(Comparator<V> comparator) {
        return new CompareLattice<V>(comparator);
    }

    @Override
    public V merge(V ownValue, V otherValue) {
        if (otherValue == null) {
            return ownValue;
        }
        if (ownValue == null) {
            return otherValue;
        }
        if (this.comparator.compare(ownValue, otherValue) >= 0) {
            return ownValue;
        }
        return otherValue;
    }

    @Override
    public V zero() {
        return null;
    }

    @Override
    public boolean checkForeign(V value) {
        return value != null;
    }
}

