/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.Constants;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Strings;
import convex.core.data.prim.APrimitive;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.reader.ReaderUtils;
import convex.core.util.Bits;

public final class CVMChar
extends APrimitive
implements Comparable<CVMChar> {
    public static int MAX_CODEPOINT = 0x10FFFF;
    public static CVMChar MAX_VALUE = CVMChar.create(MAX_CODEPOINT);
    public static CVMChar BAD_CHARACTER = CVMChar.create(65533L);
    private static final int CACHE_SIZE = 256;
    private static final CVMChar[] cache = new CVMChar[256];
    public static final CVMChar ZERO;
    public static final int MAX_UTF_BYTES = 4;
    private final int value;

    private CVMChar(int value) {
        this.value = value;
        this.memorySize = 0L;
    }

    @Override
    public AType getType() {
        return Types.CHARACTER;
    }

    public static CVMChar create(long value) {
        if (value < 0L) {
            return null;
        }
        if (value < 256L) {
            return cache[(int)value];
        }
        if (value > (long)MAX_CODEPOINT) {
            return null;
        }
        return new CVMChar((int)value);
    }

    public static CVMChar fromUTF8(ABlobLike<?> b) {
        long n = b.count();
        if (n == 0L || n > 4L) {
            return null;
        }
        int v = (int)b.longValue() << (int)((4L - n) * 8L);
        int cp = CVMChar.codepointFromUTFInt(v);
        if ((long)CVMChar.utfLength(cp) != n) {
            return null;
        }
        return CVMChar.create(cp);
    }

    @Override
    public long longValue() {
        return 0xFFFFFFFFL & (long)this.value;
    }

    @Override
    public int estimatedEncodingSize() {
        return 4;
    }

    public static int byteCountFromTag(byte tag) {
        return (tag & 3) + 1;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    public static int codepointFromUTFInt(int utf) {
        byte b = (byte)(utf >> 24);
        if (b >= 0) {
            return b;
        }
        if ((b & 0xC0) != 192) {
            return -1;
        }
        int len = 2;
        if ((b & 0x20) == 32) {
            ++len;
            if ((b & 0x10) == 16) {
                ++len;
            }
        }
        if ((b << len & 0x80) != 0) {
            return -1;
        }
        int result = b & 127 >> len;
        for (int i = 1; i < len; ++i) {
            byte c = (byte)(utf >> 24 - 8 * i);
            if ((c & 0xC0) != 128) {
                return -1;
            }
            result = result << 6 | c & 0x3F;
        }
        if (!Character.isValidCodePoint(result)) {
            return -1;
        }
        return result;
    }

    private static int encodedCharLength(int c) {
        if ((c & 0xFFFF0000) == 0) {
            return (c & 0xFF00) == 0 ? 1 : 2;
        }
        return (c & 0xFF000000) == 0 ? 3 : 4;
    }

    public static int utfLength(long c) {
        if (c < 0L) {
            return -1;
        }
        if (c <= 127L) {
            return 1;
        }
        if (c <= 2047L) {
            return 2;
        }
        if (c <= 65535L) {
            return 3;
        }
        if (c <= (long)MAX_CODEPOINT) {
            return 4;
        }
        return -1;
    }

    public static CVMChar read(int len, Blob blob, int pos) throws BadFormatException {
        CVMChar result = CVMChar.readRaw(len, blob, pos + 1);
        result.attachEncoding(blob.slice(pos, pos + 1 + len));
        return result;
    }

    private static CVMChar readRaw(int len, Blob blob, int pos) throws BadFormatException {
        int value = -16777216;
        for (int i = 0; i < len; ++i) {
            if (value == 0) {
                throw new BadFormatException("Leading zero in CVMChar encoding");
            }
            byte b = blob.byteAt(pos + i);
            value = (value << 8) + (b & 0xFF);
        }
        CVMChar result = CVMChar.create(value);
        if (result == null) {
            throw new BadFormatException("CVMChar out of Unicode range");
        }
        return result;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        int len = CVMChar.encodedCharLength(this.value);
        bs[pos++] = this.getTag();
        return this.encodeRaw(len, bs, pos);
    }

    private int encodeRaw(int len, byte[] bs, int pos) {
        for (int i = 0; i < len; ++i) {
            bs[pos + i] = (byte)(this.value >> (len - 1 - i) * 8 & 0xFF);
        }
        return pos + len;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        throw new UnsupportedOperationException("Encoding requires a length in bytes");
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        switch (this.value) {
            case 10: {
                bb.append("\\newline");
                break;
            }
            case 13: {
                bb.append("\\return");
                break;
            }
            case 32: {
                bb.append("\\space");
                break;
            }
            case 9: {
                bb.append("\\tab");
                break;
            }
            default: {
                bb.append('\\');
                if (Character.isBmpCodePoint(this.value)) {
                    bb.append((char)this.value);
                    break;
                }
                bb.append(this.toUTFBytes());
            }
        }
        return bb.check(limit);
    }

    @Override
    public String toString() {
        if (Character.isValidCodePoint(this.value)) {
            return Character.toString(this.value);
        }
        return Constants.BAD_CHARACTER_STRING;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static CVMChar parse(String s) {
        int n = s.length();
        if (n < 2) {
            return null;
        }
        if (n == 2) {
            return CVMChar.create(s.charAt(1));
        }
        if (s.charAt(1) == 'u' && n == 6) {
            char c = (char)Long.parseLong(s.substring(2), 16);
            return CVMChar.create(c);
        }
        CVMChar maybeSpecial = ReaderUtils.specialCharacter(s = s.substring(1));
        if (maybeSpecial != null) {
            return maybeSpecial;
        }
        long cp = s.codePointAt(0);
        return CVMChar.create(cp);
    }

    @Override
    public byte getTag() {
        return (byte)(60 + (CVMChar.encodedCharLength(this.value) - 1));
    }

    public char charValue() {
        if (Character.isBmpCodePoint(this.value)) {
            return (char)this.value;
        }
        return '\ufffd';
    }

    public byte[] toUTFBytes() {
        int n = CVMChar.utfLength(this.value);
        if (n <= 0) {
            throw new Error("Shouldn't happen: CVMChar out of range: " + this.value);
        }
        byte[] bs = new byte[n];
        if (this.value < 128) {
            bs[0] = (byte)this.value;
            return bs;
        }
        bs[0] = (byte)(65280 >> n | this.value >> (n - 1) * 6);
        for (int i = 1; i < n; ++i) {
            bs[i] = (byte)(0x80 | 0x3F & this.value >> (n - 1 - i) * 6);
        }
        return bs;
    }

    public Blob toUTFBlob() {
        return Blob.wrap(this.toUTFBytes());
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit <= 0L) {
            return null;
        }
        return Strings.create(this.toUTFBlob());
    }

    public int getCodePoint() {
        return this.value;
    }

    @Override
    public int compareTo(CVMChar o) {
        return Integer.compare(this.value, o.value);
    }

    @Override
    public boolean equals(ACell a) {
        if (!(a instanceof CVMChar)) {
            return false;
        }
        return this.value == ((CVMChar)a).value;
    }

    public boolean equals(CVMChar a) {
        if (a == null) {
            return false;
        }
        return this.value == a.value;
    }

    @Override
    public int hashCode() {
        return Bits.hash32(this.value);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            CVMChar.cache[i] = new CVMChar(i);
        }
        ZERO = CVMChar.create(0L);
    }
}

