/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.ABlob;
import convex.core.data.prim.ANumeric;
import convex.core.data.prim.CVMBigInteger;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.TODOException;
import convex.core.util.Utils;
import java.math.BigInteger;

public abstract class AInteger
extends ANumeric {
    @Override
    public abstract boolean isCanonical();

    @Override
    public abstract AInteger toCanonical();

    public abstract AInteger inc();

    @Override
    public abstract CVMLong signum();

    public abstract AInteger dec();

    @Override
    public AType getType() {
        return Types.INTEGER;
    }

    public static AInteger parse(String s) {
        int n = s.length();
        if (n < 19) {
            return CVMLong.parse(s);
        }
        if (n > 20) {
            return CVMBigInteger.parse(s);
        }
        AInteger r = CVMLong.parse(s);
        if (r == null && (r = CVMBigInteger.parse(s)) != null) {
            r = r.toCanonical();
        }
        return r;
    }

    public static AInteger create(ABlob o) {
        if (o.count() <= 8L) {
            return CVMLong.create(o.longValue());
        }
        CVMBigInteger bi = CVMBigInteger.create(o);
        if (bi == null) {
            return null;
        }
        return (AInteger)bi.getCanonical();
    }

    public static AInteger parse(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof AInteger) {
            return (AInteger)o;
        }
        if (o instanceof Number) {
            return AInteger.create((Number)o);
        }
        return AInteger.parse(o.toString());
    }

    public abstract int byteLength();

    @Override
    public ANumeric add(ANumeric b) {
        if (b instanceof AInteger) {
            return this.add((AInteger)b);
        }
        return CVMDouble.create(this.doubleValue() + b.doubleValue());
    }

    public abstract AInteger add(AInteger var1);

    @Override
    public ANumeric sub(ANumeric b) {
        if (b instanceof AInteger) {
            return this.sub((AInteger)b);
        }
        return CVMDouble.create(this.doubleValue() - b.doubleValue());
    }

    public abstract AInteger sub(AInteger var1);

    public abstract BigInteger big();

    @Override
    public AInteger toInteger() {
        return this;
    }

    public static AInteger create(BigInteger bi) {
        if (bi == null) {
            return null;
        }
        int len = Utils.byteLength(bi);
        if (len <= 8) {
            return CVMLong.create(bi.longValue());
        }
        return CVMBigInteger.wrap(bi);
    }

    public static AInteger create(long value) {
        return CVMLong.create(value);
    }

    public static AInteger create(Number value) {
        if (value instanceof Long) {
            return CVMLong.create((long)((Long)value));
        }
        if (value instanceof BigInteger) {
            return AInteger.create((BigInteger)value);
        }
        return CVMLong.create(value.longValue());
    }

    public abstract AInteger mod(AInteger var1);

    public abstract AInteger div(AInteger var1);

    public abstract AInteger quot(AInteger var1);

    public abstract AInteger rem(AInteger var1);

    public abstract ABlob toBlob();

    public abstract boolean isLong();

    public AInteger toPower(AInteger power) {
        throw new TODOException();
    }
}

